/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.genetics.analyzer;

import forestry.api.apiculture.IBee;
import forestry.api.arboriculture.ITree;
import forestry.api.genetics.IIndividual;
import forestry.api.gui.GuiElementAlignment;
import forestry.api.gui.IElementGenetic;
import forestry.api.gui.IElementLayoutHelper;
import forestry.core.genetics.analyzer.DatabaseTab;
import forestry.core.gui.elements.GuiElementFactory;
import forestry.core.gui.elements.ItemElement;
import forestry.core.utils.Translator;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Supplier;
import net.minecraft.item.ItemStack;

public class ProductsTab
extends DatabaseTab {
    public ProductsTab(Supplier<ItemStack> stackSupplier) {
        super("products", stackSupplier);
    }

    @Override
    public void createElements(IElementGenetic container, IIndividual individual, ItemStack itemStack) {
        Collection<ItemStack> specialties;
        IElementLayoutHelper groupHelper = container.layoutHelper((x, y) -> GuiElementFactory.INSTANCE.createHorizontal(x + 4, y, 18).setDistance(2), 90, 0);
        Collection<ItemStack> products = this.getProducts(individual);
        if (!products.isEmpty()) {
            container.text(Translator.translateToLocal("for.gui.beealyzer.produce"), GuiElementAlignment.TOP_CENTER);
            products.forEach(product -> groupHelper.add(new ItemElement(0, 0, (ItemStack)product)));
            groupHelper.finish();
        }
        if ((specialties = this.getSpecialties(individual)).isEmpty()) {
            return;
        }
        container.text(Translator.translateToLocal("for.gui.beealyzer.specialty"), GuiElementAlignment.TOP_CENTER);
        specialties.forEach(specialty -> groupHelper.add(new ItemElement(0, 0, (ItemStack)specialty)));
        groupHelper.finish();
    }

    private Collection<ItemStack> getSpecialties(IIndividual individual) {
        if (individual instanceof IBee) {
            IBee bee = (IBee)individual;
            return bee.getSpecialtyList();
        }
        if (individual instanceof ITree) {
            ITree tree = (ITree)individual;
            return tree.getSpecialties().keySet();
        }
        return Collections.emptyList();
    }

    private Collection<ItemStack> getProducts(IIndividual individual) {
        if (individual instanceof IBee) {
            IBee bee = (IBee)individual;
            return bee.getProduceList();
        }
        if (individual instanceof ITree) {
            ITree tree = (ITree)individual;
            return tree.getProducts().keySet();
        }
        return Collections.emptyList();
    }
}

