/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.tiles;

import forestry.api.core.INbtWritable;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IAlleleSpecies;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.ISpeciesRoot;
import forestry.core.network.IStreamable;
import forestry.core.network.PacketBufferForestry;
import forestry.core.utils.ColourUtil;
import forestry.core.utils.Translator;
import java.io.IOException;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class EscritoireGameToken
implements INbtWritable,
IStreamable {
    private static final String[] OVERLAY_NONE = new String[0];
    private static final String[] OVERLAY_FAILED = new String[]{"errors/errored"};
    private static final String[] OVERLAY_SELECTED = new String[]{"errors/unknown"};
    @Nullable
    private IIndividual tokenIndividual;
    private ItemStack tokenStack = ItemStack.field_190927_a;
    private State state = State.UNREVEALED;

    public EscritoireGameToken(PacketBufferForestry data) throws IOException {
        this.readData(data);
    }

    public EscritoireGameToken(String speciesUid) {
        this.setTokenSpecies(speciesUid);
    }

    public EscritoireGameToken(NBTTagCompound nbttagcompound) {
        if (nbttagcompound.func_74764_b("state")) {
            int stateOrdinal = nbttagcompound.func_74762_e("state");
            this.state = State.values()[stateOrdinal];
        }
        if (nbttagcompound.func_74764_b("tokenSpecies")) {
            String speciesUid = nbttagcompound.func_74779_i("tokenSpecies");
            this.setTokenSpecies(speciesUid);
        }
    }

    private void setTokenSpecies(String speciesUid) {
        IAllele allele = AlleleManager.alleleRegistry.getAllele(speciesUid);
        if (allele instanceof IAlleleSpecies) {
            IAlleleSpecies species = (IAlleleSpecies)allele;
            ISpeciesRoot root = species.getRoot();
            IAllele[] template = root.getTemplate(species);
            this.tokenIndividual = root.templateAsIndividual(template);
            this.tokenStack = root.getMemberStack(this.tokenIndividual, root.getIconType());
        }
    }

    public ItemStack getTokenStack() {
        return this.tokenStack;
    }

    public boolean isVisible() {
        return this.state != State.UNREVEALED;
    }

    public boolean isProbed() {
        return this.state == State.PROBED;
    }

    public boolean isMatched() {
        return this.state == State.MATCHED;
    }

    public boolean isSelected() {
        return this.state == State.SELECTED;
    }

    public void setFailed() {
        this.state = State.FAILED;
    }

    public void setProbed(boolean probed) {
        this.state = probed ? State.PROBED : State.UNREVEALED;
    }

    public void setSelected() {
        this.state = State.SELECTED;
    }

    public void setMatched() {
        this.state = State.MATCHED;
    }

    public int getTokenColour() {
        if (this.tokenIndividual == null || !this.isVisible()) {
            return 0xFFFFFF;
        }
        int iconColor = this.tokenIndividual.getGenome().getPrimary().getSpriteColour(0);
        if (this.state == State.MATCHED) {
            return ColourUtil.multiplyRGBComponents(iconColor, 0.7f);
        }
        return iconColor;
    }

    public String getTooltip() {
        return !this.tokenStack.func_190926_b() ? this.tokenStack.func_82833_r() : Translator.translateToLocal("for.gui.unknown");
    }

    public String[] getOverlayIcons() {
        switch (this.state) {
            case FAILED: {
                return OVERLAY_FAILED;
            }
            case SELECTED: {
                return OVERLAY_SELECTED;
            }
        }
        return OVERLAY_NONE;
    }

    public boolean matches(EscritoireGameToken other) {
        return ItemStack.func_77989_b((ItemStack)this.tokenStack, (ItemStack)other.getTokenStack());
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound nbttagcompound) {
        nbttagcompound.func_74768_a("state", this.state.ordinal());
        if (this.tokenIndividual != null) {
            nbttagcompound.func_74778_a("tokenSpecies", this.tokenIndividual.getGenome().getPrimary().getUID());
        }
        return nbttagcompound;
    }

    @Override
    public void writeData(PacketBufferForestry data) {
        data.writeEnum(this.state, State.VALUES);
        if (this.tokenIndividual != null) {
            data.writeBoolean(true);
            data.func_180714_a(this.tokenIndividual.getGenome().getPrimary().getUID());
        } else {
            data.writeBoolean(false);
        }
    }

    @Override
    public void readData(PacketBufferForestry data) throws IOException {
        this.state = (State)data.readEnum(State.VALUES);
        if (data.readBoolean()) {
            String speciesUid = data.readString();
            this.setTokenSpecies(speciesUid);
        }
    }

    private static enum State {
        UNREVEALED,
        PROBED,
        SELECTED,
        MATCHED,
        FAILED;

        public static final State[] VALUES;

        static {
            VALUES = State.values();
        }
    }
}

