/*
 * Decompiled with CFR 0.152.
 */
package forestry.database;

import forestry.database.DatabaseFilterName;
import forestry.database.DatabaseFilterToolTip;
import forestry.database.DatabaseItem;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import net.minecraft.item.ItemStack;

public class DatabaseHelper {
    public static boolean ascending;
    public static final Comparator<DatabaseItem> SORT_BY_NAME;

    public static String getItemName(ItemStack itemStack) {
        try {
            String name = itemStack.func_82833_r();
            if (name == null || name.isEmpty()) {
                name = itemStack.func_77973_b().func_77667_c(itemStack);
            }
            return name == null ? "Null" : name;
        }
        catch (Exception errA) {
            try {
                String name = itemStack.func_77977_a();
                return name == null ? "Null" : name;
            }
            catch (Exception errB) {
                return "Exception";
            }
        }
    }

    public static void update(String searchText, List<DatabaseItem> items, ArrayList<DatabaseItem> sorted) {
        Pattern pattern;
        sorted.clear();
        sorted.ensureCapacity(items.size());
        try {
            pattern = Pattern.compile(searchText.toLowerCase(), 2);
        }
        catch (Throwable ignore) {
            try {
                pattern = Pattern.compile(Pattern.quote(searchText.toLowerCase()), 2);
            }
            catch (Throwable e) {
                return;
            }
        }
        List<Predicate<ItemStack>> filters = DatabaseHelper.getFilters(pattern, searchText);
        block4: for (DatabaseItem databaseItem : items) {
            ItemStack item = databaseItem.itemStack;
            String name = DatabaseHelper.getItemName(item);
            for (Predicate<ItemStack> filter : filters) {
                if (!filter.test(item)) continue;
                sorted.add(databaseItem);
                continue block4;
            }
        }
        sorted.sort(SORT_BY_NAME);
    }

    private static List<Predicate<ItemStack>> getFilters(Pattern pattern, String searchText) {
        LinkedList<Predicate<ItemStack>> filters = new LinkedList<Predicate<ItemStack>>();
        filters.add(new DatabaseFilterName(pattern));
        filters.add(new DatabaseFilterToolTip(pattern));
        return filters;
    }

    static {
        SORT_BY_NAME = (firstStack, secondStack) -> {
            if (firstStack.itemStack.func_190926_b() && !secondStack.itemStack.func_190926_b()) {
                return 1;
            }
            if (!firstStack.itemStack.func_190926_b() && secondStack.itemStack.func_190926_b()) {
                return -1;
            }
            if (ascending) {
                return DatabaseHelper.getItemName(firstStack.itemStack).compareToIgnoreCase(DatabaseHelper.getItemName(secondStack.itemStack));
            }
            return DatabaseHelper.getItemName(secondStack.itemStack).compareToIgnoreCase(DatabaseHelper.getItemName(firstStack.itemStack));
        };
    }
}

