/*
 * Decompiled with CFR 0.152.
 */
package forestry.energy.tiles;

import forestry.api.fuels.FuelManager;
import forestry.core.ModuleCore;
import forestry.core.blocks.BlockBase;
import forestry.core.errors.EnumErrorCode;
import forestry.core.inventory.AdjacentInventoryCache;
import forestry.core.inventory.IInventoryAdapter;
import forestry.core.inventory.wrappers.InventoryMapper;
import forestry.core.network.PacketBufferForestry;
import forestry.core.tiles.TemperatureState;
import forestry.core.tiles.TileEngine;
import forestry.core.utils.InventoryUtil;
import forestry.energy.gui.ContainerEnginePeat;
import forestry.energy.gui.GuiEnginePeat;
import forestry.energy.inventory.InventoryEnginePeat;
import java.io.IOException;
import java.util.Collection;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public class TileEnginePeat
extends TileEngine
implements ISidedInventory {
    private ItemStack fuel = ItemStack.field_190927_a;
    private int burnTime;
    private int totalBurnTime;
    private int ashProduction;
    private final int ashForItem;
    private final AdjacentInventoryCache inventoryCache = new AdjacentInventoryCache(this, this.getTileCache());

    public TileEnginePeat() {
        super("engine.copper", 10000, 200000);
        this.ashForItem = 7500;
        this.setInternalInventory(new InventoryEnginePeat(this));
    }

    private int getFuelSlot() {
        IInventoryAdapter inventory = this.getInternalInventory();
        if (inventory.func_70301_a(0).func_190926_b()) {
            return -1;
        }
        if (TileEnginePeat.determineFuelValue(inventory.func_70301_a(0)) > 0) {
            return 0;
        }
        return -1;
    }

    private int getFreeWasteSlot() {
        IInventoryAdapter inventory = this.getInternalInventory();
        for (int i = 1; i <= 4; ++i) {
            ItemStack waste = inventory.func_70301_a(i);
            if (waste.func_190926_b()) {
                return i;
            }
            if (waste.func_77973_b() != ModuleCore.getItems().ash || waste.func_190916_E() >= waste.func_77976_d()) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void updateServerSide() {
        super.updateServerSide();
        if (!this.updateOnInterval(40)) {
            return;
        }
        this.dumpStash();
        int fuelSlot = this.getFuelSlot();
        boolean hasFuel = fuelSlot >= 0 && TileEnginePeat.determineBurnDuration(this.getInternalInventory().func_70301_a(fuelSlot)) > 0;
        this.getErrorLogic().setCondition(!hasFuel, EnumErrorCode.NO_FUEL);
    }

    @Override
    public void burn() {
        this.currentOutput = 0;
        if (this.burnTime > 0) {
            --this.burnTime;
            this.addAsh(1);
            if (this.isRedstoneActivated()) {
                this.currentOutput = TileEnginePeat.determineFuelValue(this.fuel);
                this.energyManager.generateEnergy(this.currentOutput);
                this.field_145850_b.func_175666_e(this.field_174879_c, this.func_145838_q());
            }
        } else if (this.isRedstoneActivated()) {
            int fuelSlot = this.getFuelSlot();
            int wasteSlot = this.getFreeWasteSlot();
            if (fuelSlot >= 0 && wasteSlot >= 0) {
                IInventoryAdapter inventory = this.getInternalInventory();
                ItemStack fuelStack = inventory.func_70301_a(fuelSlot);
                this.burnTime = this.totalBurnTime = TileEnginePeat.determineBurnDuration(fuelStack);
                if (this.burnTime > 0 && !fuelStack.func_190926_b()) {
                    this.fuel = fuelStack.func_77946_l();
                    this.func_70298_a(fuelSlot, 1);
                }
            }
        }
    }

    @Override
    public int dissipateHeat() {
        TemperatureState tempState;
        if (this.heat <= 0) {
            return 0;
        }
        int loss = 0;
        if (!this.isBurning()) {
            ++loss;
        }
        if ((tempState = this.getTemperatureState()) == TemperatureState.OVERHEATING || tempState == TemperatureState.OPERATING_TEMPERATURE) {
            ++loss;
        }
        this.heat -= loss;
        return loss;
    }

    @Override
    public int generateHeat() {
        int heatToAdd = 0;
        if (this.isBurning()) {
            ++heatToAdd;
            if ((double)this.energyManager.getEnergyStored() / (double)this.energyManager.getMaxEnergyStored() > 0.5) {
                ++heatToAdd;
            }
        }
        this.addHeat(heatToAdd);
        return heatToAdd;
    }

    private void addAsh(int amount) {
        this.ashProduction += amount;
        if (this.ashProduction < this.ashForItem) {
            return;
        }
        int wasteSlot = this.getFreeWasteSlot();
        if (wasteSlot >= 0) {
            IInventoryAdapter inventory = this.getInternalInventory();
            ItemStack wasteStack = inventory.func_70301_a(wasteSlot);
            if (wasteStack.func_190926_b()) {
                inventory.func_70299_a(wasteSlot, ModuleCore.getItems().ash.getItemStack());
            } else {
                wasteStack.func_190917_f(1);
            }
        }
        this.ashProduction = 0;
        this.dumpStash();
    }

    private static int determineFuelValue(ItemStack fuel) {
        if (FuelManager.copperEngineFuel.containsKey(fuel)) {
            return FuelManager.copperEngineFuel.get(fuel).getPowerPerCycle();
        }
        return 0;
    }

    private static int determineBurnDuration(ItemStack fuel) {
        if (FuelManager.copperEngineFuel.containsKey(fuel)) {
            return FuelManager.copperEngineFuel.get(fuel).getBurnDuration();
        }
        return 0;
    }

    private IInventory getWasteInventory() {
        return new InventoryMapper((IInventory)this, 1, 4);
    }

    private void dumpStash() {
        IInventory wasteInventory = this.getWasteInventory();
        InvWrapper wasteItemHandler = new InvWrapper(wasteInventory);
        if (!InventoryUtil.moveOneItemToPipe((IItemHandler)wasteItemHandler, this.getTileCache())) {
            EnumFacing powerSide = (EnumFacing)this.field_145850_b.func_180495_p(this.func_174877_v()).func_177229_b(BlockBase.FACING);
            Collection<IItemHandler> inventories = this.inventoryCache.getAdjacentInventoriesOtherThan(powerSide);
            InventoryUtil.moveItemStack((IItemHandler)wasteItemHandler, inventories);
        }
    }

    @Override
    public boolean isBurning() {
        return this.mayBurn() && this.burnTime > 0;
    }

    @Override
    public int getBurnTimeRemainingScaled(int i) {
        if (this.totalBurnTime == 0) {
            return 0;
        }
        return this.burnTime * i / this.totalBurnTime;
    }

    @Override
    public boolean hasFuelMin(float percentage) {
        int fuelSlot = this.getFuelSlot();
        if (fuelSlot < 0) {
            return false;
        }
        IInventoryAdapter inventory = this.getInternalInventory();
        return (float)inventory.func_70301_a(fuelSlot).func_190916_E() / (float)inventory.func_70301_a(fuelSlot).func_77976_d() > percentage;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        if (nbttagcompound.func_74764_b("EngineFuelItemStack")) {
            NBTTagCompound fuelItemNbt = nbttagcompound.func_74775_l("EngineFuelItemStack");
            this.fuel = new ItemStack(fuelItemNbt);
        }
        this.burnTime = nbttagcompound.func_74762_e("EngineBurnTime");
        this.totalBurnTime = nbttagcompound.func_74762_e("EngineTotalTime");
        if (nbttagcompound.func_74764_b("AshProduction")) {
            this.ashProduction = nbttagcompound.func_74762_e("AshProduction");
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbttagcompound) {
        nbttagcompound = super.func_189515_b(nbttagcompound);
        if (!this.fuel.func_190926_b()) {
            nbttagcompound.func_74782_a("EngineFuelItemStack", (NBTBase)this.fuel.serializeNBT());
        }
        nbttagcompound.func_74768_a("EngineBurnTime", this.burnTime);
        nbttagcompound.func_74768_a("EngineTotalTime", this.totalBurnTime);
        nbttagcompound.func_74768_a("AshProduction", this.ashProduction);
        return nbttagcompound;
    }

    @Override
    public void writeGuiData(PacketBufferForestry data) {
        super.writeGuiData(data);
        data.writeInt(this.burnTime);
        data.writeInt(this.totalBurnTime);
    }

    @Override
    public void readGuiData(PacketBufferForestry data) throws IOException {
        super.readGuiData(data);
        this.burnTime = data.readInt();
        this.totalBurnTime = data.readInt();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiContainer getGui(EntityPlayer player, int data) {
        return new GuiEnginePeat(player.field_71071_by, this);
    }

    @Override
    public Container getContainer(EntityPlayer player, int data) {
        return new ContainerEnginePeat(player.field_71071_by, this);
    }
}

