/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming;

import com.google.common.base.Preconditions;
import forestry.Forestry;
import forestry.api.circuits.ChipsetManager;
import forestry.api.circuits.CircuitSocketType;
import forestry.api.circuits.ICircuitLayout;
import forestry.api.core.ForestryAPI;
import forestry.api.farming.IFarmProperties;
import forestry.api.farming.IFarmRegistry;
import forestry.api.modules.ForestryModule;
import forestry.core.ModuleCore;
import forestry.core.blocks.BlockBogEarth;
import forestry.core.blocks.BlockRegistryCore;
import forestry.core.circuits.CircuitLayout;
import forestry.core.circuits.Circuits;
import forestry.core.config.LocalizedConfiguration;
import forestry.core.items.EnumElectronTube;
import forestry.core.items.ItemRegistryCore;
import forestry.core.recipes.RecipeUtil;
import forestry.farming.DummyFarmRegistry;
import forestry.farming.FarmRegistry;
import forestry.farming.blocks.BlockMushroom;
import forestry.farming.blocks.BlockRegistryFarming;
import forestry.farming.blocks.EnumFarmBlockType;
import forestry.farming.circuits.CircuitFarmLogic;
import forestry.farming.logic.FarmLogicArboreal;
import forestry.farming.logic.FarmLogicCocoa;
import forestry.farming.logic.FarmLogicCrops;
import forestry.farming.logic.FarmLogicEnder;
import forestry.farming.logic.FarmLogicGourd;
import forestry.farming.logic.FarmLogicInfernal;
import forestry.farming.logic.FarmLogicMushroom;
import forestry.farming.logic.FarmLogicOrchard;
import forestry.farming.logic.FarmLogicPeat;
import forestry.farming.logic.FarmLogicReeds;
import forestry.farming.logic.FarmLogicSucculent;
import forestry.farming.logic.farmables.FarmableAgingCrop;
import forestry.farming.logic.farmables.FarmableChorus;
import forestry.farming.logic.farmables.FarmableGE;
import forestry.farming.logic.farmables.FarmableGourd;
import forestry.farming.logic.farmables.FarmableStacked;
import forestry.farming.logic.farmables.FarmableVanillaMushroom;
import forestry.farming.logic.farmables.FarmableVanillaSapling;
import forestry.farming.models.EnumFarmBlockTexture;
import forestry.farming.proxy.ProxyFarming;
import forestry.farming.tiles.TileFarmControl;
import forestry.farming.tiles.TileFarmGearbox;
import forestry.farming.tiles.TileFarmHatch;
import forestry.farming.tiles.TileFarmPlain;
import forestry.farming.tiles.TileFarmValve;
import forestry.farming.triggers.FarmingTriggers;
import forestry.modules.BlankForestryModule;
import forestry.modules.ModuleHelper;
import java.io.File;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBeetroot;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.BlockNetherWart;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@ForestryModule(containerID="forestry", moduleID="farming", name="Farming", author="SirSengir", url="http://forestry.sengir.net/", unlocalizedDescription="for.module.farming.description")
public class ModuleFarming
extends BlankForestryModule {
    @SidedProxy(clientSide="forestry.farming.proxy.ProxyFarmingClient", serverSide="forestry.farming.proxy.ProxyFarming")
    public static ProxyFarming proxy;
    @Nullable
    private static BlockRegistryFarming blocks;

    public static BlockRegistryFarming getBlocks() {
        Preconditions.checkState((blocks != null ? 1 : 0) != 0);
        return blocks;
    }

    @Override
    public void setupAPI() {
        ForestryAPI.farmRegistry = FarmRegistry.getInstance();
    }

    @Override
    public void disabledSetupAPI() {
        ForestryAPI.farmRegistry = new DummyFarmRegistry();
    }

    @Override
    public void registerItemsAndBlocks() {
        blocks = new BlockRegistryFarming();
    }

    @Override
    public void preInit() {
        ItemRegistryCore coreItems = ModuleCore.getItems();
        BlockRegistryFarming blocks = ModuleFarming.getBlocks();
        MinecraftForge.EVENT_BUS.register((Object)this);
        IFarmRegistry registry = ForestryAPI.farmRegistry;
        registry.registerFarmables("farmArboreal", new FarmableVanillaSapling());
        if (ModuleHelper.isEnabled("arboriculture")) {
            registry.registerFarmables("farmArboreal", new FarmableGE());
        }
        registry.registerFarmables("farmCrops", new FarmableAgingCrop(new ItemStack(Items.field_151014_N), Blocks.field_150464_aj, (IProperty<Integer>)BlockCrops.field_176488_a, 7, 0), new FarmableAgingCrop(new ItemStack(Items.field_151174_bG), Blocks.field_150469_bN, (IProperty<Integer>)BlockCrops.field_176488_a, 7, 0), new FarmableAgingCrop(new ItemStack(Items.field_151172_bF), Blocks.field_150459_bM, (IProperty<Integer>)BlockCrops.field_176488_a, 7, 0), new FarmableAgingCrop(new ItemStack(Items.field_185163_cU), Blocks.field_185773_cZ, (IProperty<Integer>)BlockBeetroot.field_185531_a, 3, 0));
        IBlockState plantedBrownMushroom = blocks.mushroom.func_176223_P().func_177226_a(BlockMushroom.VARIANT, (Comparable)((Object)BlockMushroom.MushroomType.BROWN));
        registry.registerFarmables("farmShroom", new FarmableVanillaMushroom(new ItemStack((Block)Blocks.field_150338_P), plantedBrownMushroom, Blocks.field_150420_aW));
        IBlockState plantedRedMushroom = blocks.mushroom.func_176223_P().func_177226_a(BlockMushroom.VARIANT, (Comparable)((Object)BlockMushroom.MushroomType.RED));
        registry.registerFarmables("farmShroom", new FarmableVanillaMushroom(new ItemStack((Block)Blocks.field_150337_Q), plantedRedMushroom, Blocks.field_150419_aX));
        registry.registerFarmables("farmGourd", new FarmableGourd(new ItemStack(Items.field_151080_bb), Blocks.field_150393_bb, Blocks.field_150423_aK));
        registry.registerFarmables("farmGourd", new FarmableGourd(new ItemStack(Items.field_151081_bc), Blocks.field_150394_bc, Blocks.field_150440_ba));
        registry.registerFarmables("farmInfernal", new FarmableAgingCrop(new ItemStack(Items.field_151075_bm), Blocks.field_150388_bm, (IProperty<Integer>)BlockNetherWart.field_176486_a, 3));
        registry.registerFarmables("farmPoales", new FarmableStacked(new ItemStack(Items.field_151120_aE), (Block)Blocks.field_150436_aH, 3));
        registry.registerFarmables("farmSucculentes", new FarmableStacked(new ItemStack((Block)Blocks.field_150434_aF), (Block)Blocks.field_150434_aF, 3));
        registry.registerFarmables("farmEnder", FarmableChorus.INSTANCE);
        registry.registerFertilizer(new ItemStack((Item)coreItems.fertilizerCompound, 1, Short.MAX_VALUE), 500);
        proxy.initializeModels();
        CircuitLayout layoutManaged = new CircuitLayout("farms.managed", CircuitSocketType.FARM);
        ChipsetManager.circuitRegistry.registerLayout(layoutManaged);
        CircuitLayout layoutManual = new CircuitLayout("farms.manual", CircuitSocketType.FARM);
        ChipsetManager.circuitRegistry.registerLayout(layoutManual);
    }

    @Override
    public void registerTriggers() {
        FarmingTriggers.initialize();
    }

    @Override
    public void doInit() {
        File configFile = new File(Forestry.instance.getConfigFolder(), "farm.cfg");
        LocalizedConfiguration config = new LocalizedConfiguration(configFile, "1.0.0");
        FarmRegistry.getInstance().loadConfig(config);
        config.save();
        GameRegistry.registerTileEntity(TileFarmPlain.class, (String)"forestry.Farm");
        GameRegistry.registerTileEntity(TileFarmGearbox.class, (String)"forestry.FarmGearbox");
        GameRegistry.registerTileEntity(TileFarmHatch.class, (String)"forestry.FarmHatch");
        GameRegistry.registerTileEntity(TileFarmValve.class, (String)"forestry.FarmValve");
        GameRegistry.registerTileEntity(TileFarmControl.class, (String)"forestry.FarmControl");
        FarmRegistry registry = FarmRegistry.getInstance();
        BlockRegistryCore coreBlocks = ModuleCore.getBlocks();
        IFarmProperties arborealFarm = registry.registerLogic("farmArboreal", FarmLogicArboreal::new, new String[0]);
        IFarmProperties cropsFarm = registry.registerLogic("farmCrops", FarmLogicCrops::new, new String[0]);
        IFarmProperties mushroomFarm = registry.registerLogic("farmShroom", FarmLogicMushroom::new, new String[0]);
        IFarmProperties succulentFarm = registry.registerLogic("farmSucculentes", FarmLogicSucculent::new, new String[0]);
        IFarmProperties peatFarm = registry.registerLogic("farmPeat", FarmLogicPeat::new, new String[0]);
        IFarmProperties infernalFarm = registry.registerLogic("farmInfernal", FarmLogicInfernal::new, new String[0]);
        IFarmProperties poalesFarm = registry.registerLogic("farmPoales", FarmLogicReeds::new, new String[0]);
        IFarmProperties orchardFarm = registry.registerLogic("farmOrchard", FarmLogicOrchard::new, new String[0]);
        IFarmProperties gourdFarm = registry.registerLogic("farmGourd", FarmLogicGourd::new, new String[0]);
        IFarmProperties cocoaFarm = registry.registerLogic("farmCocoa", FarmLogicCocoa::new, new String[0]);
        IFarmProperties enderFarm = registry.registerLogic("farmEnder", FarmLogicEnder::new, new String[0]);
        Circuits.farmArborealManaged = new CircuitFarmLogic("managedArboreal", arborealFarm, false);
        Circuits.farmArborealManual = new CircuitFarmLogic("manualArboreal", arborealFarm, true);
        arborealFarm.registerSoil(new ItemStack(Blocks.field_150346_d), coreBlocks.humus.func_176223_P());
        arborealFarm.registerSoil(new ItemStack((Block)coreBlocks.humus), coreBlocks.humus.func_176223_P());
        Circuits.farmShroomManaged = new CircuitFarmLogic("managedShroom", mushroomFarm, false);
        Circuits.farmShroomManual = new CircuitFarmLogic("manualShroom", mushroomFarm, true);
        mushroomFarm.registerSoil(new ItemStack((Block)Blocks.field_150391_bh), Blocks.field_150391_bh.func_176223_P());
        mushroomFarm.registerSoil(new ItemStack(Blocks.field_150346_d, 1, 2), Blocks.field_150346_d.func_176223_P().func_177226_a((IProperty)BlockDirt.field_176386_a, (Comparable)BlockDirt.DirtType.PODZOL), true);
        Circuits.farmPeatManaged = new CircuitFarmLogic("managedPeat", peatFarm, false);
        Circuits.farmPeatManual = new CircuitFarmLogic("manualPeat", peatFarm, true);
        peatFarm.registerSoil(coreBlocks.bogEarth.get(BlockBogEarth.SoilType.BOG_EARTH, 1), coreBlocks.bogEarth.func_176223_P());
        Circuits.farmCropsManaged = new CircuitFarmLogic("managedCrops", cropsFarm, false);
        Circuits.farmCropsManual = new CircuitFarmLogic("manualCrops", cropsFarm, true);
        cropsFarm.registerSoil(new ItemStack(Blocks.field_150346_d), Blocks.field_150458_ak.func_176223_P());
        cocoaFarm.registerFarmables("farmWheat");
        Circuits.farmInfernalManaged = new CircuitFarmLogic("managedInfernal", infernalFarm, false);
        Circuits.farmInfernalManual = new CircuitFarmLogic("manualInfernal", infernalFarm, true);
        infernalFarm.registerSoil(new ItemStack(Blocks.field_150425_aM), Blocks.field_150425_aM.func_176223_P());
        Circuits.farmOrchardManaged = new CircuitFarmLogic("managedOrchard", orchardFarm, false);
        Circuits.farmOrchardManual = new CircuitFarmLogic("manualOrchard", orchardFarm, true);
        Circuits.farmSucculentManaged = new CircuitFarmLogic("managedSucculent", succulentFarm, false);
        Circuits.farmSucculentManual = new CircuitFarmLogic("manualSucculent", succulentFarm, true);
        succulentFarm.registerSoil(new ItemStack((Block)Blocks.field_150354_m), Blocks.field_150354_m.func_176223_P(), true);
        Circuits.farmPoalesManaged = new CircuitFarmLogic("managedPoales", poalesFarm, false);
        Circuits.farmPoalesManual = new CircuitFarmLogic("manualPoales", poalesFarm, true);
        poalesFarm.registerSoil(new ItemStack((Block)Blocks.field_150354_m), Blocks.field_150354_m.func_176223_P(), true);
        poalesFarm.registerSoil(new ItemStack(Blocks.field_150346_d), Blocks.field_150346_d.func_176223_P(), false);
        Circuits.farmGourdManaged = new CircuitFarmLogic("managedGourd", gourdFarm, false);
        Circuits.farmGourdManual = new CircuitFarmLogic("manualGourd", gourdFarm, true);
        Circuits.farmCocoaManaged = new CircuitFarmLogic("managedCocoa", cocoaFarm, false);
        Circuits.farmCocoaManual = new CircuitFarmLogic("manualCocoa", cocoaFarm, true);
        Circuits.farmEnderManaged = new CircuitFarmLogic("managedEnder", enderFarm, false);
        Circuits.farmEnderManual = new CircuitFarmLogic("manualEnder", enderFarm, true);
        enderFarm.registerSoil(new ItemStack(Blocks.field_150377_bs), Blocks.field_150377_bs.func_176223_P());
    }

    @Override
    public void registerRecipes() {
        ItemRegistryCore coreItems = ModuleCore.getItems();
        BlockRegistryFarming blocks = ModuleFarming.getBlocks();
        ItemStack basic = blocks.farm.get(EnumFarmBlockType.PLAIN, 1);
        ItemStack gearbox = blocks.farm.get(EnumFarmBlockType.GEARBOX, 1);
        ItemStack hatch = blocks.farm.get(EnumFarmBlockType.HATCH, 1);
        ItemStack valve = blocks.farm.get(EnumFarmBlockType.VALVE, 1);
        ItemStack control = blocks.farm.get(EnumFarmBlockType.CONTROL, 1);
        for (EnumFarmBlockTexture block : EnumFarmBlockTexture.values()) {
            NBTTagCompound compound = new NBTTagCompound();
            block.saveToCompound(compound);
            basic.func_77982_d(compound);
            gearbox.func_77982_d(compound);
            hatch.func_77982_d(compound);
            valve.func_77982_d(compound);
            control.func_77982_d(compound);
            RecipeUtil.addRecipe("farm_basic_" + block.getUid(), basic, "I#I", "WCW", Character.valueOf('#'), block.getBase(), Character.valueOf('W'), "slabWood", Character.valueOf('C'), coreItems.tubes.get(EnumElectronTube.TIN, 1), Character.valueOf('I'), "ingotCopper");
            RecipeUtil.addRecipe("farm_gearbox_" + block.getUid(), gearbox, " # ", "TTT", Character.valueOf('#'), basic, Character.valueOf('T'), "gearTin");
            RecipeUtil.addRecipe("farm_hatch_" + block.getUid(), hatch, " # ", "TDT", Character.valueOf('#'), basic, Character.valueOf('T'), "gearTin", Character.valueOf('D'), "trapdoorWood");
            RecipeUtil.addRecipe("farm_valve_" + block.getUid(), valve, " # ", "XTX", Character.valueOf('#'), basic, Character.valueOf('T'), "gearTin", Character.valueOf('X'), "blockGlass");
            RecipeUtil.addRecipe("farm_control_" + block.getUid(), control, " # ", "XTX", Character.valueOf('#'), basic, Character.valueOf('T'), coreItems.tubes.get(EnumElectronTube.GOLD, 1), Character.valueOf('X'), "dustRedstone");
        }
        ICircuitLayout layoutManaged = ChipsetManager.circuitRegistry.getLayout("forestry.farms.managed");
        ICircuitLayout layoutManual = ChipsetManager.circuitRegistry.getLayout("forestry.farms.manual");
        ChipsetManager.circuitRegistry.registerDeprecatedCircuitReplacement("managedCereal", Circuits.farmCropsManaged);
        ChipsetManager.circuitRegistry.registerDeprecatedCircuitReplacement("manualCereal", Circuits.farmCropsManual);
        ChipsetManager.circuitRegistry.registerDeprecatedCircuitReplacement("managedVegetable", Circuits.farmCropsManaged);
        ChipsetManager.circuitRegistry.registerDeprecatedCircuitReplacement("manualVegetable", Circuits.farmCropsManual);
        if (layoutManaged == null || layoutManual == null) {
            return;
        }
        ChipsetManager.solderManager.addRecipe(layoutManaged, coreItems.tubes.get(EnumElectronTube.GOLD, 1), Circuits.farmArborealManaged);
        ChipsetManager.solderManager.addRecipe(layoutManaged, coreItems.tubes.get(EnumElectronTube.COPPER, 1), Circuits.farmSucculentManaged);
        ChipsetManager.solderManager.addRecipe(layoutManaged, coreItems.tubes.get(EnumElectronTube.OBSIDIAN, 1), Circuits.farmPeatManaged);
        ChipsetManager.solderManager.addRecipe(layoutManaged, coreItems.tubes.get(EnumElectronTube.BRONZE, 1), Circuits.farmCropsManaged);
        ChipsetManager.solderManager.addRecipe(layoutManaged, coreItems.tubes.get(EnumElectronTube.BLAZE, 1), Circuits.farmInfernalManaged);
        ChipsetManager.solderManager.addRecipe(layoutManaged, coreItems.tubes.get(EnumElectronTube.TIN, 1), Circuits.farmPoalesManual);
        ChipsetManager.solderManager.addRecipe(layoutManaged, coreItems.tubes.get(EnumElectronTube.LAPIS, 1), Circuits.farmGourdManaged);
        ChipsetManager.solderManager.addRecipe(layoutManaged, coreItems.tubes.get(EnumElectronTube.APATITE, 1), Circuits.farmShroomManaged);
        ChipsetManager.solderManager.addRecipe(layoutManaged, coreItems.tubes.get(EnumElectronTube.DIAMOND, 1), Circuits.farmCocoaManaged);
        ChipsetManager.solderManager.addRecipe(layoutManaged, coreItems.tubes.get(EnumElectronTube.EMERALD, 1), Circuits.farmOrchardManaged);
        ChipsetManager.solderManager.addRecipe(layoutManaged, coreItems.tubes.get(EnumElectronTube.ENDER, 1), Circuits.farmEnderManaged);
        ChipsetManager.solderManager.addRecipe(layoutManual, coreItems.tubes.get(EnumElectronTube.GOLD, 1), Circuits.farmArborealManual);
        ChipsetManager.solderManager.addRecipe(layoutManual, coreItems.tubes.get(EnumElectronTube.COPPER, 1), Circuits.farmSucculentManual);
        ChipsetManager.solderManager.addRecipe(layoutManual, coreItems.tubes.get(EnumElectronTube.OBSIDIAN, 1), Circuits.farmPeatManual);
        ChipsetManager.solderManager.addRecipe(layoutManual, coreItems.tubes.get(EnumElectronTube.BRONZE, 1), Circuits.farmCropsManual);
        ChipsetManager.solderManager.addRecipe(layoutManual, coreItems.tubes.get(EnumElectronTube.TIN, 1), Circuits.farmPoalesManual);
        ChipsetManager.solderManager.addRecipe(layoutManual, coreItems.tubes.get(EnumElectronTube.LAPIS, 1), Circuits.farmGourdManual);
        ChipsetManager.solderManager.addRecipe(layoutManual, coreItems.tubes.get(EnumElectronTube.APATITE, 1), Circuits.farmShroomManual);
        ChipsetManager.solderManager.addRecipe(layoutManual, coreItems.tubes.get(EnumElectronTube.DIAMOND, 1), Circuits.farmCocoaManual);
        ChipsetManager.solderManager.addRecipe(layoutManual, coreItems.tubes.get(EnumElectronTube.EMERALD, 1), Circuits.farmOrchardManual);
        ChipsetManager.solderManager.addRecipe(layoutManual, coreItems.tubes.get(EnumElectronTube.ENDER, 1), Circuits.farmEnderManual);
    }

    @Override
    public void getHiddenItems(List<ItemStack> hiddenItems) {
        hiddenItems.add(new ItemStack((Block)ModuleFarming.getBlocks().mushroom, 1, Short.MAX_VALUE));
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void handleTextureRemap(TextureStitchEvent.Pre event) {
        EnumFarmBlockType.registerSprites();
    }
}

