/*
 * Decompiled with CFR 0.152.
 */
package forestry.greenhouse.blocks;

import com.google.common.base.Predicate;
import forestry.api.core.IItemModelRegister;
import forestry.api.core.IModelManager;
import forestry.core.blocks.IBlockRotatable;
import forestry.core.blocks.properties.UnlistedBlockAccess;
import forestry.core.blocks.properties.UnlistedBlockPos;
import forestry.core.tiles.IActivatable;
import forestry.core.tiles.TileUtil;
import forestry.core.utils.Log;
import forestry.greenhouse.ModuleGreenhouse;
import forestry.greenhouse.api.greenhouse.GreenhouseManager;
import forestry.greenhouse.blocks.State;
import forestry.greenhouse.tiles.TileGreenhouseWindow;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockGreenhouseWindow
extends Block
implements IBlockRotatable,
ITileEntityProvider,
IItemModelRegister {
    public static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);
    private boolean roofWindow;

    public BlockGreenhouseWindow(boolean roofWindow) {
        super(Material.field_151576_e);
        IBlockState defaultState = this.field_176227_L.func_177621_b();
        this.func_180632_j(defaultState.func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
        this.func_149711_c(1.0f);
        this.setHarvestLevel("pickaxe", 0);
        this.func_149647_a(ModuleGreenhouse.getGreenhouseTab());
        this.func_149672_a(SoundType.field_185853_f);
        this.roofWindow = roofWindow;
    }

    public ItemStack getItem(String glass) {
        ItemStack stack = new ItemStack((Block)this);
        NBTTagCompound tagCompound = new NBTTagCompound();
        tagCompound.func_74778_a("Glass", glass);
        stack.func_77982_d(tagCompound);
        return stack;
    }

    protected int getPlaySound(boolean open) {
        if (open) {
            return 1007;
        }
        return 1013;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.field_82609_l[meta + 2]);
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).ordinal() - 2;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        TileEntity tile = TileUtil.getTile(worldIn, pos, TileEntity.class);
        if (tile instanceof IActivatable) {
            state = state.func_177226_a(State.PROPERTY, (Comparable)((Object)(((IActivatable)tile).isActive() ? State.ON : State.OFF)));
        }
        return super.func_176221_a(state, worldIn, pos);
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        return state.func_177226_a((IProperty)FACING, (Comparable)rot.func_185831_a(facing));
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @Deprecated
    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        try {
            TileUtil.actOnTile((IBlockAccess)worldIn, pos, TileGreenhouseWindow.class, TileGreenhouseWindow::onNeighborBlockChange);
        }
        catch (StackOverflowError error) {
            Log.error("Stack Overflow Error in BlockMachine.onNeighborBlockChange()", error);
            throw error;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (playerIn.func_70093_af()) {
            return false;
        }
        TileGreenhouseWindow window = TileUtil.getTile((IBlockAccess)worldIn, pos, TileGreenhouseWindow.class);
        if (window == null) {
            return false;
        }
        if (playerIn.func_184614_ca().func_190926_b() && window.getMode() != TileGreenhouseWindow.WindowMode.CONTROL) {
            if (!worldIn.field_72995_K && window.isBlocked() == TileGreenhouseWindow.WindowMode.OPEN) {
                if (window.getMode() == TileGreenhouseWindow.WindowMode.OPEN) {
                    window.setMode(TileGreenhouseWindow.WindowMode.PLAYER);
                } else {
                    window.setMode(TileGreenhouseWindow.WindowMode.OPEN);
                }
            }
            worldIn.func_180498_a(playerIn, this.getPlaySound(!window.isActive()), pos, 0);
            return true;
        }
        return false;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.func_180633_a(world, pos, state, placer, stack);
        TileUtil.actOnTile((IBlockAccess)world, pos, TileGreenhouseWindow.class, window -> {
            NBTTagCompound itemTag;
            if (!window.func_145831_w().field_72995_K) {
                window.setMode(window.isBlocked());
            }
            if ((itemTag = stack.func_77978_p()) != null) {
                window.setGlass(itemTag.func_74779_i("Glass"));
            }
        });
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        for (String glass : GreenhouseManager.helper.getWindowGlasses()) {
            list.add((Object)this.getItem(glass));
        }
    }

    protected BlockStateContainer func_180661_e() {
        return new ExtendedBlockState((Block)this, new IProperty[]{State.PROPERTY, FACING}, new IUnlistedProperty[]{UnlistedBlockPos.POS, UnlistedBlockAccess.BLOCKACCESS});
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        this.func_176226_b(worldIn, pos, state, 0);
        super.func_180663_b(worldIn, pos, state);
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        TileGreenhouseWindow window = TileUtil.getTile(world, pos, TileGreenhouseWindow.class);
        if (window != null) {
            ret.add(this.getItem(window.getGlass()));
        }
        return ret;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        List<ItemStack> drops = this.getDrops((IBlockAccess)world, pos, world.func_180495_p(pos), 0);
        if (drops.isEmpty()) {
            return super.getPickBlock(state, target, world, pos, player);
        }
        return drops.get(0);
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        return ((IExtendedBlockState)super.getExtendedState(state, world, pos)).withProperty((IUnlistedProperty)UnlistedBlockPos.POS, (Object)pos).withProperty((IUnlistedProperty)UnlistedBlockAccess.BLOCKACCESS, (Object)world);
    }

    @Override
    public void rotateAfterPlacement(EntityPlayer player, World world, BlockPos pos, EnumFacing side) {
        IBlockState state = world.func_180495_p(pos);
        world.func_175656_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)player.func_174811_aO().func_176734_d()));
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileGreenhouseWindow();
    }

    public boolean isRoofWindow() {
        return this.roofWindow;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModel(Item item, IModelManager manager) {
        if (this.roofWindow) {
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation("forestry:greenhouse_window_up", "inventory"));
        } else {
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation("forestry:greenhouse_window", "inventory"));
        }
    }
}

