/*
 * Decompiled with CFR 0.152.
 */
package forestry.greenhouse.climate;

import forestry.api.climate.ClimateType;
import forestry.api.climate.IClimateState;
import forestry.api.core.IErrorLogic;
import forestry.core.climate.ClimateStates;
import forestry.core.errors.EnumErrorCode;
import forestry.core.fluids.FilteredTank;
import forestry.core.recipes.HygroregulatorRecipe;
import forestry.greenhouse.climate.ClimateSourceCircuitable;
import forestry.greenhouse.climate.ClimateSourceMode;
import forestry.greenhouse.climate.ClimateSourceType;
import forestry.greenhouse.tiles.TileHygroregulator;
import net.minecraftforge.fluids.FluidStack;

public class ClimateSourceHygroregulator
extends ClimateSourceCircuitable<TileHygroregulator> {
    private HygroregulatorRecipe currentRecipe;

    public ClimateSourceHygroregulator(float boundModifier) {
        super(0.0f, boundModifier, ClimateSourceType.BOTH);
    }

    @Override
    protected void beforeWork() {
        this.currentRecipe = null;
        this.createRecipe();
        if (this.currentRecipe != null) {
            float tempChange = this.currentRecipe.tempChange;
            float humidChange = this.currentRecipe.humidChange;
            if (tempChange > 0.0f) {
                this.setTemperatureMode(ClimateSourceMode.POSITIVE);
            } else if (tempChange < 0.0f) {
                this.setTemperatureMode(ClimateSourceMode.NEGATIVE);
            } else {
                this.setTemperatureMode(ClimateSourceMode.NONE);
            }
            if (humidChange > 0.0f) {
                this.setHumidityMode(ClimateSourceMode.POSITIVE);
            } else if (humidChange < 0.0f) {
                this.setHumidityMode(ClimateSourceMode.NEGATIVE);
            } else {
                this.setHumidityMode(ClimateSourceMode.NONE);
            }
        } else {
            this.setTemperatureMode(ClimateSourceMode.NONE);
            this.setHumidityMode(ClimateSourceMode.NONE);
        }
    }

    @Override
    public boolean canWork(IClimateState currentState, ClimateSourceType oppositeType) {
        this.createRecipe();
        FilteredTank liquidTank = ((TileHygroregulator)this.owner).getLiquidTank();
        IErrorLogic errorLogic = ((TileHygroregulator)this.owner).getErrorLogic();
        if (this.currentRecipe != null && liquidTank.drainInternal(this.currentRecipe.liquid.amount, false) != null) {
            errorLogic.setCondition(false, EnumErrorCode.NO_RESOURCE_LIQUID);
            return true;
        }
        errorLogic.setCondition(true, EnumErrorCode.NO_RESOURCE_LIQUID);
        return false;
    }

    @Override
    protected void removeResources(IClimateState currentState, ClimateSourceType oppositeType) {
        FilteredTank liquidTank = ((TileHygroregulator)this.owner).getLiquidTank();
        liquidTank.drainInternal(this.currentRecipe.liquid.amount, true);
    }

    @Override
    protected IClimateState getChange(ClimateSourceType type, IClimateState target, IClimateState currentState) {
        float temperature = 0.0f;
        float humidity = 0.0f;
        if (type.canChangeHumidity()) {
            humidity += this.currentRecipe.humidChange * this.getChangeMultiplier(ClimateType.HUMIDITY);
        }
        if (type.canChangeTemperature()) {
            temperature += this.currentRecipe.tempChange * this.getChangeMultiplier(ClimateType.TEMPERATURE);
        }
        return ClimateStates.extendedOf(temperature, humidity);
    }

    private void createRecipe() {
        if (this.currentRecipe == null) {
            FilteredTank liquidTank = ((TileHygroregulator)this.owner).getLiquidTank();
            FluidStack fluid = liquidTank.getFluid();
            this.currentRecipe = fluid != null && fluid.amount > 0 ? ((TileHygroregulator)this.owner).getRecipe(fluid) : null;
        }
    }
}

