/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.module.audio.storage;

import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.IItemHandler;
import pl.asie.charset.ModCharset;
import pl.asie.charset.api.experimental.mechanical.IMechanicalPowerConsumer;
import pl.asie.charset.api.tape.IDataStorage;
import pl.asie.charset.lib.Properties;
import pl.asie.charset.lib.block.TileBase;
import pl.asie.charset.lib.block.Trait;
import pl.asie.charset.lib.block.TraitItemHolder;
import pl.asie.charset.lib.capability.Capabilities;
import pl.asie.charset.lib.network.Packet;
import pl.asie.charset.module.audio.storage.CharsetAudioStorage;
import pl.asie.charset.module.audio.storage.ItemQuartzDisc;
import pl.asie.charset.module.audio.storage.PacketUpdateProgressClient;
import pl.asie.charset.module.audio.storage.TraitRecordPlayer;

public class TileRecordPlayer
extends TileBase
implements ITickable,
IMechanicalPowerConsumer {
    protected float progressClient;
    private TraitItemHolder holder = new TraitItemHolder(){

        public void onContentsChanged() {
            super.onContentsChanged();
            if (TileRecordPlayer.this.field_145850_b != null && !((TileRecordPlayer)TileRecordPlayer.this).field_145850_b.field_72995_K) {
                TileRecordPlayer.this.setState(TraitRecordPlayer.State.STOPPED);
            }
            TileRecordPlayer.this.markBlockForUpdate();
        }

        public boolean isStackAllowed(ItemStack stack) {
            return stack.func_77973_b() instanceof ItemQuartzDisc;
        }

        public EnumFacing getTop() {
            return EnumFacing.UP;
        }
    };
    private TraitRecordPlayer player;
    private float spinLocation;

    public TileRecordPlayer() {
        this.registerTrait("inv", (Trait)this.holder);
        this.player = new TraitRecordPlayer(this.holder.getHandler()){

            @Override
            public boolean exposesCapability(EnumFacing facing) {
                return facing != EnumFacing.UP;
            }
        };
        this.registerTrait("player", this.player);
    }

    public void readNBTData(NBTTagCompound compound, boolean isClient) {
        super.readNBTData(compound, isClient);
        this.spinLocation = compound.func_74760_g("dr");
        if (isClient) {
            this.player.speedIn = compound.func_74760_g("sr");
            this.progressClient = compound.func_74760_g("pc");
        }
    }

    public NBTTagCompound writeNBTData(NBTTagCompound compound, boolean isClient) {
        compound = super.writeNBTData(compound, isClient);
        compound.func_74776_a("dr", this.spinLocation);
        if (isClient) {
            compound.func_74776_a("sr", (float)this.player.speedIn);
            compound.func_74776_a("pc", this.progressClient);
        }
        return compound;
    }

    public void invalidate(TileBase.InvalidationType type) {
        super.invalidate(type);
        this.setState(TraitRecordPlayer.State.STOPPED);
        this.player.stopAudioPlayback();
    }

    public EnumFacing getFacing() {
        return (EnumFacing)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)Properties.FACING4);
    }

    public void getDrops(NonNullList<ItemStack> stacks, IBlockState state, int fortune, boolean silkTouch) {
        super.getDrops(stacks, state, fortune, silkTouch);
        if (!this.holder.getStack().func_190926_b()) {
            stacks.add((Object)this.holder.getStack());
        }
    }

    public void func_73660_a() {
        if (this.isDiscSpinning()) {
            this.spinLocation = (this.spinLocation + this.getDiscRotationSpeed()) % 360.0f;
        }
        if (!this.field_145850_b.field_72995_K) {
            this.player.update(this.field_145850_b, this.field_174879_c);
            this.updateProgressClient();
        }
    }

    public boolean activate(EntityPlayer player, EnumFacing side, EnumHand hand, Vec3d hitPos) {
        if (player.func_70093_af() && side.func_176740_k() != EnumFacing.Axis.Y) {
            if (!this.field_145850_b.field_72995_K) {
                player.openGui((Object)ModCharset.instance, 259, this.func_145831_w(), this.func_174877_v().func_177958_n(), this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p());
            }
            return true;
        }
        Vec3d realPos = hitPos.func_178786_a(0.5, 0.5, 0.5).func_178785_b((float)((double)this.getFacing().func_185119_l() * Math.PI / 180.0));
        if (side == EnumFacing.UP) {
            if (realPos.field_72450_a > -0.075 && realPos.field_72449_c > -0.25 && !this.getStack().func_190926_b()) {
                if (realPos.field_72450_a > 0.4) {
                    if (!this.field_145850_b.field_72995_K) {
                        this.setState(TraitRecordPlayer.State.STOPPED);
                    }
                    return true;
                }
                if (player.func_70093_af()) {
                    if (this.getState() == TraitRecordPlayer.State.PAUSED) {
                        if (!this.field_145850_b.field_72995_K) {
                            this.setState(TraitRecordPlayer.State.PLAYING);
                            this.markBlockForUpdate();
                        }
                        return true;
                    }
                    if (this.getState() == TraitRecordPlayer.State.PLAYING) {
                        if (!this.field_145850_b.field_72995_K) {
                            this.setState(TraitRecordPlayer.State.PAUSED);
                            this.markBlockForUpdate();
                        }
                        return true;
                    }
                    if (this.getState() == TraitRecordPlayer.State.RECORDING) {
                        return true;
                    }
                } else {
                    if (!this.field_145850_b.field_72995_K) {
                        float fend;
                        if (this.getState() == TraitRecordPlayer.State.STOPPED) {
                            this.setState(TraitRecordPlayer.State.PLAYING);
                        }
                        float fmul = 0.0085f;
                        float fsub = 0.05f;
                        float fstart = CharsetAudioStorage.quartzDisc.getArmStartPosition(this.holder.getStack()) * fmul - fsub;
                        float newPos = 1.0f - (float)(realPos.field_72450_a - (double)fstart) / ((fend = 32.0f * fmul - fsub) - fstart);
                        if (newPos < 0.0f) {
                            newPos = 0.0f;
                        } else if (newPos > 1.0f) {
                            newPos = 1.0f;
                        }
                        IDataStorage storage = this.getStorage();
                        if (storage != null) {
                            storage.setPosition(Math.round((float)(storage.getSize() - 1) * newPos));
                            this.updateProgressClient();
                            this.player.stopAudioPlayback();
                        }
                        this.markBlockForUpdate();
                    }
                    return true;
                }
            }
            if ((this.getStack().func_190926_b() || player.func_184586_b(hand).func_190926_b() && player.func_70093_af()) && this.holder.activate((TileBase)this, player, side, hand)) {
                this.markBlockForUpdate();
                return true;
            }
        }
        return false;
    }

    private void updateProgressClient() {
        float pos = 0.0f;
        IDataStorage storage = this.getStorage();
        if (storage != null) {
            pos = (float)storage.getPosition() / (float)storage.getSize();
        }
        if (Math.abs(pos - this.progressClient) >= 0.0125f || pos == 0.0f != (this.progressClient == 0.0f)) {
            CharsetAudioStorage.packet.sendToWatching((Packet)new PacketUpdateProgressClient(this), (TileEntity)this);
            this.progressClient = pos;
        }
    }

    public float getArmRotationClient() {
        ItemStack stack = this.holder.getStack();
        if (stack.func_190926_b() || this.getState() == TraitRecordPlayer.State.STOPPED) {
            return 0.0f;
        }
        float fstart = CharsetAudioStorage.quartzDisc.getArmStartPosition(stack);
        float fend = 32.0f;
        return fstart + this.progressClient * (fend - fstart);
    }

    public float getDiscRotation() {
        return this.spinLocation;
    }

    public float getDiscRotationSpeed() {
        return (float)this.player.getSampleRate() / 4800.0f;
    }

    public boolean isDiscSpinning() {
        return this.player.getState() == TraitRecordPlayer.State.PLAYING || this.player.getState() == TraitRecordPlayer.State.RECORDING;
    }

    public ItemStack getStack() {
        return this.holder.getStack();
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    public IItemHandler getHandler() {
        return this.holder.getHandler();
    }

    public TraitRecordPlayer.State getState() {
        return this.player.getState();
    }

    public void setState(TraitRecordPlayer.State state) {
        this.player.setState(state);
        if (!this.func_145837_r() && state == TraitRecordPlayer.State.STOPPED) {
            this.spinLocation = 0.0f;
            IDataStorage storage = this.getStorage();
            if (storage != null) {
                storage.setPosition(0);
            }
        }
    }

    protected void writeData(byte[] data, boolean isLast, int totalLength) {
        IDataStorage storage;
        if (!this.func_145837_r() && (storage = this.getStorage()) != null) {
            if (this.getState() == TraitRecordPlayer.State.PLAYING || this.getState() == TraitRecordPlayer.State.RECORDING) {
                this.setState(TraitRecordPlayer.State.PAUSED);
            }
            storage.write(data);
            if (isLast) {
                storage.seek(-totalLength);
            }
        }
    }

    public IDataStorage getStorage() {
        return this.player.getStorage();
    }

    public boolean isAcceptingPower() {
        return true;
    }

    public void setForce(double speed, double torque) {
        double oldSpeed = this.player.speedIn;
        this.player.speedIn = speed;
        if (oldSpeed != speed) {
            this.markBlockForUpdate();
        }
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        if (ModCharset.isModuleLoaded((String)"power.mechanical") && capability == Capabilities.MECHANICAL_CONSUMER) {
            return facing != EnumFacing.UP;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (ModCharset.isModuleLoaded((String)"power.mechanical") && capability == Capabilities.MECHANICAL_CONSUMER) {
            if (facing != EnumFacing.UP) {
                return (T)Capabilities.MECHANICAL_CONSUMER.cast((Object)this);
            }
            return null;
        }
        return (T)super.getCapability(capability, facing);
    }

    public int getSampleRate() {
        return this.player.getSampleRate();
    }
}

