/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.lib.block;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Mirror;
import net.minecraft.util.NonNullList;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pl.asie.charset.ModCharset;
import pl.asie.charset.lib.CharsetLib;
import pl.asie.charset.lib.Properties;
import pl.asie.charset.lib.block.ITileWrenchRotatable;
import pl.asie.charset.lib.block.PacketCustomBlockDust;
import pl.asie.charset.lib.block.TileBase;
import pl.asie.charset.lib.item.ISubItemProvider;
import pl.asie.charset.lib.render.ParticleDiggingCharset;
import pl.asie.charset.lib.render.model.IStateParticleBakedModel;
import pl.asie.charset.lib.utils.UtilProxyCommon;
import pl.asie.charset.lib.utils.Utils;

public abstract class BlockBase
extends Block {
    private final boolean isTileProvider = this instanceof ITileEntityProvider;
    private final ISubItemProvider subItemProvider = this.createSubItemProvider();
    private boolean fullCube = true;
    private boolean opaqueCube = true;
    private boolean comparatorInputOverride = false;
    private boolean calledSetHardness = false;

    public Block func_149711_c(float val) {
        this.calledSetHardness = true;
        return super.func_149711_c(val);
    }

    public void verifyPreGameLaunch() {
        if (ModCharset.INDEV && !this.calledSetHardness) {
            ModCharset.logger.warn("[INDEV] Modder did not call setHardness on " + this.getRegistryName() + "!");
        }
    }

    public BlockBase(Material materialIn) {
        super(materialIn);
        this.func_149647_a(ModCharset.CREATIVE_TAB);
    }

    public BlockBase(Material materialIn, MapColor color) {
        super(materialIn, color);
        this.func_149647_a(ModCharset.CREATIVE_TAB);
    }

    public final ISubItemProvider getSubItemProvider() {
        return this.subItemProvider;
    }

    protected BlockBase setComparatorInputOverride(boolean value) {
        this.comparatorInputOverride = value;
        return this;
    }

    protected BlockBase setFullCube(boolean value) {
        this.fullCube = value;
        return this;
    }

    protected BlockBase setOpaqueCube(boolean value) {
        this.opaqueCube = value;
        this.field_149787_q = this.func_176223_P().func_185914_p();
        this.field_149786_r = this.field_149787_q ? 255 : 0;
        return this;
    }

    protected ISubItemProvider createSubItemProvider() {
        return null;
    }

    public boolean func_149740_M(IBlockState state) {
        return this.comparatorInputOverride;
    }

    public BlockFaceShape func_193383_a(IBlockAccess access, IBlockState state, BlockPos pos, EnumFacing facing) {
        return this.isNormalCube(state, access, pos) ? BlockFaceShape.SOLID : BlockFaceShape.UNDEFINED;
    }

    public boolean isSideSolid(IBlockState base_state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return this.func_193383_a(world, base_state, pos, side) == BlockFaceShape.SOLID;
    }

    public boolean func_149686_d(IBlockState state) {
        return this.fullCube;
    }

    public boolean func_149662_c(IBlockState state) {
        return this.opaqueCube;
    }

    public int getParticleTintIndex() {
        return -1;
    }

    public ItemStack func_185473_a(World world, BlockPos pos, IBlockState state) {
        TileEntity tile;
        if (this.isTileProvider && (tile = world.func_175625_s(pos)) instanceof TileBase) {
            return ((TileBase)tile).getPickedBlock(null, null, state);
        }
        return new ItemStack((Block)this);
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        TileEntity tile;
        if (this.isTileProvider && (tile = world.func_175625_s(pos)) instanceof TileBase) {
            return ((TileBase)tile).getPickedBlock(player, target, state);
        }
        return new ItemStack((Block)this);
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> itemList) {
        if (this.subItemProvider != null) {
            itemList.addAll(this.subItemProvider.getItems());
        } else {
            super.func_149666_a(tab, itemList);
        }
    }

    public int func_180641_l(IBlockState blockState, World worldIn, BlockPos pos) {
        TileEntity tile;
        if (this.isTileProvider && (tile = worldIn.func_175625_s(pos)) instanceof TileBase) {
            return ((TileBase)tile).getComparatorValue();
        }
        return 0;
    }

    public final void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.func_180633_a(world, pos, state, placer, stack);
        this.onBlockPlacedBy(world, pos, state, placer, stack, null, 0.5f, 0.5f, 0.5f);
    }

    public void onBlockPlacedBy(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack, @Nullable EnumFacing face, float hitX, float hitY, float hitZ) {
        TileEntity tile;
        if (this.isTileProvider && (tile = world.func_175625_s(pos)) instanceof TileBase) {
            ((TileBase)tile).onPlacedBy(placer, face, stack, hitX, hitY, hitZ);
        }
    }

    public void func_180657_a(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity te, ItemStack stack) {
        player.func_71029_a(StatList.func_188055_a((Block)this));
        player.func_71020_j(0.005f);
        int fortuneLevel = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)stack);
        boolean silkTouch = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185306_r, (ItemStack)stack) > 0;
        NonNullList items = NonNullList.func_191196_a();
        this.getDrops((NonNullList<ItemStack>)items, (IBlockAccess)worldIn, pos, state, te, 0, false);
        float chance = ForgeEventFactory.fireBlockHarvesting((List)items, (World)worldIn, (BlockPos)pos, (IBlockState)state, (int)fortuneLevel, (float)1.0f, (boolean)silkTouch, (EntityPlayer)player);
        this.harvesters.set(player);
        if (!worldIn.field_72995_K && !worldIn.restoringBlockSnapshots) {
            for (ItemStack item : items) {
                if (!(chance >= 1.0f) && !(worldIn.field_73012_v.nextFloat() <= chance)) continue;
                BlockBase.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)item);
            }
        }
        this.harvesters.set(null);
    }

    public boolean func_149659_a(Explosion explosionIn) {
        return false;
    }

    public void onBlockExploded(World world, BlockPos pos, Explosion explosion) {
        IBlockState stateOld = world.func_180495_p(pos);
        this.func_180652_a(world, pos, explosion);
        IBlockState state = world.func_180495_p(pos);
        TileEntity tile = world.func_175625_s(pos);
        if (stateOld == state) {
            world.func_175698_g(pos);
            NonNullList items = NonNullList.func_191196_a();
            this.getDrops((NonNullList<ItemStack>)items, (IBlockAccess)world, pos, state, tile, 0, false);
            float chance = ForgeEventFactory.fireBlockHarvesting((List)items, (World)world, (BlockPos)pos, (IBlockState)state, (int)0, (float)(1.0f / Utils.getExplosionSize(explosion)), (boolean)true, null);
            for (ItemStack item : items) {
                if (!(world.field_73012_v.nextFloat() <= chance)) continue;
                BlockBase.func_180635_a((World)world, (BlockPos)pos, (ItemStack)item);
            }
        }
    }

    public final void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        this.getDrops(drops, world, pos, state, world.func_175625_s(pos), fortune, false);
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, @Nullable TileEntity te, int fortune, boolean silkTouch) {
        if (te instanceof TileBase) {
            ((TileBase)te).getDrops(drops, state, fortune, silkTouch);
        } else {
            super.getDrops(drops, world, pos, state, fortune);
        }
    }

    public void func_180653_a(World worldIn, BlockPos pos, IBlockState state, float chance, int fortune) {
        if (!worldIn.field_72995_K && !worldIn.restoringBlockSnapshots) {
            NonNullList drops = NonNullList.func_191196_a();
            this.getDrops((NonNullList<ItemStack>)drops, (IBlockAccess)worldIn, pos, state, worldIn.func_175625_s(pos), fortune, false);
            chance = ForgeEventFactory.fireBlockHarvesting((List)drops, (World)worldIn, (BlockPos)pos, (IBlockState)state, (int)fortune, (float)chance, (boolean)false, (EntityPlayer)((EntityPlayer)this.harvesters.get()));
            for (ItemStack drop : drops) {
                if (!(worldIn.field_73012_v.nextFloat() <= chance)) continue;
                BlockBase.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)drop);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffects(World world, BlockPos pos, ParticleManager manager) {
        TextureAtlasSprite sprite;
        IBlockState state = world.func_180495_p(pos);
        IBakedModel model = Minecraft.func_71410_x().func_175602_ab().func_184389_a(state);
        if (model instanceof IStateParticleBakedModel && (sprite = ((IStateParticleBakedModel)model).getParticleTexture(state = this.getExtendedState(state.func_185899_b((IBlockAccess)world, pos), (IBlockAccess)world, pos), null)) != null) {
            for (int j = 0; j < 4; ++j) {
                for (int k = 0; k < 4; ++k) {
                    for (int l = 0; l < 4; ++l) {
                        double d0 = ((double)j + 0.5) / 4.0;
                        double d1 = ((double)k + 0.5) / 4.0;
                        double d2 = ((double)l + 0.5) / 4.0;
                        manager.func_78873_a((Particle)new ParticleDiggingCharset(world, (double)pos.func_177958_n() + d0, (double)pos.func_177956_o() + d1, (double)pos.func_177952_p() + d2, d0 - 0.5, d1 - 0.5, d2 - 0.5, state, pos, sprite, this.getParticleTintIndex()));
                    }
                }
            }
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(IBlockState state, World world, RayTraceResult target, ParticleManager manager) {
        IBakedModel model = Minecraft.func_71410_x().func_175602_ab().func_184389_a(state);
        if (model instanceof IStateParticleBakedModel) {
            BlockPos pos = target.func_178782_a();
            EnumFacing side = target.field_178784_b;
            TextureAtlasSprite sprite = ((IStateParticleBakedModel)model).getParticleTexture(state = this.getExtendedState(state.func_185899_b((IBlockAccess)world, pos), (IBlockAccess)world, pos), side);
            if (sprite != null) {
                int i = pos.func_177958_n();
                int j = pos.func_177956_o();
                int k = pos.func_177952_p();
                AxisAlignedBB axisalignedbb = state.func_185900_c((IBlockAccess)world, pos);
                double d0 = (double)i + RANDOM.nextDouble() * (axisalignedbb.field_72336_d - axisalignedbb.field_72340_a - (double)0.2f) + (double)0.1f + axisalignedbb.field_72340_a;
                double d1 = (double)j + RANDOM.nextDouble() * (axisalignedbb.field_72337_e - axisalignedbb.field_72338_b - (double)0.2f) + (double)0.1f + axisalignedbb.field_72338_b;
                double d2 = (double)k + RANDOM.nextDouble() * (axisalignedbb.field_72334_f - axisalignedbb.field_72339_c - (double)0.2f) + (double)0.1f + axisalignedbb.field_72339_c;
                if (side == EnumFacing.DOWN) {
                    d1 = (double)j + axisalignedbb.field_72338_b - (double)0.1f;
                }
                if (side == EnumFacing.UP) {
                    d1 = (double)j + axisalignedbb.field_72337_e + (double)0.1f;
                }
                if (side == EnumFacing.NORTH) {
                    d2 = (double)k + axisalignedbb.field_72339_c - (double)0.1f;
                }
                if (side == EnumFacing.SOUTH) {
                    d2 = (double)k + axisalignedbb.field_72334_f + (double)0.1f;
                }
                if (side == EnumFacing.WEST) {
                    d0 = (double)i + axisalignedbb.field_72340_a - (double)0.1f;
                }
                if (side == EnumFacing.EAST) {
                    d0 = (double)i + axisalignedbb.field_72336_d + (double)0.1f;
                }
                Particle particle = new ParticleDiggingCharset(world, d0, d1, d2, 0.0, 0.0, 0.0, state, pos, sprite, this.getParticleTintIndex()).func_70543_e(0.2f).func_70541_f(0.6f);
                manager.func_78873_a(particle);
                return true;
            }
        }
        return false;
    }

    public boolean addLandingEffects(IBlockState state, WorldServer world, BlockPos pos, IBlockState stateAgain, EntityLivingBase entity, int numberOfParticles) {
        PacketCustomBlockDust packet = new PacketCustomBlockDust((World)world, pos, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, numberOfParticles, 0.15f);
        CharsetLib.packet.sendToDimension(packet, world.field_73011_w.getDimension());
        return true;
    }

    public boolean addRunningEffects(IBlockState state, World world, BlockPos pos, Entity entity) {
        return UtilProxyCommon.proxy.addRunningParticles(state, world, pos, entity);
    }

    public boolean rotateBlock(World world, BlockPos pos, EnumFacing axis) {
        if (axis != null) {
            TileEntity tile = world.func_175625_s(pos);
            if (tile instanceof ITileWrenchRotatable) {
                return ((ITileWrenchRotatable)tile).rotateWrench(axis);
            }
            return super.rotateBlock(world, pos, axis);
        }
        return super.rotateBlock(world, pos, axis);
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        if (state.func_177227_a().contains(Properties.FACING)) {
            return state.func_177226_a((IProperty)Properties.FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)Properties.FACING)));
        }
        if (state.func_177227_a().contains(Properties.FACING4)) {
            return state.func_177226_a((IProperty)Properties.FACING4, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)Properties.FACING4)));
        }
        if (state.func_177227_a().contains(Properties.AXIS) && (rot == Rotation.CLOCKWISE_90 || rot == Rotation.COUNTERCLOCKWISE_90)) {
            EnumFacing.Axis axis = (EnumFacing.Axis)state.func_177229_b(Properties.AXIS);
            if (axis == EnumFacing.Axis.X) {
                return state.func_177226_a(Properties.AXIS, (Comparable)EnumFacing.Axis.Z);
            }
            if (axis == EnumFacing.Axis.Z) {
                return state.func_177226_a(Properties.AXIS, (Comparable)EnumFacing.Axis.X);
            }
            return state;
        }
        return state;
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirror) {
        if (state.func_177227_a().contains(Properties.FACING)) {
            return state.func_177226_a((IProperty)Properties.FACING, (Comparable)mirror.func_185803_b((EnumFacing)state.func_177229_b((IProperty)Properties.FACING)));
        }
        if (state.func_177227_a().contains(Properties.FACING4)) {
            return state.func_177226_a((IProperty)Properties.FACING4, (Comparable)mirror.func_185803_b((EnumFacing)state.func_177229_b((IProperty)Properties.FACING4)));
        }
        return state;
    }
}

