/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.lib.command;

import java.util.ArrayList;
import java.util.Map;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.oredict.OreDictionary;
import pl.asie.charset.lib.command.CommandCharset;
import pl.asie.charset.lib.command.SubCommand;
import pl.asie.charset.lib.material.ItemMaterial;
import pl.asie.charset.lib.material.ItemMaterialRegistry;

public class SubCommandHand
extends SubCommand {
    public SubCommandHand() {
        super("hand", Side.SERVER);
    }

    @Override
    public String getUsage() {
        return "Report information about the item in hand.\nParameters: stack (default), material, ore";
    }

    @Override
    public void execute(MinecraftServer server, ICommandSender sender, String[] args) {
        Entity e = sender.func_174793_f();
        if (e instanceof EntityPlayer) {
            ItemStack stack = ((EntityPlayer)e).func_184614_ca();
            if (stack.func_190926_b()) {
                sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "Empty hand!"));
                return;
            }
            if (args.length > 0 && "ore".equalsIgnoreCase(args[0])) {
                ArrayList<String> names = new ArrayList<String>();
                for (int id : OreDictionary.getOreIDs((ItemStack)stack)) {
                    String name = OreDictionary.getOreName((int)id);
                    names.add(name);
                }
                sender.func_145747_a((ITextComponent)new TextComponentString("Ores: [" + CommandCharset.COMMAS.join(names) + "]"));
            } else if (args.length > 0 && "material".equalsIgnoreCase(args[0])) {
                ItemMaterial material = ItemMaterialRegistry.INSTANCE.getMaterialIfPresent(stack);
                if (material == null) {
                    sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "Not a material!"));
                } else {
                    sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GREEN + material.getId()));
                    sender.func_145747_a((ITextComponent)new TextComponentString("[" + CommandCharset.COMMAS.join(material.getTypes()) + "]"));
                    for (Map.Entry<String, ItemMaterial> entry : material.getRelations().entrySet()) {
                        sender.func_145747_a((ITextComponent)new TextComponentString("-> " + entry.getKey() + ": " + entry.getValue().getId()));
                    }
                }
            } else {
                sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.YELLOW + stack.toString() + " " + TextFormatting.GRAY + "(" + stack.func_77973_b().getRegistryName() + ")"));
                if (stack.func_77942_o()) {
                    sender.func_145747_a((ITextComponent)new TextComponentString(stack.func_77978_p().toString()));
                }
            }
        }
    }
}

