/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.lib.loader;

import com.google.common.base.Joiner;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import net.minecraftforge.fml.common.discovery.asm.ModAnnotation;
import net.minecraftforge.fml.common.event.FMLEvent;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.commons.lang3.tuple.Pair;
import pl.asie.charset.ModCharset;
import pl.asie.charset.lib.config.CharsetLoadConfigEvent;
import pl.asie.charset.lib.loader.CharsetCompatAnnotation;
import pl.asie.charset.lib.loader.CharsetModule;
import pl.asie.charset.lib.loader.ModuleProfile;
import pl.asie.charset.lib.network.PacketRegistry;
import pl.asie.charset.lib.utils.ThreeState;

public class ModuleLoader {
    public static final Set<String> CATEGORIES_OFF_BY_DEFAULT = Sets.newHashSet((Object[])new String[]{"overhaul", "pony"});
    public static final ModuleLoader INSTANCE = new ModuleLoader();
    public static final Multimap<Class, String> classNames = HashMultimap.create();
    public static final BiMap<String, Configuration> moduleConfigs = HashBiMap.create();
    public static final Map<String, String> moduleGuiClasses = new HashMap<String, String>();
    private static final Multimap<String, String> dependencies = HashMultimap.create();
    private static final Map<Class, List<Pair<String, MethodHandle>>> loaderHandles = new IdentityHashMap<Class, List<Pair<String, MethodHandle>>>();
    private static final BiMap<String, Object> loadedModules = HashBiMap.create();
    private static final Map<String, Object> loadedModulesByClass = new HashMap<String, Object>();
    private static final Map<String, EnableInformation> enableInfoMap = new HashMap<String, EnableInformation>();
    private static final Joiner joinerComma = Joiner.on((String)", ");
    private final ClassLoader classLoader = this.getClass().getClassLoader();

    private ModuleLoader() {
    }

    public Set<String> getLoadedModules() {
        return loadedModules.keySet();
    }

    private Class getClass(ASMDataTable.ASMData data) {
        try {
            return this.getClass().getClassLoader().loadClass(data.getClassName());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private Field getField(ASMDataTable.ASMData data) {
        try {
            Field f = this.getClass(data).getDeclaredField(data.getObjectName());
            f.setAccessible(true);
            return f;
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    private MethodHandle getStaticMethod(ASMDataTable.ASMData data) {
        String methodName = data.getObjectName().substring(0, data.getObjectName().indexOf(40));
        String methodDesc = data.getObjectName().substring(methodName.length());
        try {
            return MethodHandles.lookup().findStatic(this.getClass(data), methodName, MethodType.fromMethodDescriptorString(methodDesc, this.classLoader));
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    private void iterateModules(ASMDataTable table, String annotation, BiConsumer<ASMDataTable.ASMData, Object> c) {
        for (ASMDataTable.ASMData data : table.getAll(annotation)) {
            if (!loadedModulesByClass.containsKey(data.getClassName())) continue;
            c.accept(data, loadedModulesByClass.get(data.getClassName()));
        }
    }

    private void addClassNames(ASMDataTable table, Class annotationClass, String confType) {
        for (ASMDataTable.ASMData data : table.getAll(annotationClass.getName())) {
            String id = (String)data.getAnnotationInfo().get("value");
            Property prop = ModCharset.configModules.get("compat", confType + ":" + id, true);
            boolean enabled = prop.getBoolean();
            if (!enabled || !loadedModules.containsKey((Object)id)) continue;
            classNames.put((Object)annotationClass, (Object)data.getClassName());
        }
    }

    private boolean isDepPresent(String dep, Collection<String> enabledModules) {
        if (dep.startsWith("mod:")) {
            return Loader.isModLoaded((String)dep.substring("mod:".length()));
        }
        return enabledModules.contains(dep);
    }

    private ModuleProfile getProfileFromString(String s) {
        if ("STABLE".equals(s = s.toUpperCase())) {
            return ModuleProfile.STABLE;
        }
        if ("TESTING".equals(s)) {
            return ModuleProfile.TESTING;
        }
        if ("EXPERIMENTAL".equals(s) || "UNSTABLE".equals(s)) {
            return ModuleProfile.EXPERIMENTAL;
        }
        throw new RuntimeException("Invalid Charset modules.cfg general.profile setting '" + s + "'!");
    }

    private void readDataTable(ASMDataTable table) {
        HashMultimap unmetDependencies = HashMultimap.create();
        HashSet<String> enabledModules = new HashSet<String>();
        HashSet<Object> compatModules = new HashSet<Object>();
        HashMap<Object, Object> moduleData = new HashMap<Object, Object>();
        Property baseProfileProp = ModCharset.configGeneral.get("general", "profile", "DEFAULT");
        baseProfileProp.setValidValues(new String[]{"DEFAULT", "STABLE", "TESTING", "EXPERIMENTAL"});
        baseProfileProp.setLanguageKey("config.charset.profile.name");
        baseProfileProp.setRequiresMcRestart(true);
        ModuleProfile defaultProfile = ModCharset.INDEV ? ModuleProfile.INDEV : (ModCharset.defaultOptions.containsKey("profile") ? this.getProfileFromString(ModCharset.defaultOptions.get("profile")) : ModuleProfile.STABLE);
        baseProfileProp.setComment("Set the base profile for Charset.\nThis will give you a default set of modules based on stability.\nAllowed values: DEFAULT, STABLE, TESTING, EXPERIMENTAL (DEFAULT means " + defaultProfile.name() + ")\nFor fine-grained configuration, check modules.cfg!");
        ModuleProfile profile = "DEFAULT".equals(baseProfileProp.getString().toUpperCase()) ? defaultProfile : this.getProfileFromString(baseProfileProp.getString());
        ModCharset.profile = profile;
        ModCharset.logger.info("Charset profile is " + (Object)((Object)ModCharset.profile));
        ConfigCategory category = ModCharset.configModules.getCategory("overrides");
        category.setComment("Overrides can have one of three values: DEFAULT, ENABLE, DISABLE\nDEFAULT will enable the module based on your profile settings and dependency availability.");
        category = ModCharset.configModules.getCategory("categories");
        category.setComment("This section allows you to disable certain categories of content, based on a tag system.");
        boolean configDirty = false;
        HashMap<String, Boolean> categoryMap = new HashMap<String, Boolean>();
        for (ASMDataTable.ASMData data2 : table.getAll(CharsetModule.class.getName())) {
            Map map = data2.getAnnotationInfo();
            List tags = map.getOrDefault("categories", Collections.emptyList());
            for (String string : tags) {
                if (categoryMap.containsKey(string)) continue;
                Property prop = ModCharset.configModules.get("categories", string, !CATEGORIES_OFF_BY_DEFAULT.contains(string));
                prop.setRequiresMcRestart(true);
                categoryMap.put(string, prop.getBoolean());
            }
        }
        for (Object data2 : table.getAll(CharsetModule.class.getName())) {
            List deps;
            EnableInformation enableInfo;
            Map map = data2.getAnnotationInfo();
            String name = (String)map.get("name");
            String desc = (String)map.get("description");
            if (desc == null) {
                desc = "";
            }
            ModuleProfile moduleProfile = ModuleProfile.valueOf(((ModAnnotation.EnumHolder)map.get("profile")).getValue());
            Boolean isDefault = map.getOrDefault("isDefault", true);
            Boolean compat = moduleProfile == ModuleProfile.COMPAT;
            Boolean clientOnly = map.getOrDefault("isClientOnly", false);
            Boolean serverOnly = map.getOrDefault("isServerOnly", false);
            List tags = map.getOrDefault("categories", Collections.emptyList());
            String moduleGuiClass = map.getOrDefault("moduleConfigGui", "");
            if (moduleGuiClass.length() > 0) {
                moduleGuiClasses.put(name, moduleGuiClass);
            }
            moduleData.put(name, data2);
            ThreeState override = ThreeState.MAYBE;
            if (map.getOrDefault("isVisible", true).booleanValue()) {
                Property prop;
                if (moduleProfile == ModuleProfile.INDEV && profile != ModuleProfile.INDEV) {
                    override = ThreeState.NO;
                } else if (compat.booleanValue()) {
                    prop = ModCharset.configModules.get("compat", name, isDefault.booleanValue());
                    prop.setRequiresMcRestart(true);
                    if (!prop.getBoolean()) {
                        override = ThreeState.NO;
                    }
                } else {
                    prop = ModCharset.configModules.get("overrides", name, "DEFAULT");
                    prop.setValidValues(new String[]{"DEFAULT", "ENABLE", "DISABLE"});
                    prop.setRequiresMcRestart(true);
                    if (desc.length() > 0) {
                        desc = desc + " ";
                    }
                    desc = desc + "[Profile: " + moduleProfile.name().toUpperCase() + "";
                    if (!isDefault.booleanValue()) {
                        desc = desc + ", off by default!";
                    }
                    if (!(desc = desc + "]").equals(prop.getComment())) {
                        prop.setComment(desc);
                        configDirty = true;
                    }
                    if (prop.getString().toUpperCase().startsWith("ENABLE")) {
                        override = ThreeState.YES;
                    } else if (prop.getString().toUpperCase().startsWith("DISABLE")) {
                        override = ThreeState.NO;
                    } else if (!"DEFAULT".equals(prop.getString().toUpperCase())) {
                        ModCharset.logger.warn("Invalid value for '" + (String)name + "' override: '" + prop.getString() + ";");
                    }
                }
            }
            if (clientOnly.booleanValue() && !FMLCommonHandler.instance().getSide().isClient() || serverOnly.booleanValue() && !FMLCommonHandler.instance().getSide().isServer()) continue;
            if (compat.booleanValue()) {
                compatModules.add(name);
            }
            if (override == ThreeState.MAYBE && isDefault.booleanValue()) {
                List antideps = (List)map.get("antidependencies");
                if (antideps != null) {
                    for (String dep : antideps) {
                        if (!this.isDepPresent(dep, enabledModules)) continue;
                        ModCharset.logger.info("Antidependency " + dep + " is present - disabling otherwise not forced module " + (String)name + ".");
                        isDefault = false;
                        break;
                    }
                }
                for (String s : tags) {
                    if (((Boolean)categoryMap.get(s)).booleanValue()) continue;
                    ModCharset.logger.info("Category " + s + " is disabled - disabling otherwise not forced module " + (String)name + ".");
                    isDefault = false;
                }
            }
            if (!compat.booleanValue() && moduleProfile != ModuleProfile.FORCED && moduleProfile.ordinal() > profile.ordinal()) {
                isDefault = false;
            }
            if (!(enableInfo = new EnableInformation(isDefault, override)).isEnabled()) continue;
            enabledModules.add(name);
            enableInfoMap.put(name, enableInfo);
            if (!"lib".equals(name)) {
                dependencies.put((Object)name, (Object)"lib");
            }
            if ((deps = (List)map.get("dependencies")) == null) continue;
            dependencies.putAll((Object)name, (Iterable)deps);
        }
        if (ModCharset.configGeneral.hasChanged()) {
            ModCharset.configGeneral.save();
        }
        if (ModCharset.configModules.hasChanged() || configDirty) {
            ModCharset.configModules.save();
            configDirty = false;
        }
        int removedCount = 1;
        while (removedCount > 0) {
            removedCount = 0;
            block12: for (String string : enabledModules) {
                if (!dependencies.containsKey((Object)string)) continue;
                for (String dep : dependencies.get((Object)string)) {
                    boolean met;
                    boolean bl = false;
                    if (dep.startsWith("optional:")) {
                        bl = true;
                        dep = dep.substring("optional:".length());
                    }
                    if (met = bl || this.isDepPresent(dep, enabledModules)) continue;
                    ModuleLoader.enableInfoMap.get((Object)string).dependenciesMet = false;
                    unmetDependencies.put((Object)string, (Object)dep);
                    continue block12;
                }
            }
            Iterator unmetDepKey = unmetDependencies.keySet().iterator();
            while (unmetDepKey.hasNext()) {
                String string = (String)unmetDepKey.next();
                EnableInformation enableInfo = enableInfoMap.get(string);
                if (enableInfo.isEnabled()) continue;
                if (!compatModules.contains(string)) {
                    ModCharset.logger.info("Module " + string + " requires " + joinerComma.join((Iterable)unmetDependencies.get((Object)string)) + ", but is not force-enabled. You can ignore this - it is not an error, just information.");
                }
                ++removedCount;
                enabledModules.remove(string);
                unmetDepKey.remove();
            }
        }
        for (String string : enabledModules) {
            if (ModCharset.INDEV) {
                ModCharset.logger.info("Instantiating module " + string);
            }
            ASMDataTable.ASMData data3 = (ASMDataTable.ASMData)moduleData.get(string);
            try {
                Object o = this.getClass(data3).newInstance();
                loadedModules.put((Object)string, o);
                loadedModulesByClass.put(data3.getClassName(), o);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (unmetDependencies.size() > 0) {
            ArrayList<String> depStrings = new ArrayList<String>(unmetDependencies.size());
            for (String depMod : unmetDependencies.keys()) {
                depStrings.add(depMod + "<-[" + joinerComma.join((Iterable)unmetDependencies.get((Object)depMod)) + "]");
            }
            throw new RuntimeException("The following mandatory dependencies were not met: " + joinerComma.join(depStrings));
        }
        this.iterateModules(table, Mod.EventHandler.class.getName(), (data, instance) -> {
            String methodName = data.getObjectName().substring(0, data.getObjectName().indexOf(40));
            String methodDesc = data.getObjectName().substring(methodName.length());
            MethodType methodType = MethodType.fromMethodDescriptorString(methodDesc, this.classLoader);
            if (ModCharset.INDEV && methodType.parameterCount() != 1) {
                throw new RuntimeException("Invalid parameter count " + methodType.parameterCount() + " for EventHandler in " + instance.getClass() + "!");
            }
            try {
                MethodHandle methodHandle = MethodHandles.lookup().findVirtual(this.getClass((ASMDataTable.ASMData)data), methodName, methodType);
                List list = loaderHandles.computeIfAbsent((Class)methodType.parameterType(0), k -> new ArrayList());
                list.sort(Comparator.comparing(Pair::getLeft));
                list.add(Pair.of((Object)loadedModules.inverse().get(instance), (Object)methodHandle));
            }
            catch (NoSuchMethodException methodHandle) {
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
        this.iterateModules(table, CharsetModule.Instance.class.getName(), (data, instance) -> {
            try {
                String instString = (String)data.getAnnotationInfo().get("value");
                if (instString == null || instString.equals("")) {
                    this.getField((ASMDataTable.ASMData)data).set(instance, instance);
                } else {
                    Object inst2 = loadedModules.get((Object)instString);
                    this.getField((ASMDataTable.ASMData)data).set(instance, inst2);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
        this.iterateModules(table, CharsetModule.PacketRegistry.class.getName(), (data, instance) -> {
            String id = (String)data.getAnnotationInfo().get("value");
            if (id == null) {
                id = (String)loadedModules.inverse().get(instance);
            }
            try {
                String channelName = "chrs:" + id.substring(id.lastIndexOf(46) + 1);
                this.getField((ASMDataTable.ASMData)data).set(instance, new PacketRegistry(channelName));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
        this.iterateModules(table, CharsetModule.Configuration.class.getName(), (data, instance) -> {
            String id = (String)data.getAnnotationInfo().get("value");
            if (id == null) {
                id = (String)loadedModules.inverse().get(instance);
            }
            try {
                Configuration config = new Configuration(ModCharset.getModuleConfigFile(id));
                this.getField((ASMDataTable.ASMData)data).set(instance, config);
                moduleConfigs.put((Object)id, (Object)config);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
        Side side = FMLCommonHandler.instance().getSide();
        for (ASMDataTable.ASMData data3 : table.getAll(CharsetModule.SidedProxy.class.getName())) {
            String clientSide = (String)data3.getAnnotationInfo().get("clientSide");
            String string = (String)data3.getAnnotationInfo().get("serverSide");
            try {
                Field f = this.getField(data3);
                f.set(null, Class.forName(side == Side.CLIENT ? clientSide : string).newInstance());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        HashSet remainingModules = Sets.newHashSet(enabledModules);
        while (!remainingModules.isEmpty()) {
            Iterator remainingIterator = remainingModules.iterator();
            boolean bl = false;
            while (remainingIterator.hasNext()) {
                String s = (String)remainingIterator.next();
                boolean canAdd = true;
                for (String dep : dependencies.get((Object)s)) {
                    if (dep.startsWith("mod:") || dep.startsWith("optional:") || arrayList.contains(dep)) continue;
                    canAdd = false;
                    break;
                }
                if (!canAdd) continue;
                bl = true;
                arrayList.add(s);
                remainingIterator.remove();
            }
            if (bl) continue;
            throw new RuntimeException("Cyclic dependency within Charset modules! Report!");
        }
        for (List list : loaderHandles.values()) {
            list.sort(Comparator.comparingInt(a -> sortedModules.indexOf(a.getKey())));
        }
        for (String string : arrayList) {
            MinecraftForge.EVENT_BUS.register(loadedModules.get((Object)string));
        }
        for (ASMDataTable.ASMData aSMData : table.getAll(CharsetCompatAnnotation.class.getName())) {
            String id = (String)aSMData.getAnnotationInfo().get("value");
            try {
                this.addClassNames(table, Class.forName(aSMData.getClassName()), id);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.passEvent(new CharsetLoadConfigEvent(true));
        for (Configuration configuration : moduleConfigs.values()) {
            if (!configuration.hasChanged()) continue;
            configuration.save();
        }
        if (ModCharset.configModules.hasChanged() || configDirty) {
            ModCharset.configModules.save();
            configDirty = false;
        }
    }

    public void passEvent(FMLEvent o) {
        Class<?> c = o.getClass();
        List<Pair<String, MethodHandle>> list = loaderHandles.get(c);
        if (list != null) {
            for (Pair<String, MethodHandle> pair : list) {
                try {
                    ((MethodHandle)pair.getValue()).invoke(loadedModules.get(pair.getKey()), o);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    throw new RuntimeException(t);
                }
            }
        }
    }

    public void preInit(ASMDataTable table) {
        this.readDataTable(table);
    }

    public void init() {
        for (Configuration c : moduleConfigs.values()) {
            if (!c.hasChanged()) continue;
            c.save();
        }
    }

    public void postInit() {
    }

    private static class EnableInformation {
        public boolean isDefault;
        public ThreeState override;
        public boolean dependenciesMet;

        public EnableInformation(boolean isDefault, ThreeState override) {
            this.isDefault = isDefault;
            this.override = override;
            this.dependenciesMet = true;
        }

        public boolean isEnabled() {
            if (this.override == ThreeState.YES) {
                return true;
            }
            if (this.override == ThreeState.NO) {
                return false;
            }
            return this.isDefault && this.dependenciesMet;
        }

        public boolean canBeEnabled() {
            return this.dependenciesMet;
        }
    }
}

