/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.lib.material;

import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.set.hash.TIntHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.common.crafting.IShapedRecipe;
import net.minecraftforge.common.crafting.IngredientNBT;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import pl.asie.charset.lib.recipe.RecipeCharset;
import pl.asie.charset.lib.utils.RecipeUtils;

public class FastRecipeLookup {
    public static boolean ENABLED = true;
    private static final boolean DEBUG = false;
    private static final Set<Class> saneClasses = new HashSet<Class>();
    private static List<Collection<IRecipe>> recipeLists;
    private static TIntObjectMap<Collection<IRecipe>> shapelessOneElement;

    private static void addSaneClass(String s) {
        try {
            saneClasses.add(Class.forName(s));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static ItemStack getCraftingResult(InventoryCrafting crafting, World world) {
        IRecipe recipe = FastRecipeLookup.findMatchingRecipe(crafting, world);
        if (recipe != null) {
            return recipe.func_77572_b(crafting);
        }
        return ItemStack.field_190927_a;
    }

    protected static ItemStack getCraftingResultQuickly(boolean noShapeless, int nonEmptyStacks, World world, int width, int height, ItemStack ... stacks) {
        InventoryCrafting crafting = RecipeUtils.getCraftingInventory(width, height, stacks);
        IRecipe recipe = FastRecipeLookup.findMatchingRecipeQuickly(noShapeless, nonEmptyStacks, crafting, world);
        if (recipe != null) {
            return recipe.func_77572_b(crafting);
        }
        return ItemStack.field_190927_a;
    }

    public static void clearRecipeLists() {
        recipeLists.clear();
        shapelessOneElement.clear();
    }

    private static void addShapelessOneElement(IRecipe recipe, int i) {
        LinkedHashSet<IRecipe> list = (LinkedHashSet<IRecipe>)shapelessOneElement.get(i);
        if (list == null) {
            list = new LinkedHashSet<IRecipe>();
            shapelessOneElement.put(i, list);
        }
        list.add(recipe);
    }

    private static void addShapelessOneElement(IRecipe recipe) {
        Ingredient ing = (Ingredient)recipe.func_192400_c().get(0);
        if (ing == Ingredient.field_193370_a) {
            FastRecipeLookup.addShapelessOneElement(recipe, 0);
        } else {
            Class<?> c = ing.getClass();
            if (c == Ingredient.class || c == IngredientNBT.class) {
                TIntHashSet set = new TIntHashSet();
                for (ItemStack stack : ing.func_193365_a()) {
                    int i = FastRecipeLookup.toIntIdentifier(stack);
                    if (!set.add(i)) continue;
                    FastRecipeLookup.addShapelessOneElement(recipe, i);
                }
            } else {
                recipeLists.get(0).add(recipe);
            }
        }
    }

    private static int toIntIdentifier(ItemStack stack) {
        if (stack.func_190926_b()) {
            return 0;
        }
        return Item.func_150891_b((Item)stack.func_77973_b());
    }

    public static void initRecipeLists() {
        if (!ENABLED) {
            return;
        }
        if (recipeLists.isEmpty()) {
            for (int i = 0; i < 28; ++i) {
                recipeLists.add(new ArrayList());
            }
            for (IRecipe irecipe : ForgeRegistries.RECIPES) {
                Class<?> c = irecipe.getClass();
                if (saneClasses.contains(c)) {
                    if (irecipe instanceof IShapedRecipe) {
                        int width = ((IShapedRecipe)irecipe).getRecipeWidth();
                        int height = ((IShapedRecipe)irecipe).getRecipeHeight();
                        Iterator ingredients = irecipe.func_192400_c();
                        boolean isReallyWeird = false;
                        boolean isSlightlyWeird = false;
                        if (ingredients.size() != width * height) {
                            isReallyWeird = true;
                        } else {
                            int i;
                            boolean canTrimTop = true;
                            boolean canTrimBottom = true;
                            boolean canTrimLeft = true;
                            boolean canTrimRight = true;
                            for (i = 0; i < width; ++i) {
                                if (ingredients.get(i) != Ingredient.field_193370_a) {
                                    canTrimTop = false;
                                }
                                if (ingredients.get(i + (height - 1) * width) == Ingredient.field_193370_a) continue;
                                canTrimBottom = false;
                            }
                            for (i = 0; i < height; ++i) {
                                if (ingredients.get(i * width) != Ingredient.field_193370_a) {
                                    canTrimLeft = false;
                                }
                                if (ingredients.get(i * width + (width - 1)) == Ingredient.field_193370_a) continue;
                                canTrimRight = false;
                            }
                            if (canTrimTop || canTrimLeft || canTrimRight || canTrimBottom) {
                                isSlightlyWeird = true;
                            }
                        }
                        if (isReallyWeird) {
                            recipeLists.get(27).add(irecipe);
                            continue;
                        }
                        if (isSlightlyWeird) {
                            recipeLists.get(18 + (width - 1) * 3 + (height - 1)).add(irecipe);
                            continue;
                        }
                        if (width * height == 1) {
                            FastRecipeLookup.addShapelessOneElement(irecipe);
                            continue;
                        }
                        int wh = (width - 1) * 3 + (height - 1);
                        recipeLists.get(9 + wh).add(irecipe);
                        continue;
                    }
                    NonNullList ings = irecipe.func_192400_c();
                    boolean isReallyWeird = false;
                    for (Ingredient i : ings) {
                        if (i != Ingredient.field_193370_a) continue;
                        isReallyWeird = true;
                        break;
                    }
                    if (isReallyWeird) {
                        recipeLists.get(27).add(irecipe);
                        continue;
                    }
                    if (ings.size() == 1) {
                        FastRecipeLookup.addShapelessOneElement(irecipe);
                        continue;
                    }
                    recipeLists.get(ings.size() - 1).add(irecipe);
                    continue;
                }
                if (!irecipe.func_194133_a(4, 4)) {
                    recipeLists.get(27).add(irecipe);
                    continue;
                }
                int smallestFittable = 10;
                for (int iw = 0; iw <= 3; ++iw) {
                    for (int ih = 0; ih <= 3; ++ih) {
                        int i;
                        if (!irecipe.func_194133_a(iw, ih) || smallestFittable <= (i = iw * ih)) continue;
                        smallestFittable = i;
                    }
                }
                if (smallestFittable <= 0 || smallestFittable > 9) {
                    recipeLists.get(27).add(irecipe);
                    continue;
                }
                recipeLists.get(18 + (smallestFittable - 1)).add(irecipe);
            }
        }
    }

    public static IRecipe findMatchingRecipe(InventoryCrafting craftMatrix, World worldIn) {
        int i;
        if (!ENABLED) {
            return CraftingManager.func_192413_b((InventoryCrafting)craftMatrix, (World)worldIn);
        }
        int x = 0;
        int y = 0;
        int width = craftMatrix.func_174922_i();
        int height = craftMatrix.func_174923_h();
        boolean empty = true;
        while (empty) {
            for (i = 0; i < height; ++i) {
                if (craftMatrix.func_70463_b(width - 1, i).func_190926_b()) continue;
                empty = false;
                break;
            }
            if (!empty || --width != 0) continue;
            return null;
        }
        empty = true;
        while (empty) {
            for (i = 0; i < width; ++i) {
                if (craftMatrix.func_70463_b(i, height - 1).func_190926_b()) continue;
                empty = false;
                break;
            }
            if (!empty || --height != 0) continue;
            return null;
        }
        empty = true;
        while (empty) {
            for (i = 0; i < height; ++i) {
                if (craftMatrix.func_70463_b(x, i).func_190926_b()) continue;
                empty = false;
                break;
            }
            if (!empty) continue;
            ++x;
            --width;
        }
        empty = true;
        while (empty) {
            for (i = 0; i < width; ++i) {
                if (craftMatrix.func_70463_b(x + i, y).func_190926_b()) continue;
                empty = false;
                break;
            }
            if (!empty) continue;
            ++y;
            --height;
        }
        if (width == craftMatrix.func_174922_i() && height == craftMatrix.func_174923_h()) {
            int nonEmptyStacks = 0;
            for (int iy = 0; iy < height; ++iy) {
                for (int ix = 0; ix < width; ++ix) {
                    ItemStack stack = craftMatrix.func_70463_b(x + ix, y + iy);
                    if (stack.func_190926_b()) continue;
                    ++nonEmptyStacks;
                }
            }
            return FastRecipeLookup.findMatchingRecipeQuickly(false, nonEmptyStacks, craftMatrix, craftMatrix, worldIn);
        }
        InventoryCrafting craftingTrimmed = RecipeUtils.getCraftingInventory(width, height, RecipeUtils.getContainer(craftMatrix));
        int nonEmptyStacks = 0;
        for (int iy = 0; iy < height; ++iy) {
            for (int ix = 0; ix < width; ++ix) {
                ItemStack stack = craftMatrix.func_70463_b(x + ix, y + iy);
                if (!stack.func_190926_b()) {
                    ++nonEmptyStacks;
                }
                craftingTrimmed.func_70299_a(iy * width + ix, stack);
            }
        }
        return FastRecipeLookup.findMatchingRecipeQuickly(false, nonEmptyStacks, craftingTrimmed, craftMatrix, worldIn);
    }

    protected static IRecipe findMatchingRecipeQuickly(boolean noShapeless, int nonEmptyStacks, InventoryCrafting craftMatrix, World worldIn) {
        return FastRecipeLookup.findMatchingRecipeQuickly(noShapeless, nonEmptyStacks, craftMatrix, null, worldIn);
    }

    protected static IRecipe findMatchingRecipeQuickly(boolean noShapeless, int nonEmptyStacks, InventoryCrafting craftMatrix, @Nullable InventoryCrafting craftMatrixUntrimmed, World worldIn) {
        int base;
        if (!ENABLED) {
            return CraftingManager.func_192413_b((InventoryCrafting)craftMatrix, (World)worldIn);
        }
        FastRecipeLookup.initRecipeLists();
        int width = craftMatrix.func_174922_i();
        int height = craftMatrix.func_174923_h();
        if (width * height >= 2) {
            for (IRecipe irecipe : recipeLists.get(9 + (width - 1) * 3 + (height - 1))) {
                if (!irecipe.func_77569_a(craftMatrix, worldIn)) continue;
                return irecipe;
            }
        }
        if (nonEmptyStacks == 1) {
            Object stack = ItemStack.field_190927_a;
            for (int i = 0; i < width * height && (stack = craftMatrix.func_70301_a(i)).func_190926_b(); ++i) {
            }
            Collection list = (Collection)shapelessOneElement.get(FastRecipeLookup.toIntIdentifier((ItemStack)stack));
            if (list != null) {
                for (IRecipe iRecipe : list) {
                    if (!iRecipe.func_77569_a(craftMatrix, worldIn)) continue;
                    return iRecipe;
                }
            }
            for (IRecipe iRecipe : recipeLists.get(0)) {
                if (!iRecipe.func_77569_a(craftMatrix, worldIn)) continue;
                return iRecipe;
            }
        } else if (!noShapeless && nonEmptyStacks > 1) {
            for (IRecipe irecipe : recipeLists.get(nonEmptyStacks - 1)) {
                if (!irecipe.func_77569_a(craftMatrix, worldIn)) continue;
                return irecipe;
            }
        }
        for (int r = base = width * height - 1; r >= 0; --r) {
            for (IRecipe iRecipe : recipeLists.get(18 + r)) {
                if (!iRecipe.func_194133_a(width, height) || !iRecipe.func_77569_a(craftMatrix, worldIn)) continue;
                return iRecipe;
            }
        }
        InventoryCrafting craftMatrixWeird = craftMatrixUntrimmed != null ? craftMatrixUntrimmed : craftMatrix;
        for (int r = base + 1; r < 9; ++r) {
            for (IRecipe irecipe : recipeLists.get(18 + r)) {
                if (!irecipe.func_194133_a(craftMatrixWeird.func_174922_i(), craftMatrixWeird.func_174923_h()) || !irecipe.func_77569_a(craftMatrixWeird, worldIn)) continue;
                return irecipe;
            }
        }
        for (IRecipe iRecipe : recipeLists.get(27)) {
            if (!iRecipe.func_77569_a(craftMatrixWeird, worldIn)) continue;
            return iRecipe;
        }
        return null;
    }

    static {
        saneClasses.add(ShapedOreRecipe.class);
        saneClasses.add(ShapedRecipes.class);
        saneClasses.add(RecipeCharset.Shaped.class);
        saneClasses.add(ShapelessOreRecipe.class);
        saneClasses.add(ShapelessRecipes.class);
        saneClasses.add(RecipeCharset.class);
        FastRecipeLookup.addSaneClass("forestry.core.recipes.ShapedRecipeCustom");
        recipeLists = new ArrayList<Collection<IRecipe>>();
        shapelessOneElement = new TIntObjectHashMap();
    }
}

