/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.lib.network;

import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageCodec;
import java.util.List;
import net.minecraft.network.INetHandler;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IThreadListener;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.internal.FMLProxyPacket;
import pl.asie.charset.lib.network.Packet;
import pl.asie.charset.lib.network.PacketRegistry;

@ChannelHandler.Sharable
public class PacketChannelHandler
extends MessageToMessageCodec<FMLProxyPacket, Packet> {
    private final PacketRegistry registry;

    public PacketChannelHandler(PacketRegistry registry) {
        this.registry = registry;
    }

    protected void encode(ChannelHandlerContext ctx, Packet msg, List<Object> out) throws Exception {
        PacketBuffer buffer = new PacketBuffer(Unpooled.buffer());
        buffer.writeByte(this.registry.getPacketId(msg.getClass()));
        msg.writeData(buffer);
        FMLProxyPacket proxy = new FMLProxyPacket(buffer, (String)ctx.channel().attr(NetworkRegistry.FML_CHANNEL).get());
        out.add(proxy);
    }

    protected void decode(ChannelHandlerContext ctx, FMLProxyPacket msg, List<Object> out) throws Exception {
        INetHandler iNetHandler = (INetHandler)ctx.channel().attr(NetworkRegistry.NET_HANDLER).get();
        Packet newMsg = this.registry.instantiatePacket(msg.payload().readUnsignedByte());
        if (newMsg != null) {
            newMsg.readData(iNetHandler, new PacketBuffer(msg.payload()));
            if (newMsg.isAsynchronous()) {
                newMsg.apply(iNetHandler);
            } else {
                IThreadListener listener = Packet.getThreadListener(iNetHandler);
                if (listener.func_152345_ab()) {
                    newMsg.apply(iNetHandler);
                } else {
                    listener.func_152344_a(() -> newMsg.apply(iNetHandler));
                }
            }
        }
    }
}

