/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.lib.notify.component;

import java.io.IOException;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.fluids.FluidStack;
import pl.asie.charset.lib.notify.component.NotificationComponent;
import pl.asie.charset.lib.notify.component.NotificationComponentFactory;
import pl.asie.charset.lib.utils.FluidUtils;
import pl.asie.charset.lib.utils.ThreeState;
import pl.asie.charset.lib.utils.UtilProxyCommon;

public class NotificationComponentFluidStack
extends NotificationComponent {
    @Nullable
    private final FluidStack stack;
    private final boolean showInfo;

    public NotificationComponentFluidStack(@Nullable FluidStack stack, boolean showInfo) {
        this.stack = stack;
        this.showInfo = showInfo;
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof NotificationComponentFluidStack)) {
            return false;
        }
        NotificationComponentFluidStack ncs = (NotificationComponentFluidStack)other;
        if (this.showInfo != ncs.showInfo) {
            return false;
        }
        if (this.stack == ncs.stack) {
            return true;
        }
        if (this.stack != null && ncs.stack != null) {
            return this.stack.isFluidStackIdentical(ncs.stack);
        }
        return false;
    }

    @Override
    public String toString() {
        if (this.stack != null) {
            StringBuilder builder = new StringBuilder();
            builder.append(FluidUtils.getCorrectLocalizedName(this.stack));
            if (this.showInfo) {
                builder.append('\n');
                ArrayList<String> bits = new ArrayList<String>();
                UtilProxyCommon.proxy.addInformation(this.stack, UtilProxyCommon.proxy.getLocalWorld(), bits, ThreeState.NO);
                boolean tail = false;
                for (String s : bits) {
                    if (tail) {
                        builder.append('\n');
                    } else {
                        tail = true;
                    }
                    builder.append(s);
                }
            }
            return I18n.func_74837_a((String)"notice.charset.fluid", (Object[])new Object[]{Integer.toString(this.stack.amount), builder.toString()});
        }
        return I18n.func_74838_a((String)"notice.charset.fluid.empty");
    }

    public static class Factory
    implements NotificationComponentFactory<NotificationComponentFluidStack> {
        @Override
        public Class<NotificationComponentFluidStack> getComponentClass() {
            return NotificationComponentFluidStack.class;
        }

        @Override
        public void serialize(NotificationComponentFluidStack component, PacketBuffer buffer) {
            buffer.writeBoolean(component.showInfo);
            buffer.writeBoolean(component.stack != null);
            if (component.stack != null) {
                NBTTagCompound cpd = new NBTTagCompound();
                component.stack.writeToNBT(cpd);
                buffer.func_150786_a(cpd);
            }
        }

        @Override
        public NotificationComponentFluidStack deserialize(PacketBuffer buffer) {
            boolean showInfo = buffer.readBoolean();
            if (buffer.readBoolean()) {
                try {
                    NBTTagCompound compound = buffer.func_150793_b();
                    FluidStack stack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)compound);
                    return new NotificationComponentFluidStack(stack, showInfo);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return new NotificationComponentFluidStack(null, showInfo);
        }
    }
}

