/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.lib.notify.component;

import java.io.IOException;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import pl.asie.charset.lib.notify.component.NotificationComponent;
import pl.asie.charset.lib.notify.component.NotificationComponentFactory;
import pl.asie.charset.lib.utils.ThreeState;
import pl.asie.charset.lib.utils.UtilProxyCommon;

public class NotificationComponentItemStack
extends NotificationComponent {
    private final ItemStack stack;
    private final boolean showName;
    private final boolean showInfo;

    public NotificationComponentItemStack(ItemStack stack, boolean showName, boolean showInfo) {
        this.stack = stack;
        this.showName = showName;
        this.showInfo = showInfo;
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof NotificationComponentItemStack)) {
            return false;
        }
        NotificationComponentItemStack ncs = (NotificationComponentItemStack)other;
        if (this.showName != ncs.showName || this.showInfo != ncs.showInfo) {
            return false;
        }
        return ItemStack.func_77989_b((ItemStack)this.stack, (ItemStack)ncs.stack);
    }

    @Override
    public String toString() {
        if (!this.stack.func_190926_b()) {
            StringBuilder builder = new StringBuilder();
            if (this.showName) {
                builder.append(this.stack.func_82833_r());
            }
            if (this.showName && this.showInfo) {
                builder.append('\n');
            }
            if (this.showInfo) {
                ArrayList<String> bits = new ArrayList<String>();
                UtilProxyCommon.proxy.addInformation(this.stack, UtilProxyCommon.proxy.getLocalWorld(), bits, ThreeState.NO);
                boolean tail = false;
                for (String s : bits) {
                    if (tail) {
                        builder.append('\n');
                    } else {
                        tail = true;
                    }
                    builder.append(s);
                }
            }
            return builder.toString();
        }
        return "null";
    }

    public static class Factory
    implements NotificationComponentFactory<NotificationComponentItemStack> {
        @Override
        public Class<NotificationComponentItemStack> getComponentClass() {
            return NotificationComponentItemStack.class;
        }

        @Override
        public void serialize(NotificationComponentItemStack component, PacketBuffer buffer) {
            buffer.writeBoolean(component.showName);
            buffer.writeBoolean(component.showInfo);
            buffer.func_150788_a(component.stack);
        }

        @Override
        public NotificationComponentItemStack deserialize(PacketBuffer buffer) {
            boolean showName = buffer.readBoolean();
            boolean showInfo = buffer.readBoolean();
            try {
                ItemStack stack = buffer.func_150791_c();
                return new NotificationComponentItemStack(stack, showName, showInfo);
            }
            catch (IOException e) {
                return new NotificationComponentItemStack(ItemStack.field_190927_a, showName, showInfo);
            }
        }
    }
}

