/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.lib.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import gnu.trove.iterator.TIntObjectIterator;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.TObjectIntMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import gnu.trove.set.TIntSet;
import gnu.trove.set.hash.TIntHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.crafting.IIngredientFactory;
import net.minecraftforge.common.crafting.JsonContext;
import net.minecraftforge.oredict.OreDictionary;
import pl.asie.charset.lib.recipe.IRecipeResultBuilder;
import pl.asie.charset.lib.recipe.IRecipeView;
import pl.asie.charset.lib.recipe.ingredient.IngredientCharset;
import pl.asie.charset.lib.recipe.ingredient.IngredientWrapper;
import pl.asie.charset.lib.utils.ColorUtils;
import pl.asie.charset.lib.utils.ItemUtils;

public class IngredientGroup
extends IngredientCharset {
    private static final Map<String, Entry> entryMap = new HashMap<String, Entry>();
    private final String type;
    private final String nbtTag;
    private final TIntSet blacklistedIds;
    private final boolean modifyMeta;
    private char dependencyChar;
    private Ingredient dependency;

    public IngredientGroup(String type, String nbtTag, boolean modifyMeta, TIntSet blacklistedIds, char depChar) {
        this.type = type;
        this.nbtTag = nbtTag;
        this.modifyMeta = modifyMeta;
        this.blacklistedIds = blacklistedIds;
        this.dependencyChar = depChar;
    }

    @Override
    public void onAdded(IRecipeView view) {
        if (this.dependencyChar != '\u0000') {
            this.dependency = view.getIngredient(this.dependencyChar);
        }
    }

    public static void register(String type, String id, Object ... objects) {
        Entry e = entryMap.get(type);
        if (e == null) {
            e = new Entry(true);
            entryMap.put(type, e);
        } else if (!e.isStringBased()) {
            throw new RuntimeException("Trying to register string id on int-based entry!");
        }
        for (Object object : objects) {
            IngredientGroup.registerBody(e, e.maxNameId++, object, id);
        }
    }

    public static void register(String type, int id, Object ... objects) {
        Entry e = entryMap.get(type);
        if (e == null) {
            e = new Entry(false);
            entryMap.put(type, e);
        } else if (e.isStringBased()) {
            throw new RuntimeException("Trying to register int id on string-based entry!");
        }
        for (Object object : objects) {
            IngredientGroup.registerBody(e, id, object, null);
        }
    }

    private static void registerBody(Entry e, int id, Object object, String name) {
        if (object instanceof String || object instanceof ItemStack) {
            if (!e.typeMap.containsKey(id)) {
                e.typeMap.put(id, new ArrayList());
            }
            ((List)e.typeMap.get(id)).add(object);
            if (e.isStringBased()) {
                e.idNameMap.put(id, (Object)name);
                e.nameIdMap.put((Object)name, id);
            }
        } else {
            throw new RuntimeException("Unknown/unaccepted type: " + object.getClass().getName() + "!");
        }
    }

    public static void registerDefaults() {
        for (int i = -1; i < 16; ++i) {
            String oreSuffix = i == -1 ? "Colorless" : ColorUtils.getOreDictEntry("", EnumDyeColor.func_176764_b((int)i));
            IngredientGroup.register("glass", i, "blockGlass" + oreSuffix);
            IngredientGroup.register("glassPane", i, "paneGlass" + oreSuffix);
            if (i >= 0) {
                IngredientGroup.register("dye", i, "dye" + oreSuffix);
                IngredientGroup.register("wool", i, new ItemStack(Blocks.field_150325_L, 1, 15 - i));
                ItemStack hc = new ItemStack(Blocks.field_150406_ce, 1, i);
                IngredientGroup.register("hardenedClay", i, hc);
                IngredientGroup.register("hardenedClayStained", i, hc);
                IngredientGroup.register("glassStained", i, "blockGlass" + oreSuffix);
                IngredientGroup.register("glassPaneStained", i, "paneGlass" + oreSuffix);
                continue;
            }
            IngredientGroup.register("hardenedClay", i, new ItemStack(Blocks.field_150405_ch));
        }
    }

    private int getId(ItemStack stack) {
        Entry e = entryMap.get(this.type);
        if (stack.func_190926_b() || e == null) {
            return Integer.MIN_VALUE;
        }
        int[] ids = OreDictionary.getOreIDs((ItemStack)stack);
        TIntObjectIterator iterator = e.typeMap.iterator();
        while (iterator.hasNext()) {
            iterator.advance();
            if (this.blacklistedIds.contains(iterator.key())) continue;
            Collection c = (Collection)iterator.value();
            for (Object o : c) {
                if (o instanceof String) {
                    int targetId = OreDictionary.getOreID((String)((String)o));
                    for (int id : ids) {
                        if (targetId != id) continue;
                        return iterator.key();
                    }
                    continue;
                }
                if (!(o instanceof ItemStack) || !ItemUtils.canMerge(stack, (ItemStack)o)) continue;
                return iterator.key();
            }
        }
        return Integer.MIN_VALUE;
    }

    @Override
    public ItemStack transform(ItemStack stack, ItemStack source, IRecipeResultBuilder builder) {
        if (this.nbtTag != null) {
            int id = this.getId(source);
            Entry e = entryMap.get(this.type);
            if (e != null && e.isStringBased()) {
                ItemUtils.getTagCompound(stack, true).func_74778_a(this.nbtTag, (String)e.idNameMap.get(id));
            } else {
                ItemUtils.getTagCompound(stack, true).func_74768_a(this.nbtTag, id);
            }
        } else if (this.modifyMeta) {
            int id = this.getId(source);
            Entry e = entryMap.get(this.type);
            if (e != null) {
                stack.func_77964_b(stack.func_77952_i() + id);
            }
        }
        return stack;
    }

    @Override
    public boolean arePermutationsDistinct() {
        return this.modifyMeta || this.nbtTag != null;
    }

    @Override
    public boolean matchSameGrid(ItemStack a, ItemStack b) {
        return this.getId(a) == this.getId(b);
    }

    @Override
    public boolean matches(ItemStack stack, IRecipeResultBuilder builder) {
        int id = this.getId(stack);
        if (this.dependency != null && this.dependency instanceof IngredientWrapper && ((IngredientWrapper)this.dependency).getIngredientCharset() instanceof IngredientGroup && id != ((IngredientGroup)((IngredientWrapper)this.dependency).getIngredientCharset()).getId(builder.getStack(this.dependency))) {
            return false;
        }
        return id != Integer.MIN_VALUE;
    }

    @Override
    protected ItemStack[][] createMatchingStacks() {
        TIntArrayList list = new TIntArrayList();
        Entry e = entryMap.get(this.type);
        if (e == null) {
            return new ItemStack[0][0];
        }
        for (int id : e.typeMap.keySet()) {
            if (this.blacklistedIds.contains(id)) continue;
            list.add(id);
        }
        ItemStack[][] stacks = new ItemStack[list.size()][];
        for (int i = 0; i < stacks.length; ++i) {
            Collection c = (Collection)e.typeMap.get(list.get(i));
            int length = 0;
            for (Object o : c) {
                if (o instanceof String) {
                    length += OreDictionary.getOres((String)((String)o)).size();
                    continue;
                }
                if (!(o instanceof ItemStack)) continue;
                ++length;
            }
            stacks[i] = new ItemStack[length];
            int j = 0;
            for (Object o : c) {
                if (o instanceof String) {
                    NonNullList stackList = OreDictionary.getOres((String)((String)o));
                    for (ItemStack stack : stackList) {
                        stacks[i][j++] = stack;
                    }
                    continue;
                }
                if (!(o instanceof ItemStack)) continue;
                stacks[i][j++] = (ItemStack)o;
            }
        }
        return stacks;
    }

    @Override
    public boolean hasMatchingStacks() {
        return true;
    }

    public static class Factory
    implements IIngredientFactory {
        @Nonnull
        public Ingredient parse(JsonContext context, JsonObject json) {
            String type = JsonUtils.func_151200_h((JsonObject)json, (String)"group");
            String tag = json.has("nbtKey") ? JsonUtils.func_151200_h((JsonObject)json, (String)"nbtKey") : null;
            TIntHashSet blacklistedIds = new TIntHashSet();
            if (JsonUtils.func_151204_g((JsonObject)json, (String)"blacklist")) {
                JsonArray array = JsonUtils.func_151214_t((JsonObject)json, (String)"blacklist");
                for (JsonElement e : array) {
                    blacklistedIds.add(e.getAsInt());
                }
            }
            char dep = '\u0000';
            if (JsonUtils.func_151204_g((JsonObject)json, (String)"depends")) {
                dep = JsonUtils.func_151200_h((JsonObject)json, (String)"depends").charAt(0);
            }
            return IngredientCharset.wrap(new IngredientGroup(type, tag, json.has("modifyMeta"), (TIntSet)blacklistedIds, dep));
        }
    }

    private static class Entry {
        private final TIntObjectMap<List> typeMap = new TIntObjectHashMap();
        private final TIntObjectMap<String> idNameMap;
        private final TObjectIntMap<String> nameIdMap;
        private int maxNameId = 0;

        public Entry(boolean stringBased) {
            if (stringBased) {
                this.idNameMap = new TIntObjectHashMap();
                this.nameIdMap = new TObjectIntHashMap();
            } else {
                this.idNameMap = null;
                this.nameIdMap = null;
            }
        }

        public boolean isStringBased() {
            return this.idNameMap != null;
        }
    }
}

