/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.lib.recipe;

import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TCustomHashMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.strategy.HashingStrategy;
import java.lang.invoke.MethodHandle;
import java.util.IdentityHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.crafting.IngredientNBT;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.OreIngredient;
import pl.asie.charset.lib.recipe.RecipeIngredientPatcher;
import pl.asie.charset.lib.utils.ItemStackHashSet;
import pl.asie.charset.lib.utils.MethodHandleHelper;

public class RecipeReplacement {
    public static final RecipeReplacement PRIMARY = new RecipeReplacement();
    private static final MethodHandle ORES_GETTER = MethodHandleHelper.findFieldGetter(OreIngredient.class, "ores");
    private final Map<ItemStack, Object> replacements = new TCustomHashMap((HashingStrategy)new ItemStackHashSet.Strategy(false, true, true));
    private final Map<Item, Object> replaceableItems = new IdentityHashMap<Item, Object>();
    private final TIntObjectMap<Object> replaceableOres = new TIntObjectHashMap();

    public void register() {
        RecipeIngredientPatcher.PRIMARY.add(this::replaceIngredient);
    }

    private void checkTo(Object to) {
        if (!(to instanceof Item || to instanceof ItemStack || to instanceof String)) {
            throw new RuntimeException("Invalid RecipeReplacement target type: " + to.getClass().getName() + "!");
        }
    }

    public void add(ItemStack from, Object to) {
        this.checkTo(to);
        if (from.func_77952_i() == Short.MAX_VALUE) {
            this.replaceableItems.put(from.func_77973_b(), to);
        } else {
            this.replacements.put(from, to);
        }
    }

    public void add(Item from, Object to) {
        this.checkTo(to);
        this.replaceableItems.put(from, to);
    }

    public void add(String from, Object to) {
        this.checkTo(to);
        this.replaceableOres.put(OreDictionary.getOreID((String)from), to);
    }

    @Nullable
    private Ingredient replaceIngredient(Ingredient ing) {
        if (ing.getClass() == Ingredient.class || ing.getClass() == IngredientNBT.class) {
            boolean checkNBT = ing.getClass() == IngredientNBT.class;
            ItemStack[] matchingStacks = ing.func_193365_a();
            ItemStack[] matchingStacksNew = null;
            int replacementOreMatches = 0;
            String replacementOre = null;
            boolean dirty = false;
            for (int j = 0; j < matchingStacks.length; ++j) {
                ItemStack stack = matchingStacks[j];
                if (stack.func_190926_b()) continue;
                ItemStack newStack = null;
                Object replacement = null;
                for (int i : OreDictionary.getOreIDs((ItemStack)stack)) {
                    if (!this.replaceableOres.containsKey(i)) continue;
                    replacement = this.replaceableOres.get(i);
                    break;
                }
                if (replacement == null) {
                    if (this.replacements.containsKey(stack)) {
                        replacement = this.replacements.get(stack);
                    } else if (!checkNBT && this.replaceableItems.containsKey(stack.func_77973_b())) {
                        replacement = this.replaceableItems.get(stack.func_77973_b());
                    }
                }
                if (replacement instanceof Item) {
                    newStack = new ItemStack((Item)replacement, stack.func_190916_E(), stack.func_77952_i());
                    newStack.func_77982_d(stack.func_77978_p());
                } else if (replacement instanceof ItemStack) {
                    newStack = ((ItemStack)this.replacements.get(stack)).func_77946_l();
                    newStack.func_190920_e(stack.func_190916_E());
                } else if (replacement instanceof String) {
                    ++replacementOreMatches;
                    replacementOre = (String)replacement;
                }
                if (newStack == null) continue;
                if (!dirty) {
                    matchingStacksNew = new ItemStack[matchingStacks.length];
                    System.arraycopy(matchingStacks, 0, matchingStacksNew, 0, matchingStacks.length);
                    dirty = true;
                }
                matchingStacksNew[j] = newStack;
            }
            if (replacementOre != null && replacementOreMatches == matchingStacks.length) {
                return new OreIngredient(replacementOre);
            }
            if (matchingStacksNew != null) {
                return Ingredient.func_193369_a(matchingStacksNew);
            }
        } else if (ing.getClass() == OreIngredient.class) {
            try {
                NonNullList list = ORES_GETTER.invokeExact((OreIngredient)ing);
                if (list.isEmpty()) {
                    return null;
                }
                for (int oreId : this.replaceableOres.keySet()) {
                    NonNullList oreList = OreDictionary.getOres((String)OreDictionary.getOreName((int)oreId));
                    if (oreList.isEmpty() || list != oreList) continue;
                    Object replacement = this.replaceableOres.get(oreId);
                    if (replacement instanceof Item) {
                        return Ingredient.func_193367_a((Item)((Item)replacement));
                    }
                    if (replacement instanceof ItemStack) {
                        return Ingredient.func_193369_a((ItemStack[])new ItemStack[]{(ItemStack)replacement});
                    }
                    if (!(replacement instanceof String)) continue;
                    return new OreIngredient((String)replacement);
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        return null;
    }
}

