/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.lib.render;

import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockFaceUV;
import net.minecraft.client.renderer.block.model.BlockPartFace;
import net.minecraft.client.renderer.block.model.FaceBakery;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.model.ITransformation;
import org.lwjgl.util.vector.Vector3f;
import pl.asie.charset.lib.utils.RenderUtils;

public class CharsetFaceBakery
extends FaceBakery {
    public static final CharsetFaceBakery INSTANCE = new CharsetFaceBakery();
    private static final float[] faceBrightness = new float[]{0.5f, 1.0f, 0.8f, 0.8f, 0.6f, 0.6f};

    private CharsetFaceBakery() {
    }

    public static float getFaceBrightness(EnumFacing facing) {
        return facing == null ? 1.0f : faceBrightness[facing.ordinal()];
    }

    public BakedQuad makeBakedQuad(Vector3f min, Vector3f max, int tintIndex, TextureAtlasSprite icon, EnumFacing facing, ITransformation rot, boolean uvLocked) {
        return this.makeBakedQuad(min, max, tintIndex, RenderUtils.calculateUV(min, max, facing), icon, facing, rot, uvLocked);
    }

    public BakedQuad makeBakedQuad(Vector3f min, Vector3f max, int tintIndex, float[] uv, TextureAtlasSprite icon, EnumFacing facing, ITransformation rot, boolean uvLocked) {
        boolean hasColorIndex = tintIndex != -1 && (tintIndex & 0xFF000000) == 0;
        boolean hasColor = tintIndex != -1 && (tintIndex & 0xFF000000) != 0;
        BakedQuad quad = this.makeBakedQuad(min, max, new BlockPartFace(null, hasColorIndex ? tintIndex : -1, "", new BlockFaceUV(uv, 0)), icon, facing, rot, null, uvLocked, true);
        if (hasColor) {
            this.recolorQuad(quad, tintIndex);
        }
        return quad;
    }

    private BakedQuad recolorQuad(BakedQuad quad, int color) {
        int c = quad.getFormat().func_177340_e() / 4;
        int v = 7;
        int[] vertexData = quad.func_178209_a();
        for (int i = 0; i < 4; ++i) {
            vertexData[v * i + c] = RenderUtils.multiplyColor(vertexData[v * i + c], color);
        }
        return quad;
    }
}

