/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.lib.render.model;

import java.util.function.Function;
import javax.annotation.Nullable;
import javax.vecmath.Matrix4f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.model.pipeline.IVertexConsumer;
import net.minecraftforge.client.model.pipeline.LightUtil;
import net.minecraftforge.client.model.pipeline.UnpackedBakedQuad;
import net.minecraftforge.common.model.ITransformation;
import org.lwjgl.util.vector.Vector3f;
import pl.asie.charset.lib.render.model.SimpleBakedModel;

public final class ModelTransformer {
    private ModelTransformer() {
    }

    public static IBakedModel transform(IBakedModel model, IBlockState state, long rand, IVertexTransformer transformer) {
        return ModelTransformer.transform(model, state, rand, transformer, null);
    }

    public static IBakedModel transform(IBakedModel model, IBlockState state, long rand, IVertexTransformer transformer, @Nullable Function<BakedQuad, VertexFormat> format) {
        SimpleBakedModel out = new SimpleBakedModel(model);
        for (int i = 0; i <= 6; ++i) {
            EnumFacing side = i == 6 ? null : EnumFacing.func_82600_a((int)i);
            for (BakedQuad quad : model.func_188616_a(state, side, rand)) {
                out.addQuad(side, ModelTransformer.transform(quad, transformer, format));
            }
        }
        return out;
    }

    public static BakedQuad transform(BakedQuad quad, IVertexTransformer transformer) {
        return ModelTransformer.transform(quad, transformer, null);
    }

    public static BakedQuad transform(BakedQuad quad, IVertexTransformer transformer, @Nullable Function<BakedQuad, VertexFormat> format2) {
        VertexFormat format = format2 != null ? format2.apply(quad) : quad.getFormat();
        UnpackedBakedQuad.Builder builder = new UnpackedBakedQuad.Builder(format);
        LightUtil.putBakedQuad((IVertexConsumer)new VertexTransformerWrapper((IVertexConsumer)builder, quad, transformer), (BakedQuad)quad);
        return builder.build();
    }

    public static interface IVertexTransformer {
        public float[] transform(BakedQuad var1, VertexFormatElement var2, float ... var3);

        public static IVertexTransformer transform(ITransformation transformation) {
            return (quad, element, data) -> {
                switch (element.func_177375_c()) {
                    case POSITION: 
                    case NORMAL: {
                        Vector3f vec = new Vector3f(data[0], data[1], data[2]);
                        ForgeHooksClient.transform((Vector3f)vec, (Matrix4f)transformation.getMatrix());
                        if (element.func_177375_c() == VertexFormatElement.EnumUsage.NORMAL) {
                            vec.normalise();
                        }
                        return new float[]{vec.x, vec.y, vec.z, data[3]};
                    }
                }
                return data;
            };
        }

        public static IVertexTransformer tint(int color) {
            float[] c = new float[]{(float)(color >> 24 & 0xFF) / 255.0f, (float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f};
            return IVertexTransformer.tint(c);
        }

        public static IVertexTransformer tint(float[] color) {
            return (quad, element, data) -> {
                switch (element.func_177375_c()) {
                    case COLOR: {
                        return new float[]{data[0] * color[1], data[1] * color[2], data[2] * color[3], data[3] * color[0]};
                    }
                }
                return data;
            };
        }

        public static IVertexTransformer compose(IVertexTransformer ... ts) {
            return (quad, element, data) -> {
                for (IVertexTransformer t : ts) {
                    data = t.transform(quad, element, data);
                }
                return data;
            };
        }
    }

    private static final class VertexTransformerWrapper
    implements IVertexConsumer {
        private final IVertexConsumer parent;
        private final BakedQuad parentQuad;
        private final VertexFormat format;
        private final IVertexTransformer transformer;

        public VertexTransformerWrapper(IVertexConsumer parent, BakedQuad parentQuad, IVertexTransformer transformer) {
            this.parent = parent;
            this.parentQuad = parentQuad;
            this.format = parent.getVertexFormat();
            this.transformer = transformer;
        }

        public VertexFormat getVertexFormat() {
            return this.format;
        }

        public void setQuadTint(int tint) {
            this.parent.setQuadTint(tint);
        }

        public void setQuadOrientation(EnumFacing orientation) {
            this.parent.setQuadOrientation(orientation);
        }

        public void setApplyDiffuseLighting(boolean diffuse) {
            this.parent.setApplyDiffuseLighting(diffuse);
        }

        public void setTexture(TextureAtlasSprite texture) {
            this.parent.setTexture(texture);
        }

        public void put(int elementId, float ... data) {
            VertexFormatElement element = this.format.func_177348_c(elementId);
            this.parent.put(elementId, this.transformer.transform(this.parentQuad, element, data));
        }
    }
}

