/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.lib.utils;

import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import javax.annotation.Nullable;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public final class ColorUtils {
    private static final String[] UNDERSCORE_DYE_SUFFIXES = new String[]{"white", "orange", "magenta", "light_blue", "yellow", "lime", "pink", "gray", "silver", "cyan", "purple", "blue", "brown", "green", "red", "black"};
    private static final String[] UPPERCASE_DYE_SUFFIXES = new String[]{"White", "Orange", "Magenta", "LightBlue", "Yellow", "Lime", "Pink", "Gray", "LightGray", "Cyan", "Purple", "Blue", "Brown", "Green", "Red", "Black"};
    private static final String[] LOWERCASE_DYE_SUFFIXES = new String[]{"white", "orange", "magenta", "lightBlue", "yellow", "lime", "pink", "gray", "lightGray", "cyan", "purple", "blue", "brown", "green", "red", "black"};
    private static TIntObjectMap<EnumDyeColor> oredictDyeIdMap;
    private static final char[] WOOL_TO_CHAT;

    private ColorUtils() {
    }

    public static TIntObjectMap<EnumDyeColor> getOredictDyeIdMap() {
        if (oredictDyeIdMap == null) {
            oredictDyeIdMap = new TIntObjectHashMap();
            for (int i = 0; i < 16; ++i) {
                oredictDyeIdMap.put(OreDictionary.getOreID((String)("dye" + UPPERCASE_DYE_SUFFIXES[i])), (Object)EnumDyeColor.func_176764_b((int)i));
            }
        }
        return oredictDyeIdMap;
    }

    public static String getNearestTextFormatting(EnumDyeColor color) {
        return "\u00a7" + WOOL_TO_CHAT[color.func_176765_a()];
    }

    @Nullable
    public static EnumDyeColor getDyeColor(ItemStack stack) {
        if (stack.func_190926_b()) {
            return null;
        }
        if (stack.func_77973_b() == Items.field_151100_aR) {
            return EnumDyeColor.func_176766_a((int)stack.func_77952_i());
        }
        int[] itemOreIDs = OreDictionary.getOreIDs((ItemStack)stack);
        TIntObjectMap<EnumDyeColor> map = ColorUtils.getOredictDyeIdMap();
        for (int id : itemOreIDs) {
            EnumDyeColor color = (EnumDyeColor)map.get(id);
            if (color == null) continue;
            return color;
        }
        return null;
    }

    public static boolean isDye(ItemStack stack) {
        return ColorUtils.getDyeColor(stack) != null;
    }

    public static int toIntColor(EnumDyeColor color) {
        float[] d = color.func_193349_f();
        return Math.min(Math.round(d[0] * 255.0f), 255) << 16 | Math.min(Math.round(d[1] * 255.0f), 255) << 8 | Math.min(Math.round(d[2] * 255.0f), 255) | 0xFF000000;
    }

    public static String getOreDictEntry(String prefix, EnumDyeColor wool) {
        return prefix + UPPERCASE_DYE_SUFFIXES[wool.func_176765_a()];
    }

    public static String getLangEntry(String prefix, EnumDyeColor wool) {
        return prefix + LOWERCASE_DYE_SUFFIXES[wool.func_176765_a()];
    }

    public static String stripChatColor(String chat) {
        return chat.replaceAll("[\u00a7][0-9A-FK-ORa-fk-or]", "");
    }

    public static String getUnderscoredSuffix(EnumDyeColor color) {
        return UNDERSCORE_DYE_SUFFIXES[color.func_176765_a()];
    }

    static {
        WOOL_TO_CHAT = new char[]{'f', '6', 'd', '9', 'e', 'a', 'd', '8', '7', '3', '5', '1', '6', '2', '4', '0'};
    }
}

