/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.lib.utils;

import java.io.File;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import org.apache.commons.lang3.tuple.Pair;

public final class ModPathIterator {
    private ModPathIterator() {
    }

    public static Collection<Pair<String, Path>> getValidPaths(String prefix) {
        ArrayList<Pair<String, Path>> paths = new ArrayList<Pair<String, Path>>();
        for (ModContainer container : Loader.instance().getActiveModList()) {
            File file = container.getSource();
            try {
                if (!file.exists()) continue;
                if (file.isDirectory()) {
                    File f = new File(file, prefix.replaceAll("%1", container.getModId()));
                    if (!f.exists()) continue;
                    paths.add((Pair<String, Path>)Pair.of((Object)container.getModId(), (Object)f.toPath()));
                    continue;
                }
                FileSystem fileSystem = FileSystems.newFileSystem(file.toPath(), null);
                Path p = fileSystem.getPath(prefix.replaceAll("%1", container.getModId()), new String[0]);
                if (!Files.exists(p, new LinkOption[0])) continue;
                paths.add((Pair<String, Path>)Pair.of((Object)container.getModId(), (Object)p));
            }
            catch (FileSystemNotFoundException | NoSuchFileException fileSystem) {
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return paths;
    }
}

