/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.lib.utils;

import java.util.Optional;
import javax.annotation.Nonnull;
import javax.vecmath.AxisAngle4f;
import javax.vecmath.Matrix4f;
import javax.vecmath.Vector3f;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.Mirror;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.common.model.IModelPart;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.ITransformation;
import net.minecraftforge.common.model.TRSRTransformation;
import pl.asie.charset.lib.utils.MathUtils;
import pl.asie.charset.lib.utils.Quaternion;
import pl.asie.charset.lib.utils.SpaceUtils;

public enum Orientation implements IModelState,
IStringSerializable,
ITransformation
{
    FACE_DOWN_POINT_SOUTH(EnumFacing.DOWN, EnumFacing.SOUTH),
    FACE_DOWN_POINT_NORTH(EnumFacing.DOWN, EnumFacing.NORTH),
    FACE_DOWN_POINT_EAST(EnumFacing.DOWN, EnumFacing.EAST),
    FACE_DOWN_POINT_WEST(EnumFacing.DOWN, EnumFacing.WEST),
    FACE_UP_POINT_SOUTH(EnumFacing.UP, EnumFacing.SOUTH),
    FACE_UP_POINT_NORTH(EnumFacing.UP, EnumFacing.NORTH),
    FACE_UP_POINT_EAST(EnumFacing.UP, EnumFacing.EAST),
    FACE_UP_POINT_WEST(EnumFacing.UP, EnumFacing.WEST),
    FACE_NORTH_POINT_UP(EnumFacing.NORTH, EnumFacing.UP),
    FACE_NORTH_POINT_DOWN(EnumFacing.NORTH, EnumFacing.DOWN),
    FACE_NORTH_POINT_EAST(EnumFacing.NORTH, EnumFacing.EAST),
    FACE_NORTH_POINT_WEST(EnumFacing.NORTH, EnumFacing.WEST),
    FACE_SOUTH_POINT_UP(EnumFacing.SOUTH, EnumFacing.UP),
    FACE_SOUTH_POINT_DOWN(EnumFacing.SOUTH, EnumFacing.DOWN),
    FACE_SOUTH_POINT_EAST(EnumFacing.SOUTH, EnumFacing.EAST),
    FACE_SOUTH_POINT_WEST(EnumFacing.SOUTH, EnumFacing.WEST),
    FACE_WEST_POINT_UP(EnumFacing.WEST, EnumFacing.UP),
    FACE_WEST_POINT_DOWN(EnumFacing.WEST, EnumFacing.DOWN),
    FACE_WEST_POINT_SOUTH(EnumFacing.WEST, EnumFacing.SOUTH),
    FACE_WEST_POINT_NORTH(EnumFacing.WEST, EnumFacing.NORTH),
    FACE_EAST_POINT_UP(EnumFacing.EAST, EnumFacing.UP),
    FACE_EAST_POINT_DOWN(EnumFacing.EAST, EnumFacing.DOWN),
    FACE_EAST_POINT_SOUTH(EnumFacing.EAST, EnumFacing.SOUTH),
    FACE_EAST_POINT_NORTH(EnumFacing.EAST, EnumFacing.NORTH);

    public final EnumFacing facing;
    public final EnumFacing top;
    private final Orientation[] rotations = new Orientation[EnumFacing.field_82609_l.length];
    private int rotation;
    private Orientation swapped;
    private final EnumFacing[] dirRotations = new EnumFacing[EnumFacing.field_82609_l.length];
    private static final Orientation[] valuesCache;
    private Matrix4f _matrix_cache;

    private Orientation(EnumFacing facing, EnumFacing top) {
        this.facing = facing;
        this.top = top;
    }

    private void setupRotationFacing() {
        this.rotations[this.facing.func_176734_d().ordinal()] = Orientation.find(this.facing, SpaceUtils.rotateCounterclockwise(this.top, this.facing));
        this.rotations[this.facing.ordinal()] = Orientation.find(this.facing, SpaceUtils.rotateClockwise(this.top, this.facing));
    }

    private void setupRotationTop() {
        this.rotations[this.top.func_176734_d().ordinal()] = this.getSwapped().getNextRotationOnFace().getSwapped();
        this.rotations[this.top.ordinal()] = this.getSwapped().getPrevRotationOnFace().getSwapped();
    }

    private void setupRotationAll() {
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            if (dir.func_176740_k() == this.facing.func_176740_k() || dir.func_176740_k() == this.top.func_176740_k()) continue;
            this.rotations[dir.ordinal()] = dir.func_176743_c() == EnumFacing.AxisDirection.NEGATIVE ? Orientation.find(this.facing.func_176732_a(dir.func_176740_k()), this.top.func_176732_a(dir.func_176740_k())) : Orientation.find(this.facing.func_176732_a(dir.func_176740_k()).func_176732_a(dir.func_176740_k()).func_176732_a(dir.func_176740_k()), this.top.func_176732_a(dir.func_176740_k()).func_176732_a(dir.func_176740_k()).func_176732_a(dir.func_176740_k()));
        }
        int rcount = 0;
        Orientation head = Orientation.fromDirection(this.facing);
        for (int i = 0; i < 5; ++i) {
            if (head == this) {
                this.rotation = rcount;
            }
            ++rcount;
            head = head.getNextRotationOnFace();
        }
    }

    private void setupDirectionRotation() {
        for (EnumFacing dir : EnumFacing.values()) {
            Vec3d v = SpaceUtils.fromDirection(dir);
            Quaternion.fromOrientation(this).applyRotation(v);
            this.dirRotations[dir.ordinal()] = SpaceUtils.getClosestDirection(v, null);
        }
    }

    private static Orientation find(EnumFacing f, EnumFacing t) {
        for (int i = f.ordinal() * 4; i < f.ordinal() * 4 + 4; ++i) {
            Orientation o = valuesCache[i];
            if (o.top != t) continue;
            return o;
        }
        return null;
    }

    public String func_176610_l() {
        return this.name().toLowerCase();
    }

    public Orientation rotateOnFace(int count) {
        if ((count %= 4) > 0) {
            Orientation here = this;
            while (count > 0) {
                --count;
                here = here.getNextRotationOnFace();
            }
            return here;
        }
        if (count < 0) {
            Orientation here = this;
            while (count < 0) {
                ++count;
                here = here.getPrevRotationOnFace();
            }
            return here;
        }
        return this;
    }

    public Orientation getNextRotationOnFace() {
        return this.rotations[this.facing.func_176734_d().ordinal()];
    }

    public Orientation getPrevRotationOnFace() {
        return this.rotations[this.facing.ordinal()];
    }

    public Orientation getNextRotationOnTop() {
        return this.rotations[this.top.func_176734_d().ordinal()];
    }

    public Orientation getPrevRotationOnTop() {
        return this.rotations[this.top.ordinal()];
    }

    public Orientation rotateOnTop(int count) {
        return this.getSwapped().rotateOnFace(count).getSwapped();
    }

    public static Orientation getOrientation(int index) {
        if (index >= 0 && index < valuesCache.length) {
            return valuesCache[index];
        }
        return null;
    }

    public static Orientation fromDirection(EnumFacing dir) {
        if (dir == null) {
            return null;
        }
        return valuesCache[dir.ordinal() * 4];
    }

    @Deprecated
    public TRSRTransformation toTransformation() {
        return new TRSRTransformation(this.getMatrix());
    }

    public Matrix4f getMatrix() {
        if (this._matrix_cache == null) {
            Quaternion quat = Quaternion.fromOrientation(this.getSwapped());
            Matrix4f trans = MathUtils.newJavaxIdentityMat();
            Matrix4f rot = MathUtils.newJavaxIdentityMat();
            Matrix4f r90 = MathUtils.newJavaxIdentityMat();
            r90.setRotation(new AxisAngle4f(0.0f, 1.0f, 0.0f, 1.5707964f));
            trans.setTranslation(new Vector3f(0.5f, 0.5f, 0.5f));
            Matrix4f iTrans = new Matrix4f(trans);
            iTrans.invert();
            rot.setRotation(quat.toJavax());
            rot.mul(r90);
            trans.mul(rot);
            trans.mul(iTrans);
            this._matrix_cache = trans;
        }
        return (Matrix4f)this._matrix_cache.clone();
    }

    public Optional<TRSRTransformation> apply(Optional<? extends IModelPart> part) {
        return part.isPresent() ? Optional.empty() : Optional.of(new TRSRTransformation(this.getMatrix()));
    }

    public EnumFacing rotate(EnumFacing facing) {
        return TRSRTransformation.rotate((Matrix4f)this.getMatrix(), (EnumFacing)facing);
    }

    public int rotate(EnumFacing facing, int vertexIndex) {
        return vertexIndex;
    }

    public Orientation pointTopTo(EnumFacing newTop) {
        Orientation fzo = this;
        for (int i = 0; i < 4; ++i) {
            if (fzo.top == newTop) {
                return fzo;
            }
            fzo = fzo.getNextRotationOnFace();
        }
        return null;
    }

    public Orientation mirror(@Nonnull Mirror mirror) {
        EnumFacing.Axis axis = null;
        switch (mirror) {
            case NONE: {
                return this;
            }
            case FRONT_BACK: {
                axis = EnumFacing.Axis.X;
                break;
            }
            case LEFT_RIGHT: {
                axis = EnumFacing.Axis.Z;
            }
        }
        if (this.facing.func_176740_k() == axis) {
            return Orientation.find(this.facing.func_176734_d(), this.top);
        }
        if (this.top.func_176740_k() == axis) {
            return Orientation.find(this.facing, this.top.func_176734_d());
        }
        return this;
    }

    public Orientation rotateAround(@Nonnull EnumFacing axis) {
        return this.rotations[axis.ordinal()];
    }

    public int getRotation() {
        return this.rotation;
    }

    public Vec3d getDiagonalVector() {
        return new Vec3d((double)(this.facing.func_176730_m().func_177958_n() + this.top.func_176730_m().func_177958_n()), (double)(this.facing.func_176730_m().func_177956_o() + this.top.func_176730_m().func_177956_o()), (double)(this.facing.func_176730_m().func_177952_p() + this.top.func_176730_m().func_177952_p()));
    }

    public Orientation getSwapped() {
        return this.swapped;
    }

    public EnumFacing applyRotation(EnumFacing dir) {
        return this.dirRotations[dir.ordinal()];
    }

    static {
        valuesCache = Orientation.values();
        block0: for (Orientation o : Orientation.values()) {
            for (Orientation t : Orientation.values()) {
                if (o.facing != t.top || o.top != t.facing) continue;
                o.swapped = t;
                continue block0;
            }
        }
        for (Orientation o : Orientation.values()) {
            o.setupRotationFacing();
        }
        for (Orientation o : Orientation.values()) {
            o.setupRotationTop();
        }
        for (Orientation o : Orientation.values()) {
            o.setupRotationAll();
        }
        for (Orientation o : Orientation.values()) {
            o.setupDirectionRotation();
        }
        if (valuesCache.length == 0) {
            throw new RuntimeException("this is weird");
        }
    }
}

