/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.lib.utils;

import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import pl.asie.charset.api.lib.IAxisRotatable;
import pl.asie.charset.lib.capability.Capabilities;
import pl.asie.charset.lib.capability.CapabilityHelper;

public final class RotationUtils {
    private RotationUtils() {
    }

    public static int getClockwiseRotationCount(Rotation rotation) {
        switch (rotation) {
            default: {
                return 0;
            }
            case CLOCKWISE_90: {
                return 1;
            }
            case CLOCKWISE_180: {
                return 2;
            }
            case COUNTERCLOCKWISE_90: 
        }
        return 3;
    }

    private static boolean overridesWithRotation(IBlockState state) {
        return state.func_185907_a(Rotation.CLOCKWISE_90) != state;
    }

    public static boolean rotateAround(World world, BlockPos pos, EnumFacing axis) {
        return RotationUtils.rotateAround(world, pos, axis, 1);
    }

    public static boolean rotateAround(World world, BlockPos pos, EnumFacing axis, int count) {
        IAxisRotatable rotatable;
        if ((count &= 3) == 3) {
            count = 1;
            axis = axis.func_176734_d();
        }
        if ((rotatable = CapabilityHelper.get((IBlockAccess)world, pos, Capabilities.AXIS_ROTATABLE, axis, true, true, false)) != null) {
            for (int i = 0; i < count; ++i) {
                if (rotatable.rotateAround(axis, false)) continue;
                return false;
            }
            return true;
        }
        if (axis.func_176740_k() == EnumFacing.Axis.Y) {
            boolean rotatedPreviously = false;
            int rotCount = axis == EnumFacing.UP ? 4 - count : count;
            Rotation rotation = Rotation.NONE;
            switch (rotCount) {
                case 1: {
                    rotation = Rotation.CLOCKWISE_90;
                    break;
                }
                case 2: {
                    rotation = Rotation.CLOCKWISE_180;
                    break;
                }
                case 3: {
                    rotation = Rotation.COUNTERCLOCKWISE_90;
                }
            }
            IBlockState state = world.func_180495_p(pos);
            if (RotationUtils.overridesWithRotation(state) && rotation != Rotation.NONE) {
                world.func_175656_a(pos, state.func_185907_a(rotation));
                rotatedPreviously = true;
            }
            if (!rotatedPreviously) {
                for (IProperty prop : state.func_177228_b().keySet()) {
                    Comparable facing;
                    if (!prop.func_177701_a().equals("facing") && !prop.func_177701_a().equals("rotation") || !((facing = state.func_177229_b(prop)) instanceof EnumFacing)) continue;
                    for (int i = 0; i < rotCount; ++i) {
                        facing = ((EnumFacing)facing).func_176732_a(EnumFacing.Axis.Y);
                    }
                    if (!prop.func_177700_c().contains(facing)) continue;
                    world.func_175656_a(pos, state.func_177226_a(prop, (Comparable)((EnumFacing)facing)));
                    return true;
                }
            } else {
                return true;
            }
        }
        return false;
    }

    @Deprecated
    public static Vec3d rotateVec(Vec3d vec, EnumFacing facing) {
        switch (facing) {
            default: {
                return vec;
            }
            case UP: {
                return new Vec3d(vec.field_72450_a, 1.0 - vec.field_72448_b, vec.field_72449_c);
            }
            case NORTH: {
                return new Vec3d(vec.field_72450_a, vec.field_72449_c, vec.field_72448_b);
            }
            case SOUTH: {
                return new Vec3d(vec.field_72450_a, vec.field_72449_c, 1.0 - vec.field_72448_b);
            }
            case WEST: {
                return new Vec3d(vec.field_72448_b, vec.field_72449_c, vec.field_72450_a);
            }
            case EAST: 
        }
        return new Vec3d(1.0 - vec.field_72448_b, vec.field_72449_c, vec.field_72450_a);
    }

    @Deprecated
    public static AxisAlignedBB rotateFace(AxisAlignedBB box, EnumFacing facing) {
        switch (facing) {
            default: {
                return box;
            }
            case UP: {
                return new AxisAlignedBB(box.field_72340_a, 1.0 - box.field_72337_e, box.field_72339_c, box.field_72336_d, 1.0 - box.field_72338_b, box.field_72334_f);
            }
            case NORTH: {
                return new AxisAlignedBB(box.field_72340_a, box.field_72339_c, box.field_72338_b, box.field_72336_d, box.field_72334_f, box.field_72337_e);
            }
            case SOUTH: {
                return new AxisAlignedBB(box.field_72340_a, box.field_72339_c, 1.0 - box.field_72337_e, box.field_72336_d, box.field_72334_f, 1.0 - box.field_72338_b);
            }
            case WEST: {
                return new AxisAlignedBB(box.field_72338_b, box.field_72339_c, box.field_72340_a, box.field_72337_e, box.field_72334_f, box.field_72336_d);
            }
            case EAST: 
        }
        return new AxisAlignedBB(1.0 - box.field_72337_e, box.field_72339_c, box.field_72340_a, 1.0 - box.field_72338_b, box.field_72334_f, box.field_72336_d);
    }
}

