/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.lib.wires;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import mcmultipart.api.container.IPartInfo;
import mcmultipart.api.slot.EnumCenterSlot;
import mcmultipart.api.slot.EnumFaceSlot;
import mcmultipart.api.slot.IPartSlot;
import mcmultipart.api.world.IMultipartWorld;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pl.asie.charset.api.wires.WireFace;
import pl.asie.charset.lib.block.BlockBase;
import pl.asie.charset.lib.modcompat.mcmultipart.IMultipartBase;
import pl.asie.charset.lib.wires.TileWire;
import pl.asie.charset.lib.wires.Wire;
import pl.asie.charset.lib.wires.WireUtils;

public class BlockWire
extends BlockBase
implements IMultipartBase,
ITileEntityProvider {
    protected static final PropertyBool REDSTONE = PropertyBool.func_177716_a((String)"redstone");

    public BlockWire() {
        super(Material.field_151594_q);
        this.func_149711_c(0.0f);
        this.setOpaqueCube(false);
        this.setFullCube(false);
    }

    @Override
    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> itemList) {
    }

    public boolean func_149744_f(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)REDSTONE);
    }

    public boolean canConnectRedstone(IBlockState blockState, IBlockAccess world, BlockPos pos, @Nullable EnumFacing side) {
        Wire wire;
        if (((Boolean)blockState.func_177229_b((IProperty)REDSTONE)).booleanValue() && (wire = WireUtils.getAnyWire(world, pos)) != null) {
            return wire.canConnectRedstone(side);
        }
        return false;
    }

    public int func_176211_b(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        Wire wire;
        if (((Boolean)blockState.func_177229_b((IProperty)REDSTONE)).booleanValue() && (wire = WireUtils.getAnyWire(blockAccess, pos)) != null) {
            return wire.getStrongPower(side);
        }
        return super.func_176211_b(blockState, blockAccess, pos, side);
    }

    public int func_180656_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        Wire wire;
        if (((Boolean)blockState.func_177229_b((IProperty)REDSTONE)).booleanValue() && (wire = WireUtils.getAnyWire(blockAccess, pos)) != null) {
            return wire.getWeakPower(side);
        }
        return super.func_180656_a(blockState, blockAccess, pos, side);
    }

    public boolean shouldCheckWeakPower(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        Wire wire;
        if (((Boolean)blockState.func_177229_b((IProperty)REDSTONE)).booleanValue() && (wire = WireUtils.getAnyWire(blockAccess, pos)) != null) {
            return wire.shouldCheckWeakPower(side);
        }
        return false;
    }

    @Nullable
    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileWire();
    }

    public int func_176201_c(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)REDSTONE) != false ? 1 : 0;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)REDSTONE, (Comparable)Boolean.valueOf(meta > 0));
    }

    protected BlockStateContainer func_180661_e() {
        return new ExtendedBlockState((Block)this, new IProperty[]{REDSTONE}, new IUnlistedProperty[]{Wire.PROPERTY});
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        Wire wire = WireUtils.getAnyWire((IBlockAccess)worldIn, pos);
        if (wire != null) {
            int connMask = wire.getConnectionMask();
            super.func_180663_b(worldIn, pos, state);
            this.requestNeighborUpdate(worldIn, pos, wire.getLocation(), connMask);
        } else {
            super.func_180663_b(worldIn, pos, state);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        return ((IExtendedBlockState)state).withProperty(Wire.PROPERTY, (Object)WireUtils.getAnyWire(world, pos));
    }

    public List<AxisAlignedBB> getOcclusionBoxes(IPartInfo part) {
        Wire wire = WireUtils.getAnyWire((IBlockAccess)part.getPartWorld(), part.getPartPos());
        if (wire != null) {
            return Collections.singletonList(wire.getProvider().getSelectionBox(wire.getLocation(), 0));
        }
        return Collections.emptyList();
    }

    public RayTraceResult collisionRayTrace(IPartInfo part, Vec3d start, Vec3d end) {
        Wire wire = WireUtils.getAnyWire(part.getTile().getTileEntity());
        if (wire != null) {
            RayTraceResult result = this.func_185503_a(part.getPartPos(), start, end, wire.getProvider().getSelectionBox(wire.getLocation(), 0));
            if (result != null) {
                result.hitInfo = part;
                return result;
            }
            EnumFacing[] faces = WireUtils.getConnectionsForRender(wire.getLocation());
            for (int i = 0; i < faces.length; ++i) {
                EnumFacing face = faces[i];
                if (!wire.connectsAny(face) || (result = this.func_185503_a(part.getPartPos(), start, end, wire.getProvider().getSelectionBox(wire.getLocation(), i + 1))) == null) continue;
                result.hitInfo = part;
                return result;
            }
        }
        return null;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        Wire wire = WireUtils.getAnyWire(source, pos);
        if (wire != null) {
            return wire.getProvider().getSelectionBox(wire.getLocation(), 0);
        }
        return field_185505_j;
    }

    public static WireFace getFace(IPartSlot slot) {
        return slot instanceof EnumFaceSlot ? WireFace.get(((EnumFaceSlot)slot).getFacing()) : WireFace.CENTER;
    }

    public void onPartPlacedBy(IPartInfo part, EntityLivingBase placer, ItemStack stack) {
        ((TileWire)part.getTile().getTileEntity()).onPlacedBy(BlockWire.getFace(part.getSlot()), stack);
    }

    public void onPartChanged(IPartInfo part, IPartInfo otherPart) {
        Wire wire;
        if (part != otherPart && (wire = WireUtils.getAnyWire((IBlockAccess)part.getPartWorld(), part.getPartPos())) != null) {
            wire.onChanged(false);
        }
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        Wire wire = WireUtils.getAnyWire((IBlockAccess)worldIn, pos);
        if (wire != null) {
            wire.onChanged(true);
        }
    }

    public IPartSlot getSlotForPlacement(World world, BlockPos pos, IBlockState state, EnumFacing facing, float hitX, float hitY, float hitZ, EntityLivingBase placer) {
        ItemStack stack = placer.func_184614_ca();
        WireFace location = (stack.func_77960_j() & 1) != 0 ? WireFace.CENTER : WireFace.get(facing.func_176734_d());
        return WireUtils.toPartSlot(location);
    }

    public IPartSlot getSlotFromWorld(IBlockAccess world, BlockPos pos, IBlockState state) {
        Wire wire = WireUtils.getAnyWire(world, pos);
        if (wire != null) {
            return WireUtils.toPartSlot(wire.getLocation());
        }
        return EnumCenterSlot.CENTER;
    }

    public void requestNeighborUpdate(World world, BlockPos pos, WireFace location, int connectionMask) {
        if ((connectionMask & 0xFF) != 0 && world instanceof IMultipartWorld) {
            IPartInfo info = ((IMultipartWorld)world).getPartInfo();
            info.getContainer().notifyChange(info);
        }
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            if (world.field_72995_K) {
                if ((connectionMask & 1 << facing.ordinal() + 8) != 0) {
                    WireUtils.getAllWires((IBlockAccess)world, pos.func_177972_a(facing)).forEach(wire -> wire.onChanged(true));
                    continue;
                }
                if (location == WireFace.CENTER || location.facing.func_176740_k() == facing.func_176740_k()) continue;
                WireUtils.getAllWires((IBlockAccess)world, pos.func_177972_a(facing).func_177972_a(location.facing)).forEach(wire -> wire.onChanged(true));
                continue;
            }
            if ((connectionMask & 1 << facing.ordinal() + 8) != 0) {
                world.func_190524_a(pos.func_177972_a(facing), (Block)this, pos);
                continue;
            }
            if (location == WireFace.CENTER || location.facing.func_176740_k() == facing.func_176740_k()) continue;
            world.func_190524_a(pos.func_177972_a(facing).func_177972_a(location.facing), (Block)this, pos);
        }
    }
}

