/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.lib.wires;

import mcmultipart.api.item.ItemBlockMultipart;
import mcmultipart.api.multipart.IMultipart;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import pl.asie.charset.api.wires.WireFace;
import pl.asie.charset.lib.wires.BlockWire;
import pl.asie.charset.lib.wires.CharsetLibWires;
import pl.asie.charset.lib.wires.IWireContainer;
import pl.asie.charset.lib.wires.TileWire;
import pl.asie.charset.lib.wires.Wire;
import pl.asie.charset.lib.wires.WireProvider;

public class ItemWire
extends ItemBlockMultipart {
    private final WireProvider provider;

    public ItemWire(WireProvider provider) {
        super((Block)CharsetLibWires.blockWire, (IMultipart)CharsetLibWires.blockWire);
        this.provider = provider;
        this.provider.setItemWire(this);
        this.func_77627_a(true);
    }

    public String func_77653_i(ItemStack stack) {
        Wire wire = this.fromStack(new IWireContainer.Dummy(), stack, EnumFacing.DOWN);
        String tr = "tile.wire.null";
        if (wire != null) {
            String name = wire.getDisplayName();
            tr = "tile." + (wire.getLocation() == WireFace.CENTER ? name + ".freestanding" : name) + ".name";
        }
        return I18n.func_74838_a((String)tr);
    }

    public Wire fromStack(IWireContainer container, ItemStack stack, EnumFacing facing) {
        if (this.provider != null) {
            WireFace location = (stack.func_77960_j() & 1) != 0 ? WireFace.CENTER : WireFace.get(facing);
            return this.provider.create(container, location);
        }
        return null;
    }

    public ItemStack toStack(boolean freestanding, int amount) {
        return new ItemStack((Item)this, amount, freestanding ? 1 : 0);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        return ItemWire.place((EntityPlayer)player, (World)world, (BlockPos)pos, (EnumHand)hand, (EnumFacing)facing, (float)hitX, (float)hitY, (float)hitZ, (Item)this, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6, arg_7, arg_8) -> ((Block)this.field_150939_a).getStateForPlacement(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6, arg_7, arg_8), (IMultipart)this.multipartBlock, this::placeBlockAtTested, this::placeWirePartAt);
    }

    public boolean placeWirePartAt(ItemStack stack, EntityPlayer player, EnumHand hand, World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, IMultipart multipartBlock, IBlockState state) {
        WireFace location;
        WireFace wireFace = location = (stack.func_77960_j() & 1) != 0 ? WireFace.CENTER : WireFace.get(facing.func_176734_d());
        if (!this.provider.canPlace((IBlockAccess)world, pos, location)) {
            return false;
        }
        return ItemBlockMultipart.placePartAt((ItemStack)stack, (EntityPlayer)player, (EnumHand)hand, (World)world, (BlockPos)pos, (EnumFacing)facing, (float)hitX, (float)hitY, (float)hitZ, (IMultipart)multipartBlock, (IBlockState)state);
    }

    public boolean placeBlockAtTested(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, IBlockState newState) {
        WireFace location;
        WireFace wireFace = location = (stack.func_77960_j() & 1) != 0 ? WireFace.CENTER : WireFace.get(facing.func_176734_d());
        if (!this.provider.canPlace((IBlockAccess)world, pos, location)) {
            return false;
        }
        if (this.provider.canProvidePower()) {
            newState = newState.func_177226_a((IProperty)BlockWire.REDSTONE, (Comparable)Boolean.valueOf(true));
        }
        if (super.placeBlockAtTested(stack, player, world, pos, facing, hitX, hitY, hitZ, newState)) {
            TileEntity tileEntity = world.func_175625_s(pos);
            if (tileEntity instanceof TileWire) {
                ((TileWire)tileEntity).onPlacedBy(WireFace.get(facing != null ? facing.func_176734_d() : null), stack);
            }
            return true;
        }
        return false;
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> subItems) {
        if (this.func_194125_a(tab)) {
            if (this.provider.hasSidedWire()) {
                subItems.add((Object)new ItemStack((Item)this, 1, 0));
            }
            if (this.provider.hasFreestandingWire()) {
                subItems.add((Object)new ItemStack((Item)this, 1, 1));
            }
        }
    }

    public WireProvider getWireProvider() {
        return this.provider;
    }
}

