/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import mcjty.lib.base.ModBase;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class McJtyRegister {
    private static final List<MBlock> blocks = new ArrayList<MBlock>();
    private static final Map<Block, MTile> tiles = new HashMap<Block, MTile>();
    private static final List<MItem> items = new ArrayList<MItem>();

    public static void registerLater(Block block, ModBase mod, @Nullable Class<? extends ItemBlock> itemBlockClass) {
        blocks.add(new MBlock(block, mod, itemBlockClass));
    }

    public static void registerLater(Block block, @Nullable Class<? extends TileEntity> tileEntityClass) {
        tiles.put(block, new MTile(tileEntityClass));
    }

    public static void registerLater(Item item, ModBase mod) {
        items.add(new MItem(item, mod));
    }

    public static void registerBlocks(ModBase mod, IForgeRegistry<Block> registry) {
        for (MBlock mBlock : blocks) {
            if (!mBlock.getMod().getModId().equals(mod.getModId())) continue;
            registry.register((IForgeRegistryEntry)mBlock.getBlock());
            if (!tiles.containsKey(mBlock.getBlock())) continue;
            MTile tile = tiles.get(mBlock.getBlock());
            if (tile.getTileEntityClass() == null) {
                throw new RuntimeException("Bad tile entity registration for block: " + mBlock.getBlock().getRegistryName().toString());
            }
            GameRegistry.registerTileEntity(tile.getTileEntityClass(), (String)(mBlock.getMod().getModId() + "_" + mBlock.getBlock().getRegistryName().func_110623_a()));
        }
    }

    public static void registerItems(ModBase mod, IForgeRegistry<Item> registry) {
        for (MItem item : items) {
            if (!item.getMod().getModId().equals(mod.getModId())) continue;
            registry.register((IForgeRegistryEntry)item.getItem());
        }
        for (MBlock mBlock : blocks) {
            if (mBlock.getItemBlockClass() == null || !mBlock.getMod().getModId().equals(mod.getModId())) continue;
            ItemBlock itemBlock = McJtyRegister.createItemBlock(mBlock.getBlock(), mBlock.getItemBlockClass());
            itemBlock.setRegistryName(mBlock.getBlock().getRegistryName());
            registry.register((IForgeRegistryEntry)itemBlock);
        }
    }

    private static ItemBlock createItemBlock(Block block, Class<? extends ItemBlock> itemBlockClass) {
        try {
            Class[] ctorArgClasses = new Class[]{Block.class};
            Constructor<? extends ItemBlock> itemCtor = itemBlockClass.getConstructor(ctorArgClasses);
            return itemCtor.newInstance(block);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private static class MItem {
        private final Item item;
        private final ModBase mod;

        public MItem(Item item, ModBase mod) {
            this.item = item;
            this.mod = mod;
        }

        public Item getItem() {
            return this.item;
        }

        public ModBase getMod() {
            return this.mod;
        }
    }

    private static class MBlock {
        private final Block block;
        private final ModBase mod;
        private final Class<? extends ItemBlock> itemBlockClass;

        public MBlock(Block block, ModBase mod, Class<? extends ItemBlock> itemBlockClass) {
            this.block = block;
            this.mod = mod;
            this.itemBlockClass = itemBlockClass;
        }

        public Block getBlock() {
            return this.block;
        }

        public ModBase getMod() {
            return this.mod;
        }

        public Class<? extends ItemBlock> getItemBlockClass() {
            return this.itemBlockClass;
        }
    }

    private static class MTile {
        private final Class<? extends TileEntity> tileEntityClass;

        public MTile(Class<? extends TileEntity> tileEntityClass) {
            this.tileEntityClass = tileEntityClass;
        }

        public Class<? extends TileEntity> getTileEntityClass() {
            return this.tileEntityClass;
        }
    }
}

