/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.container;

import com.google.common.base.Predicate;
import java.util.Collection;
import java.util.List;
import mcjty.lib.McJtyRegister;
import mcjty.lib.base.ModBase;
import mcjty.lib.compat.theoneprobe.TOPInfoProvider;
import mcjty.lib.compat.waila.WailaInfoProvider;
import mcjty.lib.varia.OrientationTools;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Optional.InterfaceList(value={@Optional.Interface(iface="mcjty.lib.compat.waila.WailaInfoProvider", modid="waila"), @Optional.Interface(iface="mcjty.lib.compat.theoneprobe.TOPInfoProvider", modid="theoneprobe")})
public class BaseBlock
extends Block
implements WailaInfoProvider,
TOPInfoProvider {
    protected ModBase modBase;
    private boolean creative;
    public static final PropertyDirection FACING_HORIZ = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);
    public static final PropertyDirection FACING = PropertyDirection.func_177714_a((String)"facing");

    public BaseBlock(ModBase mod, Material material, String name, Class<? extends ItemBlock> itemBlockClass) {
        super(material);
        this.modBase = mod;
        this.creative = false;
        this.func_149711_c(2.0f);
        this.func_149672_a(SoundType.field_185852_e);
        this.setHarvestLevel("pickaxe", 0);
        this.func_149663_c(mod.getModId() + "." + name);
        this.setRegistryName(name);
        McJtyRegister.registerLater(this, mod, itemBlockClass);
    }

    public void setCreative(boolean creative) {
        this.creative = creative;
    }

    public boolean isCreative() {
        return this.creative;
    }

    public static Collection<IProperty<?>> getPropertyKeys(IBlockState state) {
        return state.func_177227_a();
    }

    public static boolean activateBlock(Block block, World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        return block.func_180639_a(world, pos, state, player, hand, facing, hitX, hitY, hitZ);
    }

    public RotationType getRotationType() {
        return RotationType.ROTATION;
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        IBlockState state = super.func_180642_a(worldIn, pos, facing, hitX, hitY, hitZ, meta, placer);
        switch (this.getRotationType()) {
            case HORIZROTATION: {
                return state.func_177226_a((IProperty)FACING_HORIZ, (Comparable)placer.func_174811_aO().func_176734_d());
            }
            case ROTATION: {
                return state.func_177226_a((IProperty)FACING, (Comparable)OrientationTools.getFacingFromEntity(pos, placer));
            }
        }
        return state;
    }

    protected EnumFacing getOrientation(BlockPos pos, EntityLivingBase entityLivingBase) {
        switch (this.getRotationType()) {
            case HORIZROTATION: {
                return OrientationTools.determineOrientationHoriz(entityLivingBase);
            }
            case ROTATION: {
                return OrientationTools.determineOrientation(pos, entityLivingBase);
            }
        }
        return null;
    }

    public EnumFacing getFrontDirection(IBlockState state) {
        switch (this.getRotationType()) {
            case HORIZROTATION: {
                return (EnumFacing)state.func_177229_b((IProperty)FACING_HORIZ);
            }
            case ROTATION: {
                return (EnumFacing)state.func_177229_b((IProperty)FACING);
            }
        }
        return EnumFacing.NORTH;
    }

    public EnumFacing getRightDirection(IBlockState state) {
        return this.getFrontDirection(state).func_176735_f();
    }

    public EnumFacing getLeftDirection(IBlockState state) {
        return this.getFrontDirection(state).func_176746_e();
    }

    public static EnumFacing getFrontDirection(RotationType metaUsage, IBlockState state) {
        switch (metaUsage) {
            case HORIZROTATION: {
                return OrientationTools.getOrientationHoriz(state);
            }
            case ROTATION: {
                return OrientationTools.getOrientation(state);
            }
        }
        return EnumFacing.SOUTH;
    }

    public IBlockState func_176203_a(int meta) {
        switch (this.getRotationType()) {
            case HORIZROTATION: {
                return this.func_176223_P().func_177226_a((IProperty)FACING_HORIZ, (Comparable)EnumFacing.field_82609_l[meta + 2]);
            }
            case ROTATION: {
                return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.field_82609_l[meta & 7]);
            }
        }
        return this.func_176223_P();
    }

    public int func_176201_c(IBlockState state) {
        switch (this.getRotationType()) {
            case HORIZROTATION: {
                return ((EnumFacing)state.func_177229_b((IProperty)FACING_HORIZ)).func_176745_a() - 2;
            }
            case ROTATION: {
                return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
            }
        }
        return 0;
    }

    protected BlockStateContainer func_180661_e() {
        switch (this.getRotationType()) {
            case HORIZROTATION: {
                return new BlockStateContainer((Block)this, new IProperty[]{FACING_HORIZ});
            }
            case ROTATION: {
                return new BlockStateContainer((Block)this, new IProperty[]{FACING});
            }
        }
        return super.func_180661_e();
    }

    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory"));
    }

    @Override
    @Optional.Method(modid="theoneprobe")
    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    @Optional.Method(modid="waila")
    public List<String> getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return currenttip;
    }

    public static enum RotationType {
        HORIZROTATION,
        ROTATION,
        NONE;

    }
}

