/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.network;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import mcjty.lib.network.Arguments;
import mcjty.lib.network.PacketDumpBlockInfo;
import mcjty.lib.network.PacketDumpItemInfo;
import mcjty.lib.network.PacketIntegerFromServer;
import mcjty.lib.network.PacketRequestIntegerFromServer;
import mcjty.lib.network.PacketSendClientCommand;
import mcjty.lib.network.PacketSendClientCommandHandler;
import mcjty.lib.network.PacketSendGuiData;
import mcjty.lib.network.PacketSendServerCommand;
import mcjty.lib.network.PacketServerCommand;
import mcjty.lib.network.clientinfo.InfoPacketClient;
import mcjty.lib.network.clientinfo.InfoPacketServer;
import mcjty.lib.network.clientinfo.PacketGetInfoFromServer;
import mcjty.lib.network.clientinfo.PacketReturnInfoToClient;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;

public class PacketHandler {
    public static final int INTERNAL_PACKETS = 12;
    private static int packetId = 12;
    private static Map<Integer, Class<? extends InfoPacketClient>> clientInfoPackets = new HashMap<Integer, Class<? extends InfoPacketClient>>();
    private static Map<Integer, Class<? extends InfoPacketServer>> serverInfoPackets = new HashMap<Integer, Class<? extends InfoPacketServer>>();
    private static Map<Class<? extends InfoPacketClient>, Integer> clientInfoPacketsToId = new HashMap<Class<? extends InfoPacketClient>, Integer>();
    private static Map<Class<? extends InfoPacketServer>, Integer> serverInfoPacketsToId = new HashMap<Class<? extends InfoPacketServer>, Integer>();
    public static Map<String, SimpleNetworkWrapper> modNetworking = new HashMap<String, SimpleNetworkWrapper>();

    public static int nextPacketID() {
        return packetId++;
    }

    public static void register(Integer id, Class<? extends InfoPacketServer> serverClass, Class<? extends InfoPacketClient> clientClass) {
        serverInfoPackets.put(id, serverClass);
        clientInfoPackets.put(id, clientClass);
        serverInfoPacketsToId.put(serverClass, id);
        clientInfoPacketsToId.put(clientClass, id);
    }

    public static Class<? extends InfoPacketServer> getServerInfoPacket(int id) {
        return serverInfoPackets.get(id);
    }

    public static Integer getServerInfoPacketId(Class<? extends InfoPacketServer> clazz) {
        return serverInfoPacketsToId.get(clazz);
    }

    public static Class<? extends InfoPacketClient> getClientInfoPacket(int id) {
        return clientInfoPackets.get(id);
    }

    public static Integer getClientInfoPacketId(Class<? extends InfoPacketClient> clazz) {
        return clientInfoPacketsToId.get(clazz);
    }

    @Deprecated
    public static int nextID() {
        return PacketHandler.nextPacketID();
    }

    public static SimpleNetworkWrapper registerMessages(String modid, String channelName) {
        SimpleNetworkWrapper network = NetworkRegistry.INSTANCE.newSimpleChannel(channelName);
        PacketHandler.registerMessages(network);
        modNetworking.put(modid, network);
        return network;
    }

    public static int registerMessages(SimpleNetworkWrapper networkWrapper) {
        return PacketHandler.registerMessages(networkWrapper, 0);
    }

    public static int registerMessages(SimpleNetworkWrapper networkWrapper, int startIndex) {
        networkWrapper.registerMessage(PacketServerCommand.Handler.class, PacketServerCommand.class, startIndex++, Side.SERVER);
        networkWrapper.registerMessage(PacketSendServerCommand.Handler.class, PacketSendServerCommand.class, startIndex++, Side.SERVER);
        networkWrapper.registerMessage(PacketRequestIntegerFromServer.Handler.class, PacketRequestIntegerFromServer.class, startIndex++, Side.SERVER);
        networkWrapper.registerMessage(PacketGetInfoFromServer.Handler.class, PacketGetInfoFromServer.class, PacketHandler.nextID(), Side.SERVER);
        networkWrapper.registerMessage(PacketDumpItemInfo.Handler.class, PacketDumpItemInfo.class, startIndex++, Side.SERVER);
        networkWrapper.registerMessage(PacketDumpBlockInfo.Handler.class, PacketDumpBlockInfo.class, startIndex++, Side.SERVER);
        networkWrapper.registerMessage(PacketSendClientCommandHandler.class, PacketSendClientCommand.class, startIndex++, Side.CLIENT);
        networkWrapper.registerMessage(PacketIntegerFromServer.Handler.class, PacketIntegerFromServer.class, startIndex++, Side.CLIENT);
        networkWrapper.registerMessage(PacketReturnInfoToClient.Handler.class, PacketReturnInfoToClient.class, PacketHandler.nextID(), Side.CLIENT);
        networkWrapper.registerMessage(PacketSendGuiData.Handler.class, PacketSendGuiData.class, startIndex++, Side.CLIENT);
        return startIndex;
    }

    public static void sendCommand(SimpleNetworkWrapper network, String modid, String command, @Nonnull Arguments arguments) {
        network.sendToServer((IMessage)new PacketSendServerCommand(modid, command, arguments));
    }
}

