/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.varia;

import mcjty.lib.container.BaseBlock;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;

public class OrientationTools {
    public static final int MASK_ORIENTATION = 7;
    public static final int MASK_REDSTONE = 8;
    public static final int MASK_ORIENTATION_HORIZONTAL = 3;
    public static final int MASK_REDSTONE_IN = 8;
    public static final int MASK_REDSTONE_OUT = 4;
    public static final int MASK_STATE = 12;

    public static int setOrientation(int metadata, EnumFacing orientation) {
        return metadata & 0xFFFFFFF8 | orientation.ordinal();
    }

    public static EnumFacing getOrientationHoriz(IBlockState state) {
        return (EnumFacing)state.func_177229_b((IProperty)BaseBlock.FACING_HORIZ);
    }

    public static int setOrientationHoriz(int metadata, EnumFacing orientation) {
        return metadata & 0xFFFFFFFC | OrientationTools.getHorizOrientationMeta(orientation);
    }

    public static int getHorizOrientationMeta(EnumFacing orientation) {
        return orientation.ordinal() - 2;
    }

    public static EnumFacing getOrientation(IBlockState state) {
        return ((BaseBlock)state.func_177230_c()).getFrontDirection(state);
    }

    public static EnumFacing determineOrientation(BlockPos pos, EntityLivingBase entityLivingBase) {
        return OrientationTools.determineOrientation(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), entityLivingBase);
    }

    public static EnumFacing determineOrientation(int x, int y, int z, EntityLivingBase entityLivingBase) {
        int i;
        int l;
        if (MathHelper.func_76135_e((float)((float)entityLivingBase.field_70165_t - (float)x)) < 2.0f && MathHelper.func_76135_e((float)((float)entityLivingBase.field_70161_v - (float)z)) < 2.0f) {
            double d0 = entityLivingBase.field_70163_u + 1.82 - entityLivingBase.func_70033_W();
            if (d0 - (double)y > 2.0) {
                return EnumFacing.UP;
            }
            if ((double)y - d0 > 0.0) {
                return EnumFacing.DOWN;
            }
        }
        return (l = ((double)(entityLivingBase.field_70177_z * 4.0f / 360.0f) + 0.5 < (double)(i = (int)((double)(entityLivingBase.field_70177_z * 4.0f / 360.0f) + 0.5)) ? i - 1 : i) & 3) == 0 ? EnumFacing.NORTH : (l == 1 ? EnumFacing.EAST : (l == 2 ? EnumFacing.SOUTH : (l == 3 ? EnumFacing.WEST : EnumFacing.DOWN)));
    }

    public static EnumFacing determineOrientationHoriz(EntityLivingBase entityLivingBase) {
        int i = (int)((double)(entityLivingBase.field_70177_z * 4.0f / 360.0f) + 0.5);
        int l = ((double)(entityLivingBase.field_70177_z * 4.0f / 360.0f) + 0.5 < (double)i ? i - 1 : i) & 3;
        return l == 0 ? EnumFacing.NORTH : (l == 1 ? EnumFacing.EAST : (l == 2 ? EnumFacing.SOUTH : (l == 3 ? EnumFacing.WEST : EnumFacing.DOWN)));
    }

    public static EnumFacing worldToBlockSpaceHoriz(EnumFacing side, IBlockState state) {
        return OrientationTools.worldToBlockSpace(side, OrientationTools.getOrientationHoriz(state));
    }

    public static EnumFacing worldToBlockSpace(EnumFacing worldSide, EnumFacing blockDirection) {
        switch (blockDirection) {
            case DOWN: {
                switch (worldSide) {
                    case DOWN: {
                        return EnumFacing.SOUTH;
                    }
                    case UP: {
                        return EnumFacing.NORTH;
                    }
                    case NORTH: {
                        return EnumFacing.UP;
                    }
                    case SOUTH: {
                        return EnumFacing.DOWN;
                    }
                    case WEST: {
                        return EnumFacing.EAST;
                    }
                    case EAST: {
                        return EnumFacing.WEST;
                    }
                }
                return worldSide;
            }
            case UP: {
                switch (worldSide) {
                    case DOWN: {
                        return EnumFacing.NORTH;
                    }
                    case UP: {
                        return EnumFacing.SOUTH;
                    }
                    case NORTH: {
                        return EnumFacing.UP;
                    }
                    case SOUTH: {
                        return EnumFacing.DOWN;
                    }
                    case WEST: {
                        return EnumFacing.WEST;
                    }
                    case EAST: {
                        return EnumFacing.EAST;
                    }
                }
                return worldSide;
            }
            case NORTH: {
                if (worldSide == EnumFacing.DOWN || worldSide == EnumFacing.UP) {
                    return worldSide;
                }
                return worldSide.func_176734_d();
            }
            case SOUTH: {
                return worldSide;
            }
            case WEST: {
                if (worldSide == EnumFacing.DOWN || worldSide == EnumFacing.UP) {
                    return worldSide;
                }
                if (worldSide == EnumFacing.WEST) {
                    return EnumFacing.SOUTH;
                }
                if (worldSide == EnumFacing.NORTH) {
                    return EnumFacing.WEST;
                }
                if (worldSide == EnumFacing.EAST) {
                    return EnumFacing.NORTH;
                }
                return EnumFacing.EAST;
            }
            case EAST: {
                if (worldSide == EnumFacing.DOWN || worldSide == EnumFacing.UP) {
                    return worldSide;
                }
                if (worldSide == EnumFacing.WEST) {
                    return EnumFacing.NORTH;
                }
                if (worldSide == EnumFacing.NORTH) {
                    return EnumFacing.EAST;
                }
                if (worldSide == EnumFacing.EAST) {
                    return EnumFacing.SOUTH;
                }
                return EnumFacing.WEST;
            }
        }
        return worldSide;
    }

    public static EnumFacing blockToWorldSpace(EnumFacing blockSide, EnumFacing blockDirection) {
        switch (blockDirection) {
            case DOWN: {
                switch (blockSide) {
                    case SOUTH: {
                        return EnumFacing.DOWN;
                    }
                    case NORTH: {
                        return EnumFacing.UP;
                    }
                    case UP: {
                        return EnumFacing.NORTH;
                    }
                    case DOWN: {
                        return EnumFacing.SOUTH;
                    }
                    case EAST: {
                        return EnumFacing.WEST;
                    }
                    case WEST: {
                        return EnumFacing.EAST;
                    }
                }
                return blockSide;
            }
            case UP: {
                switch (blockSide) {
                    case NORTH: {
                        return EnumFacing.DOWN;
                    }
                    case SOUTH: {
                        return EnumFacing.UP;
                    }
                    case UP: {
                        return EnumFacing.NORTH;
                    }
                    case DOWN: {
                        return EnumFacing.SOUTH;
                    }
                    case WEST: {
                        return EnumFacing.WEST;
                    }
                    case EAST: {
                        return EnumFacing.EAST;
                    }
                }
                return blockSide;
            }
            case NORTH: {
                if (blockSide == EnumFacing.DOWN || blockSide == EnumFacing.UP) {
                    return blockSide;
                }
                return blockSide.func_176734_d();
            }
            case SOUTH: {
                return blockSide;
            }
            case WEST: {
                if (blockSide == EnumFacing.DOWN || blockSide == EnumFacing.UP) {
                    return blockSide;
                }
                if (blockSide == EnumFacing.SOUTH) {
                    return EnumFacing.WEST;
                }
                if (blockSide == EnumFacing.WEST) {
                    return EnumFacing.NORTH;
                }
                if (blockSide == EnumFacing.NORTH) {
                    return EnumFacing.EAST;
                }
                return EnumFacing.SOUTH;
            }
            case EAST: {
                if (blockSide == EnumFacing.DOWN || blockSide == EnumFacing.UP) {
                    return blockSide;
                }
                if (blockSide == EnumFacing.NORTH) {
                    return EnumFacing.WEST;
                }
                if (blockSide == EnumFacing.EAST) {
                    return EnumFacing.NORTH;
                }
                if (blockSide == EnumFacing.SOUTH) {
                    return EnumFacing.EAST;
                }
                return EnumFacing.SOUTH;
            }
        }
        return blockSide;
    }

    public static Vec3d blockToWorldSpace(Vec3d v, IBlockState state) {
        return OrientationTools.blockToWorldSpace(v, OrientationTools.getOrientation(state));
    }

    public static Vec3d worldToBlockSpace(Vec3d v, IBlockState state) {
        return OrientationTools.worldToBlockSpace(v, OrientationTools.getOrientation(state));
    }

    public static Vec3d blockToWorldSpaceHoriz(Vec3d v, IBlockState state) {
        return OrientationTools.blockToWorldSpace(v, OrientationTools.getOrientationHoriz(state));
    }

    public static Vec3d worldToBlockSpaceHoriz(Vec3d v, IBlockState state) {
        return OrientationTools.worldToBlockSpace(v, OrientationTools.getOrientationHoriz(state));
    }

    public static Vec3d blockToWorldSpace(Vec3d v, EnumFacing side) {
        switch (side) {
            case DOWN: {
                return new Vec3d(v.field_72450_a, v.field_72449_c, v.field_72448_b);
            }
            case UP: {
                return new Vec3d(v.field_72450_a, v.field_72449_c, v.field_72448_b);
            }
            case NORTH: {
                return new Vec3d(1.0 - v.field_72450_a, v.field_72448_b, 1.0 - v.field_72449_c);
            }
            case SOUTH: {
                return v;
            }
            case WEST: {
                return new Vec3d(1.0 - v.field_72449_c, v.field_72448_b, v.field_72450_a);
            }
            case EAST: {
                return new Vec3d(v.field_72449_c, v.field_72448_b, 1.0 - v.field_72450_a);
            }
        }
        return v;
    }

    public static Vec3d worldToBlockSpace(Vec3d v, EnumFacing side) {
        switch (side) {
            case DOWN: {
                return new Vec3d(v.field_72450_a, v.field_72449_c, v.field_72448_b);
            }
            case UP: {
                return new Vec3d(v.field_72450_a, v.field_72449_c, v.field_72448_b);
            }
            case NORTH: {
                return new Vec3d(1.0 - v.field_72450_a, v.field_72448_b, 1.0 - v.field_72449_c);
            }
            case SOUTH: {
                return v;
            }
            case WEST: {
                return new Vec3d(v.field_72449_c, v.field_72448_b, 1.0 - v.field_72450_a);
            }
            case EAST: {
                return new Vec3d(1.0 - v.field_72449_c, v.field_72448_b, v.field_72450_a);
            }
        }
        return v;
    }

    public static EnumFacing getTopDirection(EnumFacing rotation) {
        switch (rotation) {
            case DOWN: {
                return EnumFacing.SOUTH;
            }
            case UP: {
                return EnumFacing.NORTH;
            }
        }
        return EnumFacing.UP;
    }

    public static EnumFacing getBottomDirection(EnumFacing rotation) {
        switch (rotation) {
            case DOWN: {
                return EnumFacing.NORTH;
            }
            case UP: {
                return EnumFacing.SOUTH;
            }
        }
        return EnumFacing.DOWN;
    }

    public static EnumFacing worldToBlockSpace(EnumFacing side, IBlockState state) {
        return OrientationTools.worldToBlockSpace(side, OrientationTools.getOrientation(state));
    }

    public static EnumFacing getFacingFromEntity(BlockPos clickedBlock, EntityLivingBase entityIn) {
        if (MathHelper.func_76135_e((float)((float)entityIn.field_70165_t - (float)clickedBlock.func_177958_n())) < 2.0f && MathHelper.func_76135_e((float)((float)entityIn.field_70161_v - (float)clickedBlock.func_177952_p())) < 2.0f) {
            double d0 = entityIn.field_70163_u + (double)entityIn.func_70047_e();
            if (d0 - (double)clickedBlock.func_177956_o() > 2.0) {
                return EnumFacing.UP;
            }
            if ((double)clickedBlock.func_177956_o() - d0 > 0.0) {
                return EnumFacing.DOWN;
            }
        }
        return entityIn.func_174811_aO().func_176734_d();
    }

    public static EnumFacing reorient(EnumFacing side, IBlockState state) {
        return OrientationTools.reorient(side, OrientationTools.getOrientation(state));
    }

    public static EnumFacing reorientHoriz(EnumFacing side, IBlockState state) {
        return OrientationTools.reorient(side, OrientationTools.getOrientationHoriz(state));
    }

    public static EnumFacing reorient(EnumFacing side, EnumFacing blockDirection) {
        switch (blockDirection) {
            case DOWN: {
                switch (side) {
                    case DOWN: {
                        return EnumFacing.SOUTH;
                    }
                    case UP: {
                        return EnumFacing.NORTH;
                    }
                    case NORTH: {
                        return EnumFacing.UP;
                    }
                    case SOUTH: {
                        return EnumFacing.DOWN;
                    }
                    case WEST: {
                        return EnumFacing.EAST;
                    }
                    case EAST: {
                        return EnumFacing.WEST;
                    }
                }
                return side;
            }
            case UP: {
                switch (side) {
                    case DOWN: {
                        return EnumFacing.NORTH;
                    }
                    case UP: {
                        return EnumFacing.SOUTH;
                    }
                    case NORTH: {
                        return EnumFacing.UP;
                    }
                    case SOUTH: {
                        return EnumFacing.DOWN;
                    }
                    case WEST: {
                        return EnumFacing.WEST;
                    }
                    case EAST: {
                        return EnumFacing.EAST;
                    }
                }
                return side;
            }
            case NORTH: {
                if (side == EnumFacing.DOWN || side == EnumFacing.UP) {
                    return side;
                }
                return side.func_176734_d();
            }
            case SOUTH: {
                return side;
            }
            case WEST: {
                if (side == EnumFacing.DOWN || side == EnumFacing.UP) {
                    return side;
                }
                if (side == EnumFacing.WEST) {
                    return EnumFacing.SOUTH;
                }
                if (side == EnumFacing.NORTH) {
                    return EnumFacing.WEST;
                }
                if (side == EnumFacing.EAST) {
                    return EnumFacing.NORTH;
                }
                return EnumFacing.EAST;
            }
            case EAST: {
                if (side == EnumFacing.DOWN || side == EnumFacing.UP) {
                    return side;
                }
                if (side == EnumFacing.WEST) {
                    return EnumFacing.NORTH;
                }
                if (side == EnumFacing.NORTH) {
                    return EnumFacing.EAST;
                }
                if (side == EnumFacing.EAST) {
                    return EnumFacing.SOUTH;
                }
                return EnumFacing.WEST;
            }
        }
        return side;
    }
}

