/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.platforms;

import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import shetiphian.core.common.RegistryHelper;
import shetiphian.platforms.Platforms;
import shetiphian.platforms.Values;
import shetiphian.platforms.common.block.BlockPlatform;
import shetiphian.platforms.common.entity.EntityGuiItem;
import shetiphian.platforms.common.item.ItemBlockPlatform;
import shetiphian.platforms.common.item.ItemWrench;
import shetiphian.platforms.common.tileentity.TileEntityPlatFormer;
import shetiphian.platforms.common.tileentity.TileEntityPlatformTypes;

public class Registry {
    static Registry INSTANCE = new Registry();

    void registerBlocks(IForgeRegistry<Block> registry) {
        RegistryHelper.register(registry, (Block)new BlockPlatform(), (String)"platforms:platform", (String)"platforms.platform");
        RegistryHelper.register(TileEntityPlatformTypes.TileEntityPlatformFlat.class, (String)"platforms:platform.flat");
        RegistryHelper.register(TileEntityPlatformTypes.TileEntityPlatformRamp.class, (String)"platforms:platform.ramp");
        RegistryHelper.register(TileEntityPlatformTypes.TileEntityPlatformFloor.class, (String)"platforms:platform.floor");
        RegistryHelper.register(TileEntityPlatformTypes.TileEntityPlatformFrame.class, (String)"platforms:platform.frame");
        RegistryHelper.register(TileEntityPlatformTypes.TileEntityPlatformRise.class, (String)"platforms:platform.rise");
        RegistryHelper.register(TileEntityPlatFormer.class, (String)"platforms:platform.platformer");
    }

    void registerItemBlocks(IForgeRegistry<Item> registry) {
        RegistryHelper.register(registry, (ItemBlock)new ItemBlockPlatform(Values.blockPlatform));
    }

    void registerItems(IForgeRegistry<Item> registry) {
        RegistryHelper.register(registry, (Item)new ItemWrench(), (String)"platforms:wrench", (String)"platforms.wrench");
    }

    void doRegistration() {
        this.registerEntities();
        this.setTabIcon();
        this.registerCustomItemStacks();
    }

    private void registerEntities() {
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("platforms", "gui-item"), EntityGuiItem.class, (String)"gui-item", (int)2, (Object)Platforms.INSTANCE, (int)160, (int)Integer.MAX_VALUE, (boolean)true);
    }

    private void setTabIcon() {
        Values.tabPlatforms.setIcon(new ItemStack(Values.blockPlatform, 1, 50));
    }

    private void registerCustomItemStacks() {
        if (Values.blockPlatform != null) {
            Item item = Item.func_150898_a((Block)Values.blockPlatform);
            Values.stacks.put("platformer", this.iStack(item, 50));
            Values.stacks.put("wood_flat", this.iStack(item, 0));
            Values.stacks.put("wood_ramp", this.iStack(item, 1));
            Values.stacks.put("wood_frame", this.iStack(item, 3));
            Values.stacks.put("wood_rise", this.iStack(item, 4));
            Values.stacks.put("wood_rail", this.iStack(item, 5));
            Values.stacks.put("stone_flat", this.iStack(item, 10));
            Values.stacks.put("stone_ramp", this.iStack(item, 11));
            Values.stacks.put("stone_frame", this.iStack(item, 13));
            Values.stacks.put("stone_rise", this.iStack(item, 14));
            Values.stacks.put("stone_rail", this.iStack(item, 15));
            Values.stacks.put("metal_flat", this.iStack(item, 20));
            Values.stacks.put("metal_ramp", this.iStack(item, 21));
            Values.stacks.put("metal_frame", this.iStack(item, 23));
            Values.stacks.put("metal_rise", this.iStack(item, 24));
            Values.stacks.put("metal_rail", this.iStack(item, 25));
        }
        if (Values.itemWrench != null) {
            Values.stacks.put("wrench", this.iStack(Values.itemWrench, 0));
        }
    }

    private ItemStack iStack(Item item, int metadata) {
        return new ItemStack(item, 1, metadata);
    }
}

