/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.platforms.client.model;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemModelMesher;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelRotation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import shetiphian.platforms.Values;
import shetiphian.platforms.client.model.ModelPlatform_Composite;
import shetiphian.platforms.common.helpers.CraftHelper;

@SideOnly(value=Side.CLIENT)
public class ModelPlatform_Base
implements IModel {
    private static final List<ResourceLocation> TEXTURES = new ArrayList<ResourceLocation>();
    private static final List<ModelData> MODELS = new ArrayList<ModelData>();
    static Table<String, String, EnumMap<EnumFacing, IBakedModel>> CACHE = HashBasedTable.create();
    private static List<String> PART_ERROR = new ArrayList<String>();
    private static VertexFormat format;
    private static Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter;
    private static ItemModelMesher mesher;

    public Collection<ResourceLocation> getTextures() {
        return ImmutableList.copyOf(TEXTURES);
    }

    public Collection<ResourceLocation> getDependencies() {
        ArrayList<ResourceLocation> locations = new ArrayList<ResourceLocation>();
        for (ModelData modeldata : MODELS) {
            locations.add(modeldata.getLocation());
        }
        return ImmutableList.copyOf(locations);
    }

    public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        ModelPlatform_Base.format = format;
        ModelPlatform_Base.bakedTextureGetter = bakedTextureGetter;
        return new ModelPlatform_Composite();
    }

    public static void rebuildCache() {
        CACHE.clear();
    }

    static void buildCache(String part, String texture) {
        ModelData modeldata = null;
        for (ModelData data : MODELS) {
            if (!data.getName().equalsIgnoreCase(part)) continue;
            modeldata = data;
            break;
        }
        if (modeldata == null) {
            return;
        }
        IModel unbaked = null;
        try {
            unbaked = ModelLoaderRegistry.getModel((ResourceLocation)modeldata.getLocation());
        }
        catch (Exception ignored) {
            if (!PART_ERROR.contains(part.toLowerCase())) {
                Values.logPlatforms.error("Unable to retrieve model form the ModelLoaderRegistry, this part may not render correctly: " + part);
                PART_ERROR.add(part.toLowerCase());
            }
            return;
        }
        if (modeldata.doRetexture()) {
            CraftHelper.MaterialId material;
            CACHE.put((Object)modeldata.getName(), (Object)"default", ModelPlatform_Base.getMap(unbaked.retexture(new ImmutableMap.Builder().put((Object)"texture", (Object)modeldata.getDefaultTexture()).build()), format, bakedTextureGetter));
            if (mesher == null) {
                try {
                    mesher = Minecraft.func_71410_x().func_175599_af().func_175037_a();
                }
                catch (Exception ignored) {
                    // empty catch block
                }
            }
            if (mesher != null && (material = CraftHelper.MaterialId.getFor(texture)) != null) {
                material = CraftHelper.isMetal(material) ? CraftHelper.getOreMaterial(material) : material;
                ModelPlatform_Base.processMaterial(material, material.toString(), mesher, modeldata, unbaked);
            }
        } else {
            CACHE.put((Object)modeldata.getName(), (Object)texture, ModelPlatform_Base.getMap(unbaked.retexture(new ImmutableMap.Builder().put((Object)modeldata.texId, (Object)("platforms:blocks/" + texture)).build()), format, bakedTextureGetter));
        }
    }

    private static void processMaterial(CraftHelper.MaterialId material, String name, ItemModelMesher mesher, ModelData modeldata, IModel unbaked) {
        ItemStack stack = material.toStack();
        if (!stack.func_190926_b()) {
            if (stack.func_77952_i() == Short.MAX_VALUE) {
                return;
            }
            IBakedModel model = mesher.func_178089_a(stack);
            if (model != null) {
                String texture = model.func_177554_e().func_94215_i();
                CACHE.put((Object)modeldata.getName(), (Object)name, ModelPlatform_Base.getMap(unbaked.retexture(new ImmutableMap.Builder().put((Object)"texture", (Object)texture).put((Object)"particle", (Object)texture).build()), format, bakedTextureGetter));
            }
        }
    }

    private static EnumMap<EnumFacing, IBakedModel> getMap(IModel model, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        EnumMap<EnumFacing, IBakedModel> map = new EnumMap<EnumFacing, IBakedModel>(EnumFacing.class);
        map.put(EnumFacing.NORTH, model.bake((IModelState)ModelRotation.X0_Y0, format, bakedTextureGetter));
        map.put(EnumFacing.EAST, model.bake((IModelState)ModelRotation.X0_Y90, format, bakedTextureGetter));
        map.put(EnumFacing.SOUTH, model.bake((IModelState)ModelRotation.X0_Y180, format, bakedTextureGetter));
        map.put(EnumFacing.WEST, model.bake((IModelState)ModelRotation.X0_Y270, format, bakedTextureGetter));
        return map;
    }

    static {
        TEXTURES.add(new ResourceLocation("platforms:blocks/brazier"));
        TEXTURES.add(new ResourceLocation("platforms:blocks/redstone_off"));
        TEXTURES.add(new ResourceLocation("platforms:blocks/redstone_on"));
        TEXTURES.add(new ResourceLocation("platforms:blocks/light"));
        TEXTURES.add(new ResourceLocation("platforms:blocks/glowstone"));
        TEXTURES.add(new ResourceLocation("platforms:blocks/lamp_off"));
        TEXTURES.add(new ResourceLocation("platforms:blocks/lamp_on"));
        MODELS.add(new ModelData("flat-base-corner", true));
        MODELS.add(new ModelData("flat-base-normal", true));
        MODELS.add(new ModelData("flat-platform-corner-inside-dark_dark", false));
        MODELS.add(new ModelData("flat-platform-corner-inside-dark_light", false));
        MODELS.add(new ModelData("flat-platform-corner-inside-light_dark", false));
        MODELS.add(new ModelData("flat-platform-corner-inside-light_light", false));
        MODELS.add(new ModelData("flat-platform-corner-middle-dark_dark", false));
        MODELS.add(new ModelData("flat-platform-corner-middle-dark_light", false));
        MODELS.add(new ModelData("flat-platform-corner-middle-light_dark", false));
        MODELS.add(new ModelData("flat-platform-corner-middle-light_light", false));
        MODELS.add(new ModelData("flat-platform-corner-outside-dark_dark", false));
        MODELS.add(new ModelData("flat-platform-corner-outside-dark_light", false));
        MODELS.add(new ModelData("flat-platform-corner-outside-light_dark", false));
        MODELS.add(new ModelData("flat-platform-corner-outside-light_light", false));
        MODELS.add(new ModelData("flat-platform-normal-left", false));
        MODELS.add(new ModelData("flat-platform-normal-middle", false));
        MODELS.add(new ModelData("flat-platform-normal-right", false));
        MODELS.add(new ModelData("floor-base-corner-inside", true));
        MODELS.add(new ModelData("floor-base-corner-middle", true));
        MODELS.add(new ModelData("floor-base-corner-outside", true));
        MODELS.add(new ModelData("floor-base-normal-left", true));
        MODELS.add(new ModelData("floor-base-normal-middle", true));
        MODELS.add(new ModelData("floor-base-normal-right", true));
        MODELS.add(new ModelData("floor-platform-corner-inside-dark_dark", false));
        MODELS.add(new ModelData("floor-platform-corner-inside-dark_light", false));
        MODELS.add(new ModelData("floor-platform-corner-inside-light_dark", false));
        MODELS.add(new ModelData("floor-platform-corner-inside-light_light", false));
        MODELS.add(new ModelData("floor-platform-corner-middle-dark_dark", false));
        MODELS.add(new ModelData("floor-platform-corner-middle-dark_light", false));
        MODELS.add(new ModelData("floor-platform-corner-middle-light_dark", false));
        MODELS.add(new ModelData("floor-platform-corner-middle-light_light", false));
        MODELS.add(new ModelData("floor-platform-corner-outside-dark_dark", false));
        MODELS.add(new ModelData("floor-platform-corner-outside-dark_light", false));
        MODELS.add(new ModelData("floor-platform-corner-outside-light_dark", false));
        MODELS.add(new ModelData("floor-platform-corner-outside-light_light", false));
        MODELS.add(new ModelData("floor-platform-normal-left", false));
        MODELS.add(new ModelData("floor-platform-normal-middle", false));
        MODELS.add(new ModelData("floor-platform-normal-right", false));
        MODELS.add(new ModelData("floor-support-legs", true));
        MODELS.add(new ModelData("floor-support-post-corner-inside", true));
        MODELS.add(new ModelData("floor-support-post-corner-outside", true));
        MODELS.add(new ModelData("floor-support-post-extension", true));
        MODELS.add(new ModelData("floor-support-post-normal-left", true));
        MODELS.add(new ModelData("floor-support-post-normal-right", true));
        MODELS.add(new ModelData("frame-bar", false));
        MODELS.add(new ModelData("frame-support", true));
        MODELS.add(new ModelData("frame-brazier-base", false).setTexture("brazier", "platforms:blocks/brazier"));
        MODELS.add(new ModelData("frame-brazier-fill", false).setTexture("fill", "platforms:blocks/redstone_off"));
        MODELS.add(new ModelData("frame-brazier-fill", false).setTexture("fill", "platforms:blocks/redstone_on"));
        MODELS.add(new ModelData("frame-brazier-fill", false).setTexture("fill", "platforms:blocks/light"));
        MODELS.add(new ModelData("frame-brazier-fill", false).setTexture("fill", "platforms:blocks/glowstone"));
        MODELS.add(new ModelData("frame-brazier-fill", false).setTexture("fill", "platforms:blocks/lamp_off"));
        MODELS.add(new ModelData("frame-brazier-fill", false).setTexture("fill", "platforms:blocks/lamp_on"));
        MODELS.add(new ModelData("rail-bar-corner-inside", false));
        MODELS.add(new ModelData("rail-bar-corner-outside", false));
        MODELS.add(new ModelData("rail-bar-normal-left", false));
        MODELS.add(new ModelData("rail-bar-normal-right", false));
        MODELS.add(new ModelData("rail-support-corner-inside", true));
        MODELS.add(new ModelData("rail-support-corner-inside-extended", true));
        MODELS.add(new ModelData("rail-support-corner-outside", true));
        MODELS.add(new ModelData("rail-support-corner-outside-extended", true));
        MODELS.add(new ModelData("rail-support-normal-left", true));
        MODELS.add(new ModelData("rail-support-normal-left-extended", true));
        MODELS.add(new ModelData("rail-support-normal-right", true));
        MODELS.add(new ModelData("rail-support-normal-right-extended", true));
        MODELS.add(new ModelData("ramp-base", true));
        MODELS.add(new ModelData("ramp-platform-left", false));
        MODELS.add(new ModelData("ramp-platform-middle", false));
        MODELS.add(new ModelData("ramp-platform-right", false));
        MODELS.add(new ModelData("ramp-rail-bar-left", false));
        MODELS.add(new ModelData("ramp-rail-bar-right", false));
        MODELS.add(new ModelData("ramp-rail-support-left", true));
        MODELS.add(new ModelData("ramp-rail-support-right", true));
        MODELS.add(new ModelData("ramp-rise-bar-left", false));
        MODELS.add(new ModelData("ramp-rise-bar-right", false));
        MODELS.add(new ModelData("ramp-rise-support-left", true));
        MODELS.add(new ModelData("ramp-rise-support-right", true));
        MODELS.add(new ModelData("ramp-support-dual", true));
        MODELS.add(new ModelData("ramp-support-single", true));
        MODELS.add(new ModelData("ramp-support-beam-left-lb", true));
        MODELS.add(new ModelData("ramp-support-beam-left-sb", true));
        MODELS.add(new ModelData("ramp-support-beam-middle", true));
        MODELS.add(new ModelData("ramp-support-beam-right-lb", true));
        MODELS.add(new ModelData("ramp-support-beam-right-sb", true));
        MODELS.add(new ModelData("rise-bar-corner-inside", false));
        MODELS.add(new ModelData("rise-bar-corner-outside", false));
        MODELS.add(new ModelData("rise-bar-normal-left", false));
        MODELS.add(new ModelData("rise-bar-normal-right", false));
        MODELS.add(new ModelData("rise-support-corner-inside", true));
        MODELS.add(new ModelData("rise-support-corner-inside-extended", true));
        MODELS.add(new ModelData("rise-support-corner-outside", true));
        MODELS.add(new ModelData("rise-support-corner-outside-extended", true));
        MODELS.add(new ModelData("rise-support-normal-left", true));
        MODELS.add(new ModelData("rise-support-normal-left-extended", true));
        MODELS.add(new ModelData("rise-support-normal-right", true));
        MODELS.add(new ModelData("rise-support-normal-right-extended", true));
    }

    private static class ModelData {
        private final String name;
        private final ResourceLocation location;
        private boolean retexture = true;
        private boolean altTexture = true;
        private String texId;
        private String texFile;

        ModelData(String name, boolean useAlt) {
            this.name = name;
            this.location = new ResourceLocation("platforms:block/platform_parts/" + name);
            this.altTexture = useAlt;
        }

        ModelData setTexture(String id, String file) {
            this.retexture = false;
            this.texId = id;
            this.texFile = file;
            return this;
        }

        public String getName() {
            return this.name;
        }

        ResourceLocation getLocation() {
            return this.location;
        }

        boolean doRetexture() {
            return this.retexture;
        }

        String getDefaultTexture() {
            return !this.retexture ? "platforms:blocks/torch" : (this.altTexture ? "minecraft:blocks/planks_acacia" : "minecraft:blocks/planks_big_oak");
        }
    }
}

