/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.module.storage.locks;

import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.item.Item;
import net.minecraft.util.datafix.FixTypes;
import net.minecraft.util.datafix.IFixType;
import net.minecraft.util.datafix.IFixableData;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import pl.asie.charset.ModCharset;
import pl.asie.charset.api.storage.IBarrel;
import pl.asie.charset.lib.CharsetLib;
import pl.asie.charset.lib.capability.Capabilities;
import pl.asie.charset.lib.capability.inventory.DefaultItemInsertionHandler;
import pl.asie.charset.lib.config.CharsetLoadConfigEvent;
import pl.asie.charset.lib.config.ConfigUtils;
import pl.asie.charset.lib.loader.CharsetModule;
import pl.asie.charset.lib.loader.ModuleProfile;
import pl.asie.charset.lib.ui.GuiHandlerCharset;
import pl.asie.charset.lib.utils.RegistryUtils;
import pl.asie.charset.module.storage.locks.ContainerKeyring;
import pl.asie.charset.module.storage.locks.EntityLock;
import pl.asie.charset.module.storage.locks.FixCharsetLockKeyTagChange;
import pl.asie.charset.module.storage.locks.GuiKeyring;
import pl.asie.charset.module.storage.locks.ItemKey;
import pl.asie.charset.module.storage.locks.ItemKeyring;
import pl.asie.charset.module.storage.locks.ItemLock;
import pl.asie.charset.module.storage.locks.ItemLockingDyeable;
import pl.asie.charset.module.storage.locks.ItemMasterKey;
import pl.asie.charset.module.storage.locks.LockEventHandler;
import pl.asie.charset.module.storage.locks.LocksCapabilityHandler;
import pl.asie.charset.module.storage.locks.RenderLock;
import pl.asie.charset.module.storage.locks.wrapper.ReadOnlyBarrel;
import pl.asie.charset.module.storage.locks.wrapper.ReadOnlyFluidHandler;
import pl.asie.charset.module.storage.locks.wrapper.ReadOnlyItemHandler;
import pl.asie.charset.patchwork.LocksCapabilityHook;
import pl.asie.charset.patchwork.PatchworkHelper;

@CharsetModule(name="storage.locks", description="Player interaction-preventing locks and keys", profile=ModuleProfile.FORCED)
public class CharsetStorageLocks {
    @CharsetModule.Instance
    public static CharsetStorageLocks instance;
    @CharsetModule.Configuration
    public static Configuration config;
    public static final int DEFAULT_LOCKING_COLOR = 16505706;
    public static ItemMasterKey masterKeyItem;
    public static ItemKey keyItem;
    public static ItemKeyring keyringItem;
    public static ItemLock lockItem;
    public static boolean enableKeyKeepInventory;

    @Mod.EventHandler
    public void loadConfig(CharsetLoadConfigEvent event) {
        enableKeyKeepInventory = ConfigUtils.getBoolean((Configuration)config, (String)"general", (String)"keepKeysOnDeath", (boolean)true, (String)"Should keys be kept in inventory on death?", (boolean)true);
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        masterKeyItem = new ItemMasterKey();
        keyItem = new ItemKey();
        keyringItem = new ItemKeyring();
        lockItem = new ItemLock();
        ModCharset.dataFixes.registerFix((IFixType)FixTypes.ITEM_INSTANCE, (IFixableData)new FixCharsetLockKeyTagChange());
        if (PatchworkHelper.getBoolean((String)"LOCKS_BLOCK_CAPABILITIES")) {
            LocksCapabilityHook.handler = new LocksCapabilityHandler();
            LocksCapabilityHandler.addCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, o -> {
                if (o != null) {
                    return new ReadOnlyItemHandler((IItemHandler)o);
                }
                return null;
            }, true);
            LocksCapabilityHandler.addCapability(Capabilities.ITEM_INSERTION_HANDLER, o -> new DefaultItemInsertionHandler(), true);
            LocksCapabilityHandler.addCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, o -> {
                if (o != null) {
                    return new ReadOnlyFluidHandler((IFluidHandler)o);
                }
                return null;
            }, true);
            LocksCapabilityHandler.addCapability(Capabilities.BARREL, o -> {
                if (o != null) {
                    return new ReadOnlyBarrel((IBarrel)o);
                }
                return null;
            }, true);
            config.getCategory("blockedCapabilities").setComment("NOTE: This functionality requires a special configuration option in CharsetPatches to be turned on! Otherwise, it will not be effective!");
            if (config.hasChanged()) {
                config.save();
            }
        }
    }

    @SubscribeEvent
    public void registerModels(ModelRegistryEvent event) {
        RegistryUtils.registerModel((Item)masterKeyItem, (int)0, (String)"charset:masterKey");
        RegistryUtils.registerModel((Item)keyItem, (int)0, (String)"charset:key");
        RegistryUtils.registerModel((Item)lockItem, (int)0, (String)"charset:lock");
        RegistryUtils.registerModel((Item)keyringItem, (int)0, (String)"charset:keyring");
        for (int i = 1; i <= 8; ++i) {
            RegistryUtils.registerModel((Item)keyringItem, (int)i, (String)("charset:keyring#inventory_" + i));
        }
    }

    @SubscribeEvent
    public void registerItems(RegistryEvent.Register<Item> event) {
        RegistryUtils.register((IForgeRegistry)event.getRegistry(), (IForgeRegistryEntry)masterKeyItem, (String)"masterKey");
        RegistryUtils.register((IForgeRegistry)event.getRegistry(), (IForgeRegistryEntry)keyItem, (String)"key");
        RegistryUtils.register((IForgeRegistry)event.getRegistry(), (IForgeRegistryEntry)keyringItem, (String)"keyring");
        RegistryUtils.register((IForgeRegistry)event.getRegistry(), (IForgeRegistryEntry)lockItem, (String)"lock");
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        RegistryUtils.register(EntityLock.class, (String)"lock", (int)64, (int)3, (boolean)false);
        MinecraftForge.EVENT_BUS.register((Object)new LockEventHandler());
        if (enableKeyKeepInventory) {
            CharsetLib.deathHandler.addPredicate(input -> input != null && input.func_77973_b() instanceof ItemKey);
        }
        GuiHandlerCharset.INSTANCE.register(257, Side.SERVER, r -> new ContainerKeyring(r.player.field_71071_by));
    }

    @Mod.EventHandler
    @SideOnly(value=Side.CLIENT)
    public void preInitClient(FMLPreInitializationEvent event) {
        RenderingRegistry.registerEntityRenderingHandler(EntityLock.class, RenderLock::new);
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void registerColorItem(ColorHandlerEvent.Item event) {
        event.getItemColors().func_186730_a((IItemColor)new ItemLockingDyeable.Color(), new Item[]{keyItem});
        event.getItemColors().func_186730_a((IItemColor)new ItemLockingDyeable.Color(), new Item[]{lockItem});
        event.getItemColors().func_186730_a((IItemColor)new ItemKeyring.Color(), new Item[]{keyringItem});
    }

    @Mod.EventHandler
    @SideOnly(value=Side.CLIENT)
    public void initClient(FMLInitializationEvent event) {
        GuiHandlerCharset.INSTANCE.register(257, Side.CLIENT, r -> new GuiKeyring(r.getContainer()));
    }
}

