/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.module.storage.locks;

import com.google.gson.JsonObject;
import java.util.Random;
import java.util.UUID;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.JsonUtils;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.JsonContext;
import pl.asie.charset.lib.recipe.IOutputSupplier;
import pl.asie.charset.lib.recipe.IOutputSupplierFactory;
import pl.asie.charset.lib.recipe.IngredientMatcher;
import pl.asie.charset.lib.recipe.RecipeCharset;
import pl.asie.charset.module.storage.locks.ItemKey;

public class KeyOutputSupplier
implements IOutputSupplier {
    private static final Random rand = new Random();
    private final ItemStack output;
    private final boolean duplicate;

    private KeyOutputSupplier(ItemStack output, boolean duplicate) {
        this.output = output;
        this.duplicate = duplicate;
    }

    public ItemStack getCraftingResult(RecipeCharset recipe, IngredientMatcher matcher, InventoryCrafting inv) {
        if (this.duplicate) {
            for (Ingredient i : matcher.getMatchedIngredients()) {
                if (!i.apply(this.output)) continue;
                ItemStack key = matcher.getStack(i);
                ItemStack result = this.output.func_77946_l();
                NBTTagCompound cpd = new NBTTagCompound();
                cpd.func_74778_a("key", ((ItemKey)key.func_77973_b()).getKey(key));
                result.func_77982_d(cpd);
                return result;
            }
            return null;
        }
        ItemStack result = this.output.func_77946_l();
        NBTTagCompound cpd = new NBTTagCompound();
        cpd.func_74778_a("key", new UUID(rand.nextLong(), rand.nextLong()).toString());
        result.func_77982_d(cpd);
        return result;
    }

    public ItemStack getDefaultOutput() {
        return this.output;
    }

    public static class Factory
    implements IOutputSupplierFactory {
        public IOutputSupplier parse(JsonContext context, JsonObject json) {
            return new KeyOutputSupplier(CraftingHelper.getItemStack((JsonObject)JsonUtils.func_152754_s((JsonObject)json, (String)"item"), (JsonContext)context), JsonUtils.func_151209_a((JsonObject)json, (String)"duplicate", (boolean)false));
        }
    }
}

