/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.module.storage.locks;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityLockable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pl.asie.charset.api.lib.EntityGatherItemsEvent;
import pl.asie.charset.api.lib.IMultiblockStructure;
import pl.asie.charset.api.locks.Lockable;
import pl.asie.charset.api.storage.IKeyItem;
import pl.asie.charset.lib.CharsetIMC;
import pl.asie.charset.lib.capability.Capabilities;
import pl.asie.charset.lib.capability.CapabilityProviderFactory;
import pl.asie.charset.lib.item.FontRendererFancy;
import pl.asie.charset.lib.notify.Notice;
import pl.asie.charset.lib.notify.component.NotificationComponent;
import pl.asie.charset.lib.notify.component.NotificationComponentString;
import pl.asie.charset.lib.notify.component.NotificationComponentTextComponent;
import pl.asie.charset.lib.utils.ColorUtils;
import pl.asie.charset.lib.utils.ThreeState;
import pl.asie.charset.lib.utils.colorspace.Colorspace;
import pl.asie.charset.lib.utils.colorspace.Colorspaces;

public class LockEventHandler {
    public static CapabilityProviderFactory<Lockable> PROVIDER;
    private static final ResourceLocation LOCKABLE;

    public static Lockable getLock(TileEntity tile) {
        if (tile != null) {
            Lockable lock;
            if (tile.hasCapability(Capabilities.MULTIBLOCK_STRUCTURE, null)) {
                IMultiblockStructure structure = (IMultiblockStructure)tile.getCapability(Capabilities.MULTIBLOCK_STRUCTURE, null);
                Iterator iterator = structure.iterator();
                while (iterator.hasNext()) {
                    Lockable lock2;
                    TileEntity tile2 = tile.func_145831_w().func_175625_s((BlockPos)iterator.next());
                    if (tile2 == null || !tile2.hasCapability(Capabilities.LOCKABLE, null) || !(lock2 = (Lockable)tile2.getCapability(Capabilities.LOCKABLE, null)).hasLock() || !lock2.getLock().isLockValid(tile2) || !lock2.getLock().isLocked()) continue;
                    return lock2;
                }
            } else if (tile.hasCapability(Capabilities.LOCKABLE, null) && (lock = (Lockable)tile.getCapability(Capabilities.LOCKABLE, null)).hasLock() && lock.getLock().isLockValid(tile) && lock.getLock().isLocked()) {
                return lock;
            }
        }
        return null;
    }

    public static Collection<ItemStack> getPotentialKeys(Entity player) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        MinecraftForge.EVENT_BUS.post((Event)new EntityGatherItemsEvent(player, stacks, true, true));
        return stacks;
    }

    public static boolean unlockOrRaiseError(EntityPlayer player, TileEntity tile, Lockable lock) {
        if (player.func_130014_f_().field_72995_K) {
            return true;
        }
        boolean canUnlock = false;
        for (ItemStack stack : LockEventHandler.getPotentialKeys((Entity)player)) {
            IKeyItem key;
            if (!stack.func_190926_b() && stack.func_77973_b() instanceof IKeyItem && (canUnlock = (key = (IKeyItem)stack.func_77973_b()).canUnlock(lock.getLock().getLockKey(), stack))) break;
        }
        if (!canUnlock) {
            ITextComponent displayName = tile.func_145748_c_();
            if (displayName == null) {
                displayName = new TextComponentTranslation(tile.func_145838_q().func_149739_a() + ".name", new Object[0]);
            }
            new Notice((Object)tile, (NotificationComponent)NotificationComponentString.translated((String)"container.isLocked", (NotificationComponent[])new NotificationComponent[]{new NotificationComponentTextComponent(displayName)})).sendTo(player);
            player.func_130014_f_().func_184133_a(player, tile.func_174877_v(), SoundEvents.field_187654_U, SoundCategory.BLOCKS, 1.0f, 1.0f);
        }
        return canUnlock;
    }

    @SubscribeEvent
    public void onAttachCapabilities(AttachCapabilitiesEvent<TileEntity> event) {
        boolean hasCap;
        TileEntity tile = (TileEntity)event.getObject();
        ResourceLocation location = TileEntity.func_190559_a(tile.getClass());
        if (location == null) {
            return;
        }
        ThreeState state = CharsetIMC.INSTANCE.allows("lock", location);
        boolean bl = hasCap = state == ThreeState.YES;
        if (state == ThreeState.MAYBE && tile instanceof TileEntityLockable) {
            hasCap = true;
        }
        if (hasCap) {
            if (PROVIDER == null) {
                PROVIDER = new CapabilityProviderFactory(Capabilities.LOCKABLE, Capabilities.LOCKABLE_STORAGE);
            }
            event.addCapability(LOCKABLE, PROVIDER.create((Object)new Lockable(tile)));
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onLeftClick(PlayerInteractEvent.LeftClickBlock event) {
        TileEntity tile = event.getWorld().func_175625_s(event.getPos());
        Lockable lockable = LockEventHandler.getLock(tile);
        if (lockable != null && !LockEventHandler.unlockOrRaiseError(event.getEntityPlayer(), tile, lockable)) {
            event.setUseBlock(Event.Result.DENY);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onRightClick(PlayerInteractEvent.RightClickBlock event) {
        TileEntity tile = event.getWorld().func_175625_s(event.getPos());
        Lockable lockable = LockEventHandler.getLock(tile);
        if (lockable != null && !LockEventHandler.unlockOrRaiseError(event.getEntityPlayer(), tile, lockable)) {
            event.setUseBlock(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public void onBlockBreak(BlockEvent.BreakEvent event) {
        TileEntity tile;
        Lockable lockable;
        IBlockState state = event.getState();
        if (state.func_177230_c().hasTileEntity(state) && (lockable = LockEventHandler.getLock(tile = event.getWorld().func_175625_s(event.getPos()))) != null && !LockEventHandler.unlockOrRaiseError(event.getPlayer(), tile, lockable)) {
            event.setCanceled(true);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static String getColorDyed(int color) {
        color &= 0xFFFFFF;
        double maxDistance = Double.MAX_VALUE;
        EnumDyeColor closestColor = null;
        for (EnumDyeColor dyeColor : EnumDyeColor.values()) {
            int c = ColorUtils.toIntColor((EnumDyeColor)dyeColor) & 0xFFFFFF;
            if (color == c) {
                closestColor = dyeColor;
                break;
            }
            double d = Colorspaces.getColorDistance((int)c, (int)color, (Colorspace)Colorspace.LAB);
            if (!(d < maxDistance)) continue;
            maxDistance = d;
            closestColor = dyeColor;
        }
        return FontRendererFancy.getColorFormat((int)color) + (closestColor != null ? I18n.func_135052_a((String)ColorUtils.getLangEntry((String)"charset.color.", closestColor), (Object[])new Object[0]) : "???") + FontRendererFancy.getColorResetFormat();
    }

    static {
        LOCKABLE = new ResourceLocation("charset:lockable");
    }
}

