/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.module.storage.locks;

import java.util.IdentityHashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.config.Configuration;
import pl.asie.charset.api.locks.Lockable;
import pl.asie.charset.lib.capability.Capabilities;
import pl.asie.charset.lib.config.ConfigUtils;
import pl.asie.charset.module.storage.locks.CharsetStorageLocks;
import pl.asie.charset.module.storage.locks.LockEventHandler;
import pl.asie.charset.patchwork.LocksCapabilityHook;

public class LocksCapabilityHandler
implements LocksCapabilityHook.Handler {
    private static final Map<Capability, Function<Object, Object>> FORBIDDEN = new IdentityHashMap<Capability, Function<Object, Object>>();

    public static void addCapability(Capability capability, Function<Object, Object> transformer, boolean def) {
        if (ConfigUtils.getBoolean((Configuration)CharsetStorageLocks.config, (String)"blockedCapabilities", (String)capability.getName(), (boolean)def, null, (boolean)true)) {
            FORBIDDEN.put(capability, transformer);
        }
    }

    public LocksCapabilityHook.Result wrapCapability(TileEntity tile, Capability capability, EnumFacing facing) {
        if (capability == Capabilities.LOCKABLE || capability == Capabilities.MULTIBLOCK_STRUCTURE) {
            return LocksCapabilityHook.NO;
        }
        if (tile.hasCapability(Capabilities.LOCKABLE, facing)) {
            Lockable lockable = LockEventHandler.getLock(tile);
            if (lockable != null && lockable.hasLock()) {
                return new LocksCapabilityHook.Result(true, FORBIDDEN.get(capability));
            }
            return LocksCapabilityHook.NO;
        }
        return LocksCapabilityHook.NO;
    }
}

