/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.models;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.ComparableItemStack;
import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.shader.CapabilityShader;
import blusunrize.immersiveengineering.api.shader.IShaderItem;
import blusunrize.immersiveengineering.api.shader.ShaderCase;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.client.models.IOBJModelCallback;
import blusunrize.immersiveengineering.client.models.smart.ConnModelReal;
import blusunrize.immersiveengineering.common.util.chickenbones.Matrix4;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.vecmath.Matrix4f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.obj.OBJModel;
import net.minecraftforge.client.model.pipeline.IVertexConsumer;
import net.minecraftforge.client.model.pipeline.LightUtil;
import net.minecraftforge.client.model.pipeline.UnpackedBakedQuad;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.Properties;
import org.apache.commons.lang3.tuple.Pair;

public class IESmartObjModel
extends OBJModel.OBJBakedModel {
    public static Cache<ComparableItemStack, IBakedModel> cachedBakedItemModels = CacheBuilder.newBuilder().maximumSize(100L).expireAfterAccess(60L, TimeUnit.SECONDS).build();
    public static HashMap<ConnModelReal.ExtBlockstateAdapter, List<BakedQuad>> modelCache = new HashMap();
    IBakedModel baseModel;
    HashMap<ItemCameraTransforms.TransformType, Matrix4> transformationMap;
    ImmutableList<BakedQuad> bakedQuads;
    ItemStack tempStack;
    IBlockState tempState;
    public EntityLivingBase tempEntity;
    public static EntityLivingBase tempEntityStatic;
    VertexFormat format;
    Map<String, String> texReplace;
    public ItemCameraTransforms.TransformType lastCameraTransform;
    boolean isDynamic;
    ItemOverrideList overrideList;
    static Field f_textures;

    public IESmartObjModel(IBakedModel baseModel, OBJModel model, IModelState state, VertexFormat format, ImmutableMap<String, TextureAtlasSprite> textures, HashMap<ItemCameraTransforms.TransformType, Matrix4> transformationMap, boolean isDynamic) {
        OBJModel oBJModel = model;
        oBJModel.getClass();
        super(oBJModel, model, state, format, textures);
        this.transformationMap = new HashMap();
        this.tempStack = ItemStack.field_190927_a;
        this.texReplace = null;
        this.lastCameraTransform = ItemCameraTransforms.TransformType.FIXED;
        this.overrideList = new ItemOverrideList(new ArrayList()){

            public IBakedModel handleItemState(IBakedModel originalModel, ItemStack stack, World world, EntityLivingBase entity) {
                tempEntityStatic = entity;
                ComparableItemStack comp = ApiUtils.createComparableItemStack(stack, false, true);
                if (comp == null) {
                    return originalModel;
                }
                Object model = (IBakedModel)cachedBakedItemModels.getIfPresent((Object)comp);
                if (model == null) {
                    if (originalModel instanceof IESmartObjModel) {
                        IESmartObjModel newModel = (IESmartObjModel)originalModel;
                        ImmutableMap.Builder builder = ImmutableMap.builder();
                        builder.put((Object)ModelLoader.White.LOCATION.toString(), (Object)ModelLoader.White.INSTANCE);
                        TextureAtlasSprite missing = Minecraft.func_71410_x().func_147117_R().func_110572_b(new ResourceLocation("missingno").toString());
                        for (String s : newModel.getModel().getMatLib().getMaterialNames()) {
                            ShaderCase sCase;
                            CapabilityShader.ShaderWrapper wrapper;
                            ItemStack shader;
                            TextureAtlasSprite sprite = null;
                            if (stack.hasCapability(CapabilityShader.SHADER_CAPABILITY, null) && !(shader = (wrapper = (CapabilityShader.ShaderWrapper)stack.getCapability(CapabilityShader.SHADER_CAPABILITY, null)).getShaderItem()).func_190926_b() && shader.func_77973_b() instanceof IShaderItem && (sCase = ((IShaderItem)shader.func_77973_b()).getShaderCase(shader, stack, wrapper.getShaderType())) != null) {
                                ResourceLocation rl = sCase.getReplacementSprite(shader, stack, s, 0);
                                sprite = ClientUtils.getSprite(rl);
                            }
                            if (sprite == null && stack.func_77973_b() instanceof IOBJModelCallback) {
                                sprite = ((IOBJModelCallback)stack.func_77973_b()).getTextureReplacement(stack, s);
                            }
                            if (sprite == null) {
                                sprite = Minecraft.func_71410_x().func_147117_R().func_110572_b(newModel.getModel().getMatLib().getMaterial(s).getTexture().getTextureLocation().toString());
                            }
                            if (sprite == null) {
                                sprite = missing;
                            }
                            builder.put((Object)s, (Object)sprite);
                        }
                        builder.put((Object)"missingno", (Object)missing);
                        IESmartObjModel bakedModel = new IESmartObjModel(newModel.baseModel, newModel.getModel(), newModel.getState(), newModel.getFormat(), (ImmutableMap<String, TextureAtlasSprite>)builder.build(), IESmartObjModel.this.transformationMap, IESmartObjModel.this.isDynamic);
                        bakedModel.tempStack = stack;
                        bakedModel.tempEntity = entity;
                        model = bakedModel;
                    } else {
                        model = originalModel;
                    }
                    comp.copy();
                    cachedBakedItemModels.put((Object)comp, model);
                }
                if (model instanceof IESmartObjModel) {
                    ((IESmartObjModel)((Object)model)).tempStack = stack;
                    ((IESmartObjModel)((Object)model)).tempEntity = entity;
                }
                return model;
            }
        };
        this.baseModel = baseModel;
        this.transformationMap = transformationMap;
        this.format = format;
        this.isDynamic = isDynamic;
    }

    public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType) {
        Matrix4 matrix;
        this.lastCameraTransform = cameraTransformType;
        if (this.transformationMap == null || this.transformationMap.isEmpty()) {
            return super.handlePerspective(cameraTransformType);
        }
        Matrix4 matrix4 = matrix = this.transformationMap.containsKey(cameraTransformType) ? this.transformationMap.get(cameraTransformType).copy() : new Matrix4();
        if (!this.tempStack.func_190926_b() && this.tempStack.func_77973_b() instanceof IOBJModelCallback) {
            matrix = ((IOBJModelCallback)this.tempStack.func_77973_b()).handlePerspective(this.tempStack, cameraTransformType, matrix, this.tempEntity);
        }
        return Pair.of((Object)((Object)this), (Object)matrix.toMatrix4f());
    }

    VertexFormat getFormat() {
        return this.format;
    }

    public boolean func_188618_c() {
        return this.isDynamic;
    }

    public ItemOverrideList func_188617_f() {
        return this.overrideList;
    }

    public List<BakedQuad> func_188616_a(IBlockState blockState, EnumFacing side, long rand) {
        OBJModel.OBJState objState = null;
        Map tex = null;
        if (blockState instanceof IExtendedBlockState) {
            IModelState modState;
            IExtendedBlockState ext = (IExtendedBlockState)blockState;
            if (ext.getUnlistedNames().contains(Properties.AnimationProperty) && (modState = (IModelState)ext.getValue(Properties.AnimationProperty)) instanceof OBJModel.OBJState) {
                objState = (OBJModel.OBJState)modState;
            }
            if (ext.getUnlistedNames().contains(IEProperties.OBJ_TEXTURE_REMAP)) {
                tex = (Map)ext.getValue(IEProperties.OBJ_TEXTURE_REMAP);
            }
        }
        return this.getQuads(blockState, side, rand, objState, tex, false);
    }

    public List<BakedQuad> getQuads(IBlockState blockState, EnumFacing side, long rand, OBJModel.OBJState objstate, Map<String, String> tex, boolean addAnimationAndTex) {
        this.texReplace = tex;
        this.tempState = blockState;
        if (blockState instanceof IExtendedBlockState) {
            ConnModelReal.ExtBlockstateAdapter adapter;
            List<BakedQuad> quads;
            IExtendedBlockState exState = (IExtendedBlockState)blockState;
            if (objstate != null) {
                if (objstate.parent == null || objstate.parent == TRSRTransformation.identity()) {
                    objstate.parent = this.getState();
                }
                if (objstate.getVisibilityMap().containsKey("OBJModel.Group.All.Key") || objstate.getVisibilityMap().containsKey("OBJModel.Group.All.Except.Key")) {
                    this.updateStateVisibilityMap(objstate);
                }
            }
            if ((quads = modelCache.get(adapter = addAnimationAndTex ? new ConnModelReal.ExtBlockstateAdapter(exState, MinecraftForgeClient.getRenderLayer(), ConnModelReal.ExtBlockstateAdapter.CONNS_OBJ_CALLBACK, new Object[]{objstate, tex}) : new ConnModelReal.ExtBlockstateAdapter(exState, MinecraftForgeClient.getRenderLayer(), ConnModelReal.ExtBlockstateAdapter.CONNS_OBJ_CALLBACK))) == null) {
                IESmartObjModel model = null;
                if (objstate != null) {
                    model = new IESmartObjModel(this.baseModel, this.getModel(), (IModelState)objstate, this.getFormat(), this.getTextures(), this.transformationMap, this.isDynamic);
                }
                if (model == null) {
                    model = new IESmartObjModel(this.baseModel, this.getModel(), this.getState(), this.getFormat(), this.getTextures(), this.transformationMap, this.isDynamic);
                }
                model.tempState = blockState;
                model.texReplace = tex;
                quads = super.buildQuads();
                modelCache.put(adapter, quads);
            }
            return Collections.synchronizedList(Lists.newArrayList(quads));
        }
        if (this.bakedQuads == null) {
            this.bakedQuads = this.buildQuads();
        }
        ArrayList quadList = Lists.newArrayList(this.bakedQuads);
        return Collections.synchronizedList(quadList);
    }

    private ImmutableList<BakedQuad> buildQuads() {
        CapabilityShader.ShaderWrapper wrapper;
        List<Object> quads = Lists.newArrayList();
        ItemStack shader = ItemStack.field_190927_a;
        ShaderCase sCase = null;
        IOBJModelCallback callback = null;
        ItemStack callbackObject = null;
        if (!this.tempStack.func_190926_b() && this.tempStack.hasCapability(CapabilityShader.SHADER_CAPABILITY, null)) {
            wrapper = (CapabilityShader.ShaderWrapper)this.tempStack.getCapability(CapabilityShader.SHADER_CAPABILITY, null);
            if (wrapper != null && !(shader = wrapper.getShaderItem()).func_190926_b() && shader.func_77973_b() instanceof IShaderItem) {
                sCase = ((IShaderItem)shader.func_77973_b()).getShaderCase(shader, this.tempStack, wrapper.getShaderType());
            }
        } else if (this.tempState != null && this.tempState instanceof IExtendedBlockState && ((IExtendedBlockState)this.tempState).getUnlistedNames().contains(CapabilityShader.BLOCKSTATE_PROPERTY) && (wrapper = (CapabilityShader.ShaderWrapper)((IExtendedBlockState)this.tempState).getValue(CapabilityShader.BLOCKSTATE_PROPERTY)) != null && !(shader = wrapper.getShaderItem()).func_190926_b() && shader.func_77973_b() instanceof IShaderItem) {
            sCase = ((IShaderItem)shader.func_77973_b()).getShaderCase(shader, null, wrapper.getShaderType());
        }
        if (!this.tempStack.func_190926_b() && this.tempStack.func_77973_b() instanceof IOBJModelCallback) {
            callback = (IOBJModelCallback)this.tempStack.func_77973_b();
            callbackObject = this.tempStack;
        } else if (this.tempState != null && this.tempState instanceof IExtendedBlockState && ((IExtendedBlockState)this.tempState).getUnlistedNames().contains(IOBJModelCallback.PROPERTY)) {
            callback = (IOBJModelCallback)((IExtendedBlockState)this.tempState).getValue(IOBJModelCallback.PROPERTY);
            callbackObject = this.tempState;
        }
        for (String groupName : this.getModel().getMatLib().getGroups().keySet()) {
            this.addQuadsForGroup(callback, callbackObject, groupName, sCase, shader, quads);
        }
        if (callback != null) {
            quads = callback.modifyQuads(callbackObject, quads);
        }
        return ImmutableList.copyOf((Collection)quads);
    }

    public <T> void addQuadsForGroup(IOBJModelCallback<T> callback, T callbackObject, String groupName, ShaderCase sCase, ItemStack shader, List<BakedQuad> quads) {
        int maxPasses = 1;
        if (sCase != null) {
            maxPasses = sCase.getLayers().length;
        }
        for (int pass = 0; pass < maxPasses; ++pass) {
            ShaderCase.ShaderLayer shaderLayer;
            ShaderCase.ShaderLayer shaderLayer2 = shaderLayer = sCase != null ? sCase.getLayers()[pass] : null;
            if (callback != null && !callback.shouldRenderGroup(callbackObject, groupName) || sCase != null && !sCase.renderModelPartForPass(shader, this.tempStack, groupName, pass)) continue;
            OBJModel.Group g = (OBJModel.Group)this.getModel().getMatLib().getGroups().get(groupName);
            Set<OBJModel.Face> faces = Collections.synchronizedSet(new LinkedHashSet());
            Optional<TRSRTransformation> transform = Optional.empty();
            if (this.getState() instanceof OBJModel.OBJState) {
                OBJModel.OBJState state = (OBJModel.OBJState)this.getState();
                if (state.parent != null) {
                    transform = state.parent.apply(Optional.empty());
                }
                if (callback != null) {
                    transform = callback.applyTransformations(callbackObject, groupName, transform);
                }
                if (state.getGroupsWithVisibility(true).contains(groupName)) {
                    faces.addAll(g.applyTransform(transform));
                }
            } else {
                transform = this.getState().apply(Optional.empty());
                if (callback != null) {
                    transform = callback.applyTransformations(callbackObject, groupName, transform);
                }
                faces.addAll(g.applyTransform((Optional)transform));
            }
            int argb = -1;
            if (sCase != null) {
                argb = sCase.getARGBColourModifier(shader, this.tempStack, groupName, pass);
            } else if (callback != null) {
                argb = callback.getRenderColour(callbackObject, groupName);
            }
            boolean dynQuad = false;
            float[] colour = new float[]{(float)(argb >> 16 & 0xFF) / 255.0f, (float)(argb >> 8 & 0xFF) / 255.0f, (float)(argb & 0xFF) / 255.0f, (float)(argb >> 24 & 0xFF) / 255.0f};
            for (OBJModel.Face f : faces) {
                int i;
                TextureAtlasSprite tempSprite = null;
                if (this.getModel().getMatLib().getMaterial(f.getMaterialName()).isWhite() && !"null".equals(f.getMaterialName())) {
                    for (OBJModel.Vertex v : f.getVertices()) {
                        if (v.getMaterial().equals(this.getModel().getMatLib().getMaterial(v.getMaterial().getName()))) continue;
                        v.setMaterial(this.getModel().getMatLib().getMaterial(v.getMaterial().getName()));
                    }
                    tempSprite = ModelLoader.White.INSTANCE;
                } else {
                    String s;
                    ResourceLocation rl;
                    if (sCase != null && (rl = sCase.getReplacementSprite(shader, this.tempStack, groupName, pass)) != null) {
                        tempSprite = ClientUtils.getSprite(rl);
                    }
                    if (tempSprite == null && callback != null) {
                        tempSprite = callback.getTextureReplacement(callbackObject, f.getMaterialName());
                    }
                    if (tempSprite == null && this.tempState != null && this.texReplace != null && (s = this.texReplace.get(groupName)) != null) {
                        tempSprite = Minecraft.func_71410_x().func_147117_R().func_110572_b(s);
                    }
                    if (tempSprite == null && !"null".equals(f.getMaterialName())) {
                        tempSprite = Minecraft.func_71410_x().func_147117_R().func_110572_b(this.getModel().getMatLib().getMaterial(f.getMaterialName()).getTexture().getTextureLocation().toString());
                    }
                }
                if (tempSprite == null) {
                    tempSprite = Minecraft.func_71410_x().func_147117_R().func_174944_f();
                }
                if (tempSprite == null) continue;
                UnpackedBakedQuad.Builder builder = new UnpackedBakedQuad.Builder(this.getFormat());
                builder.setQuadOrientation(EnumFacing.func_176737_a((float)f.getNormal().x, (float)f.getNormal().y, (float)f.getNormal().z));
                builder.setTexture(tempSprite);
                builder.setQuadTint(pass);
                OBJModel.Normal faceNormal = f.getNormal();
                OBJModel.TextureCoordinate[] uvs = new OBJModel.TextureCoordinate[4];
                boolean renderFace = true;
                for (i = 0; i < 4; ++i) {
                    double[] cutBounds;
                    OBJModel.Vertex vertex = f.getVertices()[i];
                    OBJModel.TextureCoordinate textureCoordinate = uvs[i] = vertex.hasTextureCoordinate() ? new OBJModel.TextureCoordinate(vertex.getTextureCoordinate().u, 1.0f - vertex.getTextureCoordinate().v, vertex.getTextureCoordinate().w) : OBJModel.TextureCoordinate.getDefaultUVs()[i];
                    if (shaderLayer == null) continue;
                    double[] texBounds = shaderLayer.getTextureBounds();
                    if (texBounds != null) {
                        if (texBounds[0] > (double)uvs[i].u || (double)uvs[i].u > texBounds[2] || texBounds[1] > (double)uvs[i].v || (double)uvs[i].v > texBounds[3]) {
                            renderFace = false;
                            break;
                        }
                        double dU = texBounds[2] - texBounds[0];
                        double dV = texBounds[3] - texBounds[1];
                        uvs[i].u = (float)(((double)uvs[i].u - texBounds[0]) / dU);
                        uvs[i].v = (float)(((double)uvs[i].v - texBounds[1]) / dV);
                    }
                    if ((cutBounds = shaderLayer.getCutoutBounds()) == null) continue;
                    double dU = cutBounds[2] - cutBounds[0];
                    double dV = cutBounds[3] - cutBounds[1];
                    uvs[i].u = (float)(cutBounds[0] + dU * (double)uvs[i].u);
                    uvs[i].v = (float)(cutBounds[1] + dV * (double)uvs[i].v);
                }
                if (!renderFace) continue;
                for (i = 0; i < 4; ++i) {
                    this.putVertexData((IVertexConsumer)builder, f.getVertices()[i], faceNormal, uvs[i], tempSprite, colour);
                }
                if (!(builder instanceof UnpackedBakedQuad.Builder)) continue;
                quads.add((BakedQuad)builder.build());
            }
        }
    }

    protected final void putVertexData(IVertexConsumer builder, OBJModel.Vertex v, OBJModel.Normal faceNormal, OBJModel.TextureCoordinate texCoord, TextureAtlasSprite sprite, float[] colour) {
        block6: for (int e = 0; e < this.getFormat().func_177345_h(); ++e) {
            switch (this.getFormat().func_177348_c(e).func_177375_c()) {
                case POSITION: {
                    builder.put(e, new float[]{v.getPos().x, v.getPos().y, v.getPos().z, v.getPos().w});
                    continue block6;
                }
                case COLOR: {
                    float d = v.hasNormal() ? LightUtil.diffuseLight((float)v.getNormal().x, (float)v.getNormal().y, (float)v.getNormal().z) : LightUtil.diffuseLight((float)faceNormal.x, (float)faceNormal.y, (float)faceNormal.z);
                    if (v.getMaterial() != null) {
                        builder.put(e, new float[]{d * v.getMaterial().getColor().x * colour[0], d * v.getMaterial().getColor().y * colour[1], d * v.getMaterial().getColor().z * colour[2], v.getMaterial().getColor().w * colour[3]});
                        continue block6;
                    }
                    builder.put(e, new float[]{d * colour[0], d * colour[1], d * colour[2], 1.0f * colour[3]});
                    continue block6;
                }
                case UV: {
                    if (sprite == null) {
                        sprite = Minecraft.func_71410_x().func_147117_R().func_174944_f();
                    }
                    builder.put(e, new float[]{sprite.func_94214_a((double)(texCoord.u * 16.0f)), sprite.func_94207_b((double)(texCoord.v * 16.0f)), 0.0f, 1.0f});
                    continue block6;
                }
                case NORMAL: {
                    if (!v.hasNormal()) {
                        builder.put(e, new float[]{faceNormal.x, faceNormal.y, faceNormal.z, 0.0f});
                        continue block6;
                    }
                    builder.put(e, new float[]{v.getNormal().x, v.getNormal().y, v.getNormal().z, 0.0f});
                    continue block6;
                }
                default: {
                    builder.put(e, new float[0]);
                }
            }
        }
    }

    static int getExtendedStateHash(IExtendedBlockState state) {
        return state.hashCode() * 31 + state.getUnlistedProperties().hashCode();
    }

    protected void updateStateVisibilityMap(OBJModel.OBJState state) {
        if (state.getVisibilityMap().containsKey("OBJModel.Group.All.Key")) {
            boolean operation = (Boolean)state.getVisibilityMap().get("OBJModel.Group.All.Key");
            state.getVisibilityMap().clear();
            for (String s : this.getModel().getMatLib().getGroups().keySet()) {
                state.getVisibilityMap().put(s, OBJModel.OBJState.Operation.SET_TRUE.performOperation(operation));
            }
        } else if (state.getVisibilityMap().containsKey("OBJModel.Group.All.Except.Key")) {
            List exceptList = state.getGroupNamesFromMap().subList(1, state.getGroupNamesFromMap().size());
            state.getVisibilityMap().remove("OBJModel.Group.All.Except.Key");
            for (String s : this.getModel().getMatLib().getGroups().keySet()) {
                if (exceptList.contains(s)) continue;
                state.getVisibilityMap().put(s, OBJModel.OBJState.Operation.SET_TRUE.performOperation(((Boolean)state.getVisibilityMap().get(s)).booleanValue()));
            }
        } else {
            for (String s : state.getVisibilityMap().keySet()) {
                state.getVisibilityMap().put(s, OBJModel.OBJState.Operation.SET_TRUE.performOperation(((Boolean)state.getVisibilityMap().get(s)).booleanValue()));
            }
        }
    }

    public static ImmutableMap<String, TextureAtlasSprite> getTexturesForOBJModel(IBakedModel model) {
        try {
            if (f_textures == null) {
                f_textures = OBJModel.OBJBakedModel.class.getDeclaredField("textures");
                f_textures.setAccessible(true);
            }
            return (ImmutableMap)f_textures.get(model);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public ImmutableMap<String, TextureAtlasSprite> getTextures() {
        try {
            if (f_textures == null) {
                f_textures = OBJModel.OBJBakedModel.class.getDeclaredField("textures");
                f_textures.setAccessible(true);
            }
            return (ImmutableMap)f_textures.get((Object)this);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

