/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks;

import blusunrize.immersiveengineering.api.DimensionBlockPos;
import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.energy.wires.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.energy.wires.ImmersiveNetHandler;
import blusunrize.immersiveengineering.api.energy.wires.TileEntityImmersiveConnectable;
import blusunrize.immersiveengineering.api.shader.CapabilityShader;
import blusunrize.immersiveengineering.client.models.IOBJModelCallback;
import blusunrize.immersiveengineering.common.CommonProxy;
import blusunrize.immersiveengineering.common.blocks.BlockIEBase;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.ItemBlockIEBase;
import blusunrize.immersiveengineering.common.blocks.TileEntityIEBase;
import blusunrize.immersiveengineering.common.blocks.TileEntityMultiblockPart;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.inventory.IEInventoryHandler;
import blusunrize.immersiveengineering.common.util.inventory.IIEInventory;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.obj.OBJModel;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.common.property.Properties;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

@Mod.EventBusSubscriber
public abstract class BlockIETileProvider<E extends Enum<E>>
extends BlockIEBase<E>
implements IEBlockInterfaces.IColouredBlock {
    private boolean hasColours = false;
    private static final Map<DimensionBlockPos, TileEntity> tempTile = new HashMap<DimensionBlockPos, TileEntity>();

    public BlockIETileProvider(String name, Material material, PropertyEnum<E> mainProperty, Class<? extends ItemBlockIEBase> itemBlock, Object ... additionalProperties) {
        super(name, material, mainProperty, itemBlock, additionalProperties);
    }

    @SubscribeEvent
    public static void onTick(TickEvent.ServerTickEvent ev) {
        if (ev.phase == TickEvent.Phase.END) {
            tempTile.clear();
        }
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        TileEntity basic = this.createBasicTE(world, (Enum)((Object)state.func_177229_b((IProperty)this.property)));
        Collection keys = state.func_177227_a();
        if (basic instanceof IEBlockInterfaces.IDirectionalTile) {
            EnumFacing newFacing = null;
            if (keys.contains(IEProperties.FACING_HORIZONTAL)) {
                newFacing = (EnumFacing)state.func_177229_b((IProperty)IEProperties.FACING_HORIZONTAL);
            } else if (keys.contains(IEProperties.FACING_ALL)) {
                newFacing = (EnumFacing)state.func_177229_b((IProperty)IEProperties.FACING_ALL);
            }
            int type = ((IEBlockInterfaces.IDirectionalTile)basic).getFacingLimitation();
            if (newFacing != null) {
                switch (type) {
                    case 2: 
                    case 4: 
                    case 5: 
                    case 6: {
                        if (newFacing.func_176740_k() != EnumFacing.Axis.Y) break;
                        newFacing = null;
                        break;
                    }
                    case 3: {
                        if (newFacing.func_176740_k() == EnumFacing.Axis.Y) break;
                        newFacing = null;
                    }
                }
                if (newFacing != null) {
                    ((IEBlockInterfaces.IDirectionalTile)basic).setFacing(newFacing);
                }
            }
        }
        if (basic instanceof IEBlockInterfaces.IAttachedIntegerProperies) {
            String[] names;
            IEBlockInterfaces.IAttachedIntegerProperies tileIntProps = (IEBlockInterfaces.IAttachedIntegerProperies)basic;
            for (String propertyName : names = ((IEBlockInterfaces.IAttachedIntegerProperies)basic).getIntPropertyNames()) {
                PropertyInteger property = tileIntProps.getIntProperty(propertyName);
                if (!keys.contains(property)) continue;
                tileIntProps.setValue(propertyName, (Integer)state.func_177229_b((IProperty)property));
            }
        }
        return basic;
    }

    @Override
    protected IBlockState getInitDefaultState() {
        IBlockState ret = super.getInitDefaultState();
        if (ret.func_177227_a().contains(IEProperties.FACING_ALL)) {
            ret = ret.func_177226_a((IProperty)IEProperties.FACING_ALL, (Comparable)this.getDefaultFacing());
        } else if (ret.func_177227_a().contains(IEProperties.FACING_HORIZONTAL)) {
            ret = ret.func_177226_a((IProperty)IEProperties.FACING_HORIZONTAL, (Comparable)this.getDefaultFacing());
        }
        return ret;
    }

    @Nullable
    public abstract TileEntity createBasicTE(World var1, E var2);

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        TileEntity tile = world.func_175625_s(pos);
        DimensionBlockPos dpos = new DimensionBlockPos(pos, world instanceof World ? ((World)world).field_73011_w.getDimension() : 0);
        if (tile == null && tempTile.containsKey((Object)dpos)) {
            tile = tempTile.get((Object)dpos);
        }
        if (!(tile == null || tile instanceof IEBlockInterfaces.ITileDrop && ((IEBlockInterfaces.ITileDrop)tile).preventInventoryDrop())) {
            IItemHandler h;
            if (tile instanceof IIEInventory && ((IIEInventory)tile).getDroppedItems() != null) {
                for (ItemStack s : ((IIEInventory)tile).getDroppedItems()) {
                    if (s.func_190926_b()) continue;
                    drops.add((Object)s);
                }
            } else if (tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null) && (h = (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) instanceof IEInventoryHandler) {
                for (int i = 0; i < h.getSlots(); ++i) {
                    if (h.getStackInSlot(i).func_190926_b()) continue;
                    drops.add((Object)h.getStackInSlot(i));
                    ((IEInventoryHandler)h).setStackInSlot(i, ItemStack.field_190927_a);
                }
            }
        }
        if (tile instanceof IEBlockInterfaces.ITileDrop) {
            NonNullList<ItemStack> s = ((IEBlockInterfaces.ITileDrop)tile).getTileDrops((EntityPlayer)this.harvesters.get(), state);
            drops.addAll(s);
        } else {
            super.getDrops(drops, world, pos, state, fortune);
        }
        tempTile.remove((Object)dpos);
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof IEBlockInterfaces.IHasDummyBlocks) {
            ((IEBlockInterfaces.IHasDummyBlocks)tile).breakDummies(pos, state);
        }
        if (!(!(tile instanceof IImmersiveConnectable) || world.field_72995_K && Minecraft.func_71410_x().func_71356_B())) {
            ImmersiveNetHandler.INSTANCE.clearAllConnectionsFor(Utils.toCC(tile), world, !world.field_72995_K && world.func_82736_K().func_82766_b("doTileDrops"));
        }
        tempTile.put(new DimensionBlockPos(pos, world.field_73011_w.getDimension()), tile);
        super.func_180663_b(world, pos, state);
        world.func_175713_t(pos);
    }

    public void func_180657_a(World world, EntityPlayer player, BlockPos pos, IBlockState state, TileEntity tile, ItemStack stack) {
        Collection<ItemStack> stacks;
        if (tile instanceof IEBlockInterfaces.IAdditionalDrops && (stacks = ((IEBlockInterfaces.IAdditionalDrops)tile).getExtraDrops(player, state)) != null && !stacks.isEmpty()) {
            for (ItemStack s : stacks) {
                if (s.func_190926_b()) continue;
                BlockIETileProvider.func_180635_a((World)world, (BlockPos)pos, (ItemStack)s);
            }
        }
        super.func_180657_a(world, player, pos, state, tile, stack);
    }

    public boolean canEntityDestroy(IBlockState state, IBlockAccess world, BlockPos pos, Entity entity) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof IEBlockInterfaces.IEntityProof) {
            return ((IEBlockInterfaces.IEntityProof)tile).canEntityDestroy(entity);
        }
        return super.canEntityDestroy(state, world, pos, entity);
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        ItemStack s;
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof IEBlockInterfaces.ITileDrop && !(s = ((IEBlockInterfaces.ITileDrop)tile).getPickBlock(player, world.func_180495_p(pos), target)).func_190926_b()) {
            return s;
        }
        Item item = Item.func_150898_a((Block)this);
        return item == Items.field_190931_a ? ItemStack.field_190927_a : new ItemStack(item, 1, this.func_180651_a(world.func_180495_p(pos)));
    }

    @Override
    public boolean func_189539_a(IBlockState state, World worldIn, BlockPos pos, int eventID, int eventParam) {
        super.func_189539_a(state, worldIn, pos, eventID, eventParam);
        TileEntity tileentity = worldIn.func_175625_s(pos);
        return tileentity != null && tileentity.func_145842_c(eventID, eventParam);
    }

    protected EnumFacing getDefaultFacing() {
        return EnumFacing.NORTH;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        IEProperties.PropertyBoolInverted boolProp;
        state = super.func_176221_a(state, world, pos);
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof IEBlockInterfaces.IAttachedIntegerProperies) {
            for (String s : ((IEBlockInterfaces.IAttachedIntegerProperies)tile).getIntPropertyNames()) {
                state = this.applyProperty(state, ((IEBlockInterfaces.IAttachedIntegerProperies)tile).getIntProperty(s), ((IEBlockInterfaces.IAttachedIntegerProperies)tile).getIntPropertyValue(s));
            }
        }
        if (tile instanceof IEBlockInterfaces.IDirectionalTile && (state.func_177227_a().contains(IEProperties.FACING_ALL) || state.func_177227_a().contains(IEProperties.FACING_HORIZONTAL))) {
            PropertyDirection prop = state.func_177227_a().contains(IEProperties.FACING_HORIZONTAL) ? IEProperties.FACING_HORIZONTAL : IEProperties.FACING_ALL;
            state = this.applyProperty(state, prop, ((IEBlockInterfaces.IDirectionalTile)tile).getFacing());
        }
        if (tile instanceof IEBlockInterfaces.IActiveState) {
            boolProp = ((IEBlockInterfaces.IActiveState)tile).getBoolProperty(IEBlockInterfaces.IActiveState.class);
            if (state.func_177227_a().contains((Object)boolProp)) {
                state = this.applyProperty(state, boolProp, ((IEBlockInterfaces.IActiveState)tile).getIsActive());
            }
        }
        if (tile instanceof IEBlockInterfaces.IDualState) {
            boolProp = ((IEBlockInterfaces.IDualState)tile).getBoolProperty(IEBlockInterfaces.IDualState.class);
            if (state.func_177227_a().contains((Object)boolProp)) {
                state = this.applyProperty(state, boolProp, ((IEBlockInterfaces.IDualState)tile).getIsSecondState());
            }
        }
        if (tile instanceof TileEntityMultiblockPart) {
            state = this.applyProperty(state, IEProperties.MULTIBLOCKSLAVE, ((TileEntityMultiblockPart)tile).isDummy());
        } else if (tile instanceof IEBlockInterfaces.IHasDummyBlocks) {
            state = this.applyProperty(state, IEProperties.MULTIBLOCKSLAVE, ((IEBlockInterfaces.IHasDummyBlocks)tile).isDummy());
        }
        if (tile instanceof IEBlockInterfaces.IMirrorAble) {
            state = this.applyProperty(state, ((IEBlockInterfaces.IMirrorAble)tile).getBoolProperty(IEBlockInterfaces.IMirrorAble.class), ((IEBlockInterfaces.IMirrorAble)tile).getIsMirrored());
        }
        return state;
    }

    public boolean rotateBlock(World world, BlockPos pos, EnumFacing axis) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof IEBlockInterfaces.IDirectionalTile) {
            if (!((IEBlockInterfaces.IDirectionalTile)tile).canRotate(axis)) {
                return false;
            }
            IBlockState state = world.func_180495_p(pos);
            if (state.func_177227_a().contains(IEProperties.FACING_ALL) || state.func_177227_a().contains(IEProperties.FACING_HORIZONTAL)) {
                PropertyDirection prop = state.func_177227_a().contains(IEProperties.FACING_HORIZONTAL) ? IEProperties.FACING_HORIZONTAL : IEProperties.FACING_ALL;
                EnumFacing f = ((IEBlockInterfaces.IDirectionalTile)tile).getFacing();
                int limit = ((IEBlockInterfaces.IDirectionalTile)tile).getFacingLimitation();
                if (limit == 0) {
                    f = EnumFacing.field_82609_l[(f.ordinal() + 1) % EnumFacing.field_82609_l.length];
                } else if (limit == 1) {
                    f = axis.func_176743_c() == EnumFacing.AxisDirection.POSITIVE ? f.func_176732_a(axis.func_176740_k()).func_176734_d() : f.func_176732_a(axis.func_176740_k());
                } else if (limit == 2 || limit == 5) {
                    EnumFacing enumFacing = f = axis.func_176743_c() == EnumFacing.AxisDirection.POSITIVE ? f.func_176746_e() : f.func_176735_f();
                }
                if (f != ((IEBlockInterfaces.IDirectionalTile)tile).getFacing()) {
                    EnumFacing old = ((IEBlockInterfaces.IDirectionalTile)tile).getFacing();
                    ((IEBlockInterfaces.IDirectionalTile)tile).setFacing(f);
                    ((IEBlockInterfaces.IDirectionalTile)tile).afterRotation(old, f);
                    state = this.applyProperty(state, prop, ((IEBlockInterfaces.IDirectionalTile)tile).getFacing());
                    world.func_175656_a(pos, state.func_177231_a((IProperty)prop));
                }
            }
        }
        return false;
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        if ((state = super.getExtendedState(state, world, pos)) instanceof IExtendedBlockState) {
            IExtendedBlockState extended = (IExtendedBlockState)state;
            TileEntity te = world.func_175625_s(pos);
            if (te != null) {
                if (te instanceof IEBlockInterfaces.IConfigurableSides) {
                    for (int i = 0; i < 6; ++i) {
                        if (!extended.getUnlistedNames().contains(IEProperties.SIDECONFIG[i])) continue;
                        extended = extended.withProperty((IUnlistedProperty)IEProperties.SIDECONFIG[i], (Object)((IEBlockInterfaces.IConfigurableSides)te).getSideConfig(i));
                    }
                }
                if (te instanceof IEBlockInterfaces.IAdvancedHasObjProperty) {
                    extended = extended.withProperty(Properties.AnimationProperty, (Object)((IEBlockInterfaces.IAdvancedHasObjProperty)te).getOBJState());
                } else if (te instanceof IEBlockInterfaces.IHasObjProperty) {
                    extended = extended.withProperty(Properties.AnimationProperty, (Object)new OBJModel.OBJState(((IEBlockInterfaces.IHasObjProperty)te).compileDisplayList(), true));
                }
                if (te instanceof IEBlockInterfaces.IDynamicTexture) {
                    extended = extended.withProperty(IEProperties.OBJ_TEXTURE_REMAP, ((IEBlockInterfaces.IDynamicTexture)te).getTextureReplacements());
                }
                if (te instanceof IOBJModelCallback) {
                    extended = extended.withProperty(IOBJModelCallback.PROPERTY, (Object)((IOBJModelCallback)te));
                }
                if (te.hasCapability(CapabilityShader.SHADER_CAPABILITY, null)) {
                    extended = extended.withProperty(CapabilityShader.BLOCKSTATE_PROPERTY, te.getCapability(CapabilityShader.SHADER_CAPABILITY, null));
                }
                if (te instanceof IEBlockInterfaces.IPropertyPassthrough && ((IExtendedBlockState)state).getUnlistedNames().contains(IEProperties.TILEENTITY_PASSTHROUGH)) {
                    extended = extended.withProperty(IEProperties.TILEENTITY_PASSTHROUGH, (Object)te);
                }
                if (te instanceof TileEntityImmersiveConnectable && ((IExtendedBlockState)state).getUnlistedNames().contains(IEProperties.CONNECTIONS)) {
                    extended = extended.withProperty((IUnlistedProperty)IEProperties.CONNECTIONS, ((TileEntityImmersiveConnectable)te).genConnBlockstate());
                }
            }
            state = extended;
        }
        return state;
    }

    @Override
    public void onIEBlockPlacedBy(World world, BlockPos pos, IBlockState state, EnumFacing side, float hitX, float hitY, float hitZ, EntityLivingBase placer, ItemStack stack) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof IEBlockInterfaces.IDirectionalTile) {
            EnumFacing f = ((IEBlockInterfaces.IDirectionalTile)tile).getFacingForPlacement(placer, pos, side, hitX, hitY, hitZ);
            ((IEBlockInterfaces.IDirectionalTile)tile).setFacing(f);
            if (tile instanceof IEBlockInterfaces.IAdvancedDirectionalTile) {
                ((IEBlockInterfaces.IAdvancedDirectionalTile)tile).onDirectionalPlacement(side, hitX, hitY, hitZ, placer);
            }
        }
        if (tile instanceof IEBlockInterfaces.ITileDrop) {
            ((IEBlockInterfaces.ITileDrop)tile).readOnPlacement(placer, stack);
        }
        if (tile instanceof IEBlockInterfaces.IHasDummyBlocks) {
            ((IEBlockInterfaces.IHasDummyBlocks)tile).placeDummies(pos, state, side, hitX, hitY, hitZ);
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        boolean b;
        ItemStack heldItem = player.func_184586_b(hand);
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof IEBlockInterfaces.IConfigurableSides && Utils.isHammer(heldItem) && !world.field_72995_K) {
            int iSide;
            int n = iSide = player.func_70093_af() ? side.func_176734_d().ordinal() : side.ordinal();
            if (((IEBlockInterfaces.IConfigurableSides)tile).toggleSide(iSide, player)) {
                return true;
            }
        }
        if (tile instanceof IEBlockInterfaces.IDirectionalTile && Utils.isHammer(heldItem) && ((IEBlockInterfaces.IDirectionalTile)tile).canHammerRotate(side, hitX, hitY, hitZ, (EntityLivingBase)player) && !world.field_72995_K) {
            EnumFacing f;
            EnumFacing oldF = f = ((IEBlockInterfaces.IDirectionalTile)tile).getFacing();
            int limit = ((IEBlockInterfaces.IDirectionalTile)tile).getFacingLimitation();
            if (limit == 0) {
                f = EnumFacing.field_82609_l[(f.ordinal() + 1) % EnumFacing.field_82609_l.length];
            } else if (limit == 1) {
                f = player.func_70093_af() ? f.func_176732_a(side.func_176740_k()).func_176734_d() : f.func_176732_a(side.func_176740_k());
            } else if (limit == 2 || limit == 5) {
                f = player.func_70093_af() ? f.func_176735_f() : f.func_176746_e();
            }
            ((IEBlockInterfaces.IDirectionalTile)tile).setFacing(f);
            ((IEBlockInterfaces.IDirectionalTile)tile).afterRotation(oldF, f);
            tile.func_70296_d();
            world.func_184138_a(pos, state, state, 3);
            world.func_175641_c(tile.func_174877_v(), tile.func_145838_q(), 255, 0);
            return true;
        }
        if (tile instanceof IEBlockInterfaces.IHammerInteraction && Utils.isHammer(heldItem) && !world.field_72995_K && (b = ((IEBlockInterfaces.IHammerInteraction)tile).hammerUseSide(side, player, hitX, hitY, hitZ))) {
            return b;
        }
        if (tile instanceof IEBlockInterfaces.IPlayerInteraction && (b = ((IEBlockInterfaces.IPlayerInteraction)tile).interact(side, player, hand, heldItem, hitX, hitY, hitZ))) {
            return b;
        }
        if (tile instanceof IEBlockInterfaces.IGuiTile && hand == EnumHand.MAIN_HAND && !player.func_70093_af()) {
            TileEntity master = ((IEBlockInterfaces.IGuiTile)tile).getGuiMaster();
            if (!world.field_72995_K && master != null && ((IEBlockInterfaces.IGuiTile)master).canOpenGui(player)) {
                CommonProxy.openGuiForTile(player, (TileEntity)((IEBlockInterfaces.IGuiTile)master));
            }
            return true;
        }
        return false;
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof IEBlockInterfaces.INeighbourChangeTile && !tile.func_145831_w().field_72995_K) {
            ((IEBlockInterfaces.INeighbourChangeTile)tile).onNeighborBlockChange(pos);
        }
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof IEBlockInterfaces.ILightValue) {
            return ((IEBlockInterfaces.ILightValue)te).getLightValue();
        }
        return 0;
    }

    public BlockIETileProvider setHasColours() {
        this.hasColours = true;
        return this;
    }

    @Override
    public boolean hasCustomBlockColours() {
        return this.hasColours;
    }

    @Override
    public int getRenderColour(IBlockState state, @Nullable IBlockAccess worldIn, @Nullable BlockPos pos, int tintIndex) {
        TileEntity tile;
        if (worldIn != null && pos != null && (tile = worldIn.func_175625_s(pos)) instanceof IEBlockInterfaces.IColouredTile) {
            return ((IEBlockInterfaces.IColouredTile)tile).getRenderColour(tintIndex);
        }
        return 0xFFFFFF;
    }

    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing side) {
        if (this.normalBlockCheck(state)) {
            return BlockFaceShape.SOLID;
        }
        if (side != null) {
            double hMax;
            TileEntity te = world.func_175625_s(pos);
            if (te instanceof IEBlockInterfaces.IFaceShape) {
                return ((IEBlockInterfaces.IFaceShape)te).getFaceShape(side);
            }
            AxisAlignedBB bb = this.func_185496_a(state, world, pos);
            double wMin = side.func_176740_k() == EnumFacing.Axis.X ? bb.field_72339_c : bb.field_72340_a;
            double wMax = side.func_176740_k() == EnumFacing.Axis.X ? bb.field_72334_f : bb.field_72336_d;
            double hMin = side.func_176740_k() == EnumFacing.Axis.Y ? bb.field_72339_c : bb.field_72338_b;
            double d = hMax = side.func_176740_k() == EnumFacing.Axis.Y ? bb.field_72334_f : bb.field_72337_e;
            if (wMin == 0.0 && hMin == 0.0 && wMax == 1.0 && hMax == 1.0) {
                return BlockFaceShape.SOLID;
            }
            if (hMin == 0.0 && hMax == 1.0 && wMin == 1.0 - wMax) {
                if (wMin > 0.375) {
                    return BlockFaceShape.MIDDLE_POLE_THIN;
                }
                if (wMin > 0.3125) {
                    return BlockFaceShape.MIDDLE_POLE;
                }
                return BlockFaceShape.MIDDLE_POLE_THICK;
            }
            if (hMin == wMin && hMax == wMax) {
                if (wMin > 0.375) {
                    return BlockFaceShape.CENTER_SMALL;
                }
                if (wMin > 0.3125) {
                    return BlockFaceShape.CENTER;
                }
                return BlockFaceShape.CENTER_BIG;
            }
            return BlockFaceShape.UNDEFINED;
        }
        return super.func_193383_a(world, state, pos, side);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        float[] bounds;
        if (world.func_180495_p(pos).func_177230_c() != this) {
            return field_185505_j;
        }
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof IEBlockInterfaces.IBlockBounds && (bounds = ((IEBlockInterfaces.IBlockBounds)te).getBlockBounds()) != null) {
            return new AxisAlignedBB((double)bounds[0], (double)bounds[1], (double)bounds[2], (double)bounds[3], (double)bounds[4], (double)bounds[5]);
        }
        return super.func_185496_a(state, world, pos);
    }

    public void func_185477_a(IBlockState state, World world, BlockPos pos, AxisAlignedBB mask, List<AxisAlignedBB> list, @Nullable Entity ent, boolean p_185477_7_) {
        List<AxisAlignedBB> bounds;
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof IEBlockInterfaces.IAdvancedCollisionBounds && (bounds = ((IEBlockInterfaces.IAdvancedCollisionBounds)te).getAdvancedColisionBounds()) != null && !bounds.isEmpty()) {
            for (AxisAlignedBB aabb : bounds) {
                if (aabb == null || !mask.func_72326_a(aabb)) continue;
                list.add(aabb);
            }
            return;
        }
        super.func_185477_a(state, world, pos, mask, list, ent, p_185477_7_);
    }

    public RayTraceResult func_180636_a(IBlockState state, World world, BlockPos pos, Vec3d start, Vec3d end) {
        List<AxisAlignedBB> list;
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof IEBlockInterfaces.IAdvancedSelectionBounds && (list = ((IEBlockInterfaces.IAdvancedSelectionBounds)te).getAdvancedSelectionBounds()) != null && !list.isEmpty()) {
            for (AxisAlignedBB aabb : list) {
                RayTraceResult mop = this.func_185503_a(pos, start, end, aabb.func_72317_d((double)(-pos.func_177958_n()), (double)(-pos.func_177956_o()), (double)(-pos.func_177952_p())));
                if (mop == null) continue;
                return mop;
            }
            return null;
        }
        return super.func_180636_a(state, world, pos, start, end);
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState state, World world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof IEBlockInterfaces.IComparatorOverride) {
            return ((IEBlockInterfaces.IComparatorOverride)te).getComparatorInputOverride();
        }
        return 0;
    }

    public int func_180656_a(IBlockState blockState, IBlockAccess world, BlockPos pos, EnumFacing side) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof IEBlockInterfaces.IRedstoneOutput) {
            return ((IEBlockInterfaces.IRedstoneOutput)te).getWeakRSOutput(blockState, side);
        }
        return 0;
    }

    public int func_176211_b(IBlockState blockState, IBlockAccess world, BlockPos pos, EnumFacing side) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof IEBlockInterfaces.IRedstoneOutput) {
            return ((IEBlockInterfaces.IRedstoneOutput)te).getStrongRSOutput(blockState, side);
        }
        return 0;
    }

    public boolean func_149744_f(IBlockState state) {
        return true;
    }

    public boolean canConnectRedstone(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof IEBlockInterfaces.IRedstoneOutput) {
            return ((IEBlockInterfaces.IRedstoneOutput)te).canConnectRedstone(state, side);
        }
        return false;
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntityIEBase) {
            ((TileEntityIEBase)te).onEntityCollision(world, entity);
        }
    }
}

