/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.cloth;

import blusunrize.immersiveengineering.api.energy.wires.ImmersiveNetHandler;
import blusunrize.immersiveengineering.api.shader.CapabilityShader;
import blusunrize.immersiveengineering.api.shader.IShaderItem;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityConnectorStructural;
import blusunrize.immersiveengineering.common.util.Utils;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.common.capabilities.Capability;

public class TileEntityBalloon
extends TileEntityConnectorStructural
implements IEBlockInterfaces.ILightValue,
IEBlockInterfaces.IPlayerInteraction,
IEBlockInterfaces.IHammerInteraction {
    public int style = 0;
    public int colour0 = 0xFFFFFF;
    public int colour1 = 0xFFFFFF;
    public CapabilityShader.ShaderWrapper_Direct shader = new CapabilityShader.ShaderWrapper_Direct("immersiveengineering:balloon");

    @Override
    public int getLightValue() {
        return 13;
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        int nbtVersion = nbt.func_74762_e("nbtVersion");
        if (nbtVersion >= 1) {
            this.style = nbt.func_74762_e("style");
            this.colour0 = nbt.func_74762_e("colour0");
            this.colour1 = nbt.func_74762_e("colour1");
        }
        if (nbt.func_74764_b("shader")) {
            this.shader = new CapabilityShader.ShaderWrapper_Direct("immersiveengineering:balloon");
            this.shader.deserializeNBT(nbt.func_74775_l("shader"));
        }
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        nbt.func_74768_a("nbtVersion", 1);
        nbt.func_74768_a("style", this.style);
        nbt.func_74768_a("colour0", this.colour0);
        nbt.func_74768_a("colour1", this.colour1);
        nbt.func_74782_a("shader", (NBTBase)this.shader.serializeNBT());
    }

    @Override
    public float[] getBlockBounds() {
        return new float[]{0.125f, 0.0f, 0.125f, 0.875f, 0.9375f, 0.875f};
    }

    @Override
    public boolean func_145842_c(int id, int arg) {
        if (id == 0) {
            this.markContainingBlockForUpdate(null);
            return true;
        }
        return super.func_145842_c(id, arg);
    }

    @Override
    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityShader.SHADER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityShader.SHADER_CAPABILITY) {
            return (T)this.shader;
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public String getCacheKey(IBlockState object) {
        if (this.shader != null && !this.shader.getShaderItem().func_190926_b() && this.shader.getShaderItem().func_77973_b() instanceof IShaderItem) {
            return ((IShaderItem)this.shader.getShaderItem().func_77973_b()).getShaderName(this.shader.getShaderItem());
        }
        return this.colour0 + ":" + this.colour1 + ":" + this.style;
    }

    @Override
    public int getRenderColour(IBlockState object, String group) {
        if (this.shader != null && !this.shader.getShaderItem().func_190926_b() && this.shader.getShaderItem().func_77973_b() instanceof IShaderItem) {
            return -1;
        }
        if (this.style == 0) {
            if (group.startsWith("balloon1_")) {
                return 0xFF000000 | this.colour1;
            }
            if (group.startsWith("balloon0_")) {
                return 0xFF000000 | this.colour0;
            }
        } else {
            if (group.endsWith("_1")) {
                return 0xFF000000 | this.colour1;
            }
            if (group.endsWith("_0")) {
                return 0xFF000000 | this.colour0;
            }
        }
        return -1;
    }

    @Override
    public Vec3d getConnectionOffset(ImmersiveNetHandler.Connection con) {
        double dist;
        int yDif;
        int zDif;
        int xDif;
        int n = con == null || con.start == null || con.end == null ? 0 : (con.start.equals((Object)this.func_174877_v()) && con.end != null ? con.end.func_177958_n() - this.func_174877_v().func_177958_n() : (xDif = con.end.equals((Object)this.func_174877_v()) && con.start != null ? con.start.func_177958_n() - this.func_174877_v().func_177958_n() : 0));
        int n2 = con == null || con.start == null || con.end == null ? 0 : (con.start.equals((Object)this.func_174877_v()) && con.end != null ? con.end.func_177952_p() - this.func_174877_v().func_177952_p() : (zDif = con.end.equals((Object)this.func_174877_v()) && con.start != null ? con.start.func_177952_p() - this.func_174877_v().func_177952_p() : 0));
        int n3 = con == null || con.start == null || con.end == null ? 0 : (con.start.equals((Object)this.func_174877_v()) && con.end != null ? con.end.func_177956_o() - this.func_174877_v().func_177956_o() : (yDif = con.end.equals((Object)this.func_174877_v()) && con.start != null ? con.start.func_177956_o() - this.func_174877_v().func_177956_o() : 0));
        if (yDif < 0 && (dist = Math.sqrt(xDif * xDif + zDif * zDif)) / (double)Math.abs(yDif) < 2.5) {
            return new Vec3d(0.5, 0.09375, 0.5);
        }
        if (Math.abs(zDif) > Math.abs(xDif)) {
            return new Vec3d(0.5, 0.09375, zDif > 0 ? 0.78125 : 0.21875);
        }
        return new Vec3d(xDif > 0 ? 0.78125 : 0.21875, 0.09375, 0.5);
    }

    @Override
    public boolean interact(EnumFacing side, EntityPlayer player, EnumHand hand, ItemStack heldItem, float hitX, float hitY, float hitZ) {
        if (!heldItem.func_190926_b() && heldItem.func_77973_b() instanceof IShaderItem) {
            if (this.shader == null) {
                this.shader = new CapabilityShader.ShaderWrapper_Direct("immersiveengineering:balloon");
            }
            this.shader.setShaderItem(Utils.copyStackWithAmount(heldItem, 1));
            this.markContainingBlockForUpdate(null);
            return true;
        }
        boolean target = false;
        if (side.func_176740_k() == EnumFacing.Axis.Y && this.style == 0) {
            target = ((double)hitX < 0.375 || (double)hitX > 0.625) && ((double)hitZ < 0.375 || (double)hitZ > 0.625);
        } else if (side.func_176740_k() == EnumFacing.Axis.Z) {
            target = this.style == 0 ? (double)hitX < 0.375 || (double)hitX > 0.625 : (double)hitY > 0.5625 && (double)hitY < 0.75;
        } else if (side.func_176740_k() == EnumFacing.Axis.X) {
            target = this.style == 0 ? (double)hitZ < 0.375 || (double)hitZ > 0.625 : (double)hitY > 0.5625 && (double)hitY < 0.75;
        }
        int heldDye = Utils.getDye(heldItem);
        if (heldDye == -1) {
            return false;
        }
        heldDye = EnumDyeColor.func_176764_b((int)(15 - heldDye)).func_193350_e();
        if (!target) {
            if (this.colour0 == heldDye) {
                return false;
            }
            this.colour0 = heldDye;
        } else {
            if (this.colour1 == heldDye) {
                return false;
            }
            this.colour1 = heldDye;
        }
        this.markContainingBlockForUpdate(null);
        return true;
    }

    @Override
    public boolean hammerUseSide(EnumFacing side, EntityPlayer player, float hitX, float hitY, float hitZ) {
        this.style = 1 - this.style;
        this.markContainingBlockForUpdate(null);
        return true;
    }
}

