/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.common.blocks.BlockIEBase;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.ItemBlockIEBase;
import blusunrize.immersiveengineering.common.blocks.metal.BlockTypes_MetalLadder;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityLadder;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockMetalLadder
extends BlockIEBase.IELadderBlock<BlockTypes_MetalLadder> {
    protected static final AxisAlignedBB[] LADDER_AABB = new AxisAlignedBB[]{new AxisAlignedBB(0.0, 0.0, 0.8125, 1.0, 1.0, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.1875), new AxisAlignedBB(0.8125, 0.0, 0.0, 1.0, 1.0, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 0.1875, 1.0, 1.0)};
    protected static final AxisAlignedBB[] FRAME_AABB = new AxisAlignedBB[]{new AxisAlignedBB(0.0, 0.0, 0.9375, 1.0, 1.0, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.0625), new AxisAlignedBB(0.9375, 0.0, 0.0, 1.0, 1.0, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 0.0625, 1.0, 1.0)};

    public BlockMetalLadder() {
        super("metal_ladder", Material.field_151573_f, PropertyEnum.func_177709_a((String)"type", BlockTypes_MetalLadder.class), ItemBlockIEBase.class, IEProperties.FACING_HORIZONTAL);
        this.func_149711_c(3.0f);
        this.func_149752_b(15.0f);
        this.setBlockLayer(BlockRenderLayer.CUTOUT_MIPPED);
        this.setAllNotNormalBlock();
        this.field_149786_r = 0;
    }

    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing side) {
        int meta = this.func_176201_c(state);
        if (meta == 0) {
            return BlockFaceShape.UNDEFINED;
        }
        if (side.func_176740_k() == EnumFacing.Axis.Y) {
            return BlockFaceShape.BOWL;
        }
        return BlockFaceShape.SOLID;
    }

    public boolean isSideSolid(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        int meta = this.func_176201_c(state);
        return meta != 0 && side.func_176740_k() != EnumFacing.Axis.Y && super.isSideSolid(state, world, pos, side);
    }

    public boolean func_176225_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return true;
    }

    public void func_185477_a(IBlockState state, World world, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean p_185477_7_) {
        int meta = this.func_176201_c(state);
        if (meta == 0) {
            BlockMetalLadder.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)this.func_185496_a(state, (IBlockAccess)world, pos));
        } else {
            EnumFacing dir = ((TileEntityLadder)world.func_175625_s(pos)).getFacing();
            for (int i = 0; i < 4; ++i) {
                if (i == dir.func_176745_a() - 2) {
                    BlockMetalLadder.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)LADDER_AABB[i]);
                    continue;
                }
                BlockMetalLadder.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)FRAME_AABB[i]);
            }
        }
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity tileEntity;
        if (this.func_176201_c(state) == 0 && (tileEntity = world.func_175625_s(pos)) instanceof IEBlockInterfaces.IDirectionalTile) {
            IEBlockInterfaces.IDirectionalTile directionalTile = (IEBlockInterfaces.IDirectionalTile)tileEntity;
            return LADDER_AABB[directionalTile.getFacing().func_176745_a() - 2];
        }
        return super.func_185496_a(state, world, pos);
    }

    @Override
    public boolean canIEBlockBePlaced(World world, BlockPos pos, IBlockState newState, EnumFacing side, float hitX, float hitY, float hitZ, EntityPlayer player, ItemStack stack) {
        if (stack.func_77960_j() > 0) {
            return true;
        }
        if (this.canAttachTo(world, pos.func_177976_e(), side)) {
            return true;
        }
        if (this.canAttachTo(world, pos.func_177974_f(), side)) {
            return true;
        }
        if (this.canAttachTo(world, pos.func_177978_c(), side)) {
            return true;
        }
        return this.canAttachTo(world, pos.func_177968_d(), side);
    }

    public boolean canAttachTo(World world, BlockPos pos, EnumFacing facing) {
        IBlockState state = world.func_180495_p(pos);
        boolean flag = BlockMetalLadder.func_193382_c((Block)state.func_177230_c());
        return !flag && state.func_193401_d((IBlockAccess)world, pos, facing) == BlockFaceShape.SOLID && !state.func_185897_m();
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos) {
        TileEntityLadder tile = (TileEntityLadder)world.func_175625_s(pos);
        if (tile != null) {
            EnumFacing enumfacing = tile.getFacing();
            if (this.func_176201_c(state) == 0 && !this.canAttachTo(world, pos.func_177972_a(enumfacing.func_176734_d()), enumfacing)) {
                this.func_176226_b(world, pos, state, 0);
                world.func_175698_g(pos);
            }
        }
        super.func_189540_a(state, world, pos, blockIn, fromPos);
    }

    @Override
    public void onIEBlockPlacedBy(World world, BlockPos pos, IBlockState state, EnumFacing side, float hitX, float hitY, float hitZ, EntityLivingBase placer, ItemStack stack) {
        TileEntityLadder tile = (TileEntityLadder)world.func_175625_s(pos);
        if (tile != null) {
            tile.setFacing(tile.getFacingForPlacement(placer, pos, side, hitX, hitY, hitZ));
        }
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        state = super.func_176221_a(state, world, pos);
        TileEntityLadder tile = (TileEntityLadder)world.func_175625_s(pos);
        if (tile != null && tile.getFacing().func_176740_k().func_176722_c()) {
            state = this.applyProperty(state, IEProperties.FACING_HORIZONTAL, tile.getFacing());
        }
        return state;
    }

    public boolean isLadder(IBlockState state, IBlockAccess world, BlockPos pos, EntityLivingBase entity) {
        return true;
    }

    @Override
    public boolean allowHammerHarvest(IBlockState state) {
        return true;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileEntityLadder();
    }
}

