/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.TargetingInfo;
import blusunrize.immersiveengineering.api.energy.wires.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.energy.wires.ImmersiveNetHandler;
import blusunrize.immersiveengineering.api.energy.wires.TileEntityImmersiveConnectable;
import blusunrize.immersiveengineering.api.energy.wires.WireType;
import blusunrize.immersiveengineering.api.energy.wires.redstone.IRedstoneConnector;
import blusunrize.immersiveengineering.api.energy.wires.redstone.RedstoneWireNetwork;
import blusunrize.immersiveengineering.client.models.IOBJModelCallback;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import javax.annotation.Nullable;
import net.minecraft.block.BlockRedstoneWire;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityConnectorRedstone
extends TileEntityImmersiveConnectable
implements ITickable,
IEBlockInterfaces.IDirectionalTile,
IEBlockInterfaces.IRedstoneOutput,
IEBlockInterfaces.IHammerInteraction,
IEBlockInterfaces.IBlockBounds,
IEBlockInterfaces.IBlockOverlayText,
IOBJModelCallback<IBlockState>,
IRedstoneConnector {
    public EnumFacing facing = EnumFacing.DOWN;
    public int ioMode = 0;
    public int redstoneChannel = 0;
    public boolean rsDirty = false;
    protected RedstoneWireNetwork wireNetwork = new RedstoneWireNetwork().add(this);
    private boolean refreshWireNetwork = false;
    private int outputClient = -1;
    @SideOnly(value=Side.CLIENT)
    private AxisAlignedBB renderAABB;

    public void func_73660_a() {
        if (this.func_145830_o() && !this.field_145850_b.field_72995_K && !this.refreshWireNetwork) {
            this.refreshWireNetwork = true;
            this.wireNetwork.removeFromNetwork(null);
        }
        if (this.func_145830_o() && !this.field_145850_b.field_72995_K && this.rsDirty) {
            this.wireNetwork.updateValues();
        }
    }

    @Override
    public int getStrongRSOutput(IBlockState state, EnumFacing side) {
        if (!this.isRSOutput() || side != this.facing.func_176734_d()) {
            return 0;
        }
        if (this.field_145850_b.field_72995_K) {
            return this.outputClient;
        }
        return this.wireNetwork != null ? this.wireNetwork.getPowerOutput(this.redstoneChannel) : 0;
    }

    @Override
    public int getWeakRSOutput(IBlockState state, EnumFacing side) {
        if (!this.isRSOutput()) {
            return 0;
        }
        if (this.field_145850_b.field_72995_K) {
            return this.outputClient;
        }
        return this.wireNetwork != null ? this.wireNetwork.getPowerOutput(this.redstoneChannel) : 0;
    }

    @Override
    public boolean canConnectRedstone(IBlockState state, EnumFacing side) {
        return true;
    }

    @Override
    public void setNetwork(RedstoneWireNetwork net) {
        this.wireNetwork = net;
    }

    @Override
    public RedstoneWireNetwork getNetwork() {
        return this.wireNetwork;
    }

    @Override
    public void onChange() {
        if (!this.func_145837_r() && this.isRSOutput()) {
            this.func_70296_d();
            this.markContainingBlockForUpdate(null);
            this.markBlockForUpdate(this.field_174879_c.func_177972_a(this.facing), null);
        }
    }

    @Override
    public World getConnectorWorld() {
        return this.func_145831_w();
    }

    public boolean isRSInput() {
        return this.ioMode == 0;
    }

    @Override
    public void updateInput(byte[] signals) {
        if (this.isRSInput()) {
            signals[this.redstoneChannel] = (byte)Math.max(this.getLocalRS(), signals[this.redstoneChannel]);
        }
        this.rsDirty = false;
    }

    protected int getLocalRS() {
        int val = this.field_145850_b.func_175687_A(this.field_174879_c);
        if (val == 0) {
            for (EnumFacing f : EnumFacing.field_176754_o) {
                IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c.func_177972_a(f));
                if (state.func_177230_c() != Blocks.field_150488_af || (Integer)state.func_177229_b((IProperty)BlockRedstoneWire.field_176351_O) <= val) continue;
                val = (Integer)state.func_177229_b((IProperty)BlockRedstoneWire.field_176351_O);
            }
        }
        return val;
    }

    public boolean isRSOutput() {
        return this.ioMode == 1;
    }

    @Override
    public boolean hammerUseSide(EnumFacing side, EntityPlayer player, float hitX, float hitY, float hitZ) {
        if (player.func_70093_af()) {
            this.redstoneChannel = (this.redstoneChannel + 1) % 16;
        } else {
            this.ioMode = this.ioMode == 0 ? 1 : 0;
        }
        this.func_70296_d();
        this.wireNetwork.updateValues();
        this.onChange();
        this.markContainingBlockForUpdate(null);
        this.field_145850_b.func_175641_c(this.func_174877_v(), this.func_145838_q(), 254, 0);
        return true;
    }

    @Override
    public boolean canConnectCable(WireType cableType, TargetingInfo target, Vec3i offset) {
        if (!"REDSTONE".equals(cableType.getCategory())) {
            return false;
        }
        return this.limitType == null || this.limitType == cableType;
    }

    @Override
    public void connectCable(WireType cableType, TargetingInfo target, IImmersiveConnectable other) {
        super.connectCable(cableType, target, other);
        RedstoneWireNetwork.updateConnectors(this.field_174879_c, this.field_145850_b, this.wireNetwork);
    }

    @Override
    public void removeCable(@Nullable ImmersiveNetHandler.Connection connection) {
        super.removeCable(connection);
        this.wireNetwork.removeFromNetwork(this);
    }

    @Override
    public EnumFacing getFacing() {
        return this.facing;
    }

    @Override
    public void setFacing(EnumFacing facing) {
        this.facing = facing;
    }

    @Override
    public int getFacingLimitation() {
        return 0;
    }

    @Override
    public boolean mirrorFacingOnPlacement(EntityLivingBase placer) {
        return true;
    }

    @Override
    public boolean canHammerRotate(EnumFacing side, float hitX, float hitY, float hitZ, EntityLivingBase entity) {
        return false;
    }

    @Override
    public boolean canRotate(EnumFacing axis) {
        return false;
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        nbt.func_74768_a("facing", this.facing.ordinal());
        nbt.func_74768_a("ioMode", this.ioMode);
        nbt.func_74768_a("redstoneChannel", this.redstoneChannel);
        nbt.func_74768_a("output", this.wireNetwork != null ? this.wireNetwork.getPowerOutput(this.redstoneChannel) : 0);
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        this.facing = EnumFacing.func_82600_a((int)nbt.func_74762_e("facing"));
        this.ioMode = nbt.func_74762_e("ioMode");
        this.redstoneChannel = nbt.func_74762_e("redstoneChannel");
        this.outputClient = nbt.func_74762_e("output");
    }

    @Override
    public Vec3d getConnectionOffset(ImmersiveNetHandler.Connection con) {
        EnumFacing side = this.facing.func_176734_d();
        double conRadius = con.cableType.getRenderDiameter() / 2.0;
        return new Vec3d(0.5 - conRadius * (double)side.func_82601_c(), 0.5 - conRadius * (double)side.func_96559_d(), 0.5 - conRadius * (double)side.func_82599_e());
    }

    @Override
    public void onConnectivityUpdate(BlockPos pos, int dimension) {
        this.refreshWireNetwork = false;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        int inc = this.getRenderRadiusIncrease();
        return new AxisAlignedBB((double)(this.field_174879_c.func_177958_n() - inc), (double)(this.field_174879_c.func_177956_o() - inc), (double)(this.field_174879_c.func_177952_p() - inc), (double)(this.field_174879_c.func_177958_n() + inc + 1), (double)(this.field_174879_c.func_177956_o() + inc + 1), (double)(this.field_174879_c.func_177952_p() + inc + 1));
    }

    int getRenderRadiusIncrease() {
        return WireType.REDSTONE.getMaxLength();
    }

    @Override
    public float[] getBlockBounds() {
        float length = 0.625f;
        float wMin = 0.3125f;
        float wMax = 0.6875f;
        switch (this.facing.func_176734_d()) {
            case UP: {
                return new float[]{wMin, 0.0f, wMin, wMax, length, wMax};
            }
            case DOWN: {
                return new float[]{wMin, 1.0f - length, wMin, wMax, 1.0f, wMax};
            }
            case SOUTH: {
                return new float[]{wMin, wMin, 0.0f, wMax, wMax, length};
            }
            case NORTH: {
                return new float[]{wMin, wMin, 1.0f - length, wMax, wMax, 1.0f};
            }
            case EAST: {
                return new float[]{0.0f, wMin, wMin, length, wMax, wMax};
            }
            case WEST: {
                return new float[]{1.0f - length, wMin, wMin, 1.0f, wMax, wMax};
            }
        }
        return new float[]{0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f};
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean shouldRenderGroup(IBlockState object, String group) {
        if ("io_out".equals(group)) {
            return this.ioMode == 1;
        }
        if ("io_in".equals(group)) {
            return this.ioMode == 0;
        }
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int getRenderColour(IBlockState object, String group) {
        if ("coloured".equals(group)) {
            return 0xFF000000 | EnumDyeColor.func_176764_b((int)this.redstoneChannel).func_193350_e();
        }
        return -1;
    }

    @Override
    public String getCacheKey(IBlockState object) {
        return this.redstoneChannel + ";" + this.ioMode;
    }

    @Override
    public String[] getOverlayText(EntityPlayer player, RayTraceResult mop, boolean hammer) {
        if (!hammer) {
            return null;
        }
        return new String[]{I18n.func_135052_a((String)"desc.immersiveengineering.info.redstoneChannel", (Object[])new Object[]{I18n.func_135052_a((String)("item.fireworksCharge." + EnumDyeColor.func_176764_b((int)this.redstoneChannel).func_176762_d()), (Object[])new Object[0])}), I18n.func_135052_a((String)("desc.immersiveengineering.info.blockSide.io." + this.ioMode), (Object[])new Object[0])};
    }

    @Override
    public boolean useNixieFont(EntityPlayer player, RayTraceResult mop) {
        return false;
    }
}

