/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.crafting.MixerRecipe;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityMultiblockMetal;
import blusunrize.immersiveengineering.common.blocks.multiblocks.MultiblockMixer;
import blusunrize.immersiveengineering.common.crafting.MixerRecipePotion;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.inventory.IEInventoryHandler;
import blusunrize.immersiveengineering.common.util.inventory.IIEInventory;
import blusunrize.immersiveengineering.common.util.inventory.MultiFluidTank;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionHelper;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class TileEntityMixer
extends TileEntityMultiblockMetal<TileEntityMixer, MixerRecipe>
implements IEBlockInterfaces.IAdvancedSelectionBounds,
IEBlockInterfaces.IAdvancedCollisionBounds,
IEBlockInterfaces.IGuiTile {
    public MultiFluidTank tank = new MultiFluidTank(8000);
    public NonNullList<ItemStack> inventory = NonNullList.func_191197_a((int)8, (Object)ItemStack.field_190927_a);
    public float animation_agitator = 0.0f;
    public boolean outputAll;
    IItemHandler insertionHandler = new IEInventoryHandler(8, (IIEInventory)this, 0, new boolean[]{true, true, true, true, true, true, true, true}, new boolean[8]);

    public TileEntityMixer() {
        super(MultiblockMixer.instance, new int[]{3, 3, 3}, 16000, true);
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        this.tank.readFromNBT(nbt.func_74775_l("tank"));
        if (!descPacket) {
            this.inventory = Utils.readInventory(nbt.func_150295_c("inventory", 10), 8);
        }
        this.outputAll = nbt.func_74767_n("outputAll");
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        NBTTagCompound tankTag = this.tank.writeToNBT(new NBTTagCompound());
        nbt.func_74782_a("tank", (NBTBase)tankTag);
        if (!descPacket) {
            nbt.func_74782_a("inventory", (NBTBase)Utils.writeInventory(this.inventory));
        }
        nbt.func_74757_a("outputAll", this.outputAll);
    }

    @Override
    public void receiveMessageFromClient(NBTTagCompound message) {
        super.receiveMessageFromClient(message);
        if (message.func_74764_b("outputAll")) {
            this.outputAll = message.func_74767_n("outputAll");
        }
    }

    @Override
    public void func_73660_a() {
        block15: {
            boolean update;
            block16: {
                IFluidHandler output;
                block17: {
                    FluidStack out;
                    int accepted;
                    BlockPos outputPos;
                    int tankAmount;
                    block14: {
                        super.func_73660_a();
                        if (this.isDummy() || this.isRSDisabled()) {
                            return;
                        }
                        if (!this.field_145850_b.field_72995_K) break block14;
                        if (this.shouldRenderAsActive()) {
                            if (Utils.RAND.nextInt(8) == 0) {
                                FluidStack fs;
                                FluidStack fluidStack = fs = !this.tank.fluids.isEmpty() ? this.tank.fluids.get(0) : null;
                                if (fs != null) {
                                    float amount = (float)this.tank.getFluidAmount() / (float)this.tank.getCapacity() * 1.125f;
                                    Vec3d partPos = new Vec3d((double)((float)this.func_174877_v().func_177958_n() + 0.5f + (float)this.facing.func_82601_c() * 0.5f + (float)(this.mirrored ? this.facing.func_176735_f() : this.facing.func_176746_e()).func_82601_c() * 0.5f), (double)((float)this.func_174877_v().func_177956_o() - 0.0625f + amount), (double)((float)this.func_174877_v().func_177952_p() + 0.5f + (float)this.facing.func_82599_e() * 0.5f + (float)(this.mirrored ? this.facing.func_176735_f() : this.facing.func_176746_e()).func_82599_e() * 0.5f));
                                    float r = Utils.RAND.nextFloat() * 0.8125f;
                                    float angleRad = (float)Math.toRadians(this.animation_agitator);
                                    partPos = partPos.func_72441_c((double)r * Math.cos(angleRad), 0.0, (double)r * Math.sin(angleRad));
                                    if (Utils.RAND.nextBoolean()) {
                                        ImmersiveEngineering.proxy.spawnBubbleFX(this.field_145850_b, fs, partPos.field_72450_a, partPos.field_72448_b, partPos.field_72449_c, 0.0, 0.0, 0.0);
                                    } else {
                                        ImmersiveEngineering.proxy.spawnFluidSplashFX(this.field_145850_b, fs, partPos.field_72450_a, partPos.field_72448_b, partPos.field_72449_c, 0.0, 0.0, 0.0);
                                    }
                                }
                            }
                            this.animation_agitator = (this.animation_agitator + 9.0f) % 360.0f;
                        }
                        break block15;
                    }
                    update = false;
                    boolean foundRecipe = false;
                    if (this.energyStorage.getEnergyStored() > 0 && this.processQueue.size() < this.getProcessQueueMaxLength() && (tankAmount = this.tank.getFluidAmount()) > 0) {
                        HashSet<Integer> usedInvSlots = new HashSet<Integer>();
                        for (TileEntityMultiblockMetal.MultiblockProcess process : this.processQueue) {
                            if (!(process instanceof TileEntityMultiblockMetal.MultiblockProcessInMachine)) continue;
                            for (int i : ((TileEntityMultiblockMetal.MultiblockProcessInMachine)process).inputSlots) {
                                usedInvSlots.add(i);
                            }
                        }
                        NonNullList components = NonNullList.func_191197_a((int)this.inventory.size(), (Object)ItemStack.field_190927_a);
                        for (int i = 0; i < components.size(); ++i) {
                            if (usedInvSlots.contains(i)) continue;
                            components.set(i, this.inventory.get(i));
                        }
                        for (FluidStack fs : this.tank.fluids) {
                            MixerRecipe recipe = MixerRecipe.findRecipe(fs, (NonNullList<ItemStack>)components);
                            if (recipe == null) continue;
                            foundRecipe = true;
                            TileEntityMultiblockMetal.MultiblockProcessInMachine process = new MultiblockProcessMixer(recipe, recipe.getUsedSlots(fs, (NonNullList<ItemStack>)components)).setInputTanks(0);
                            if (!this.addProcessToQueue(process, true)) continue;
                            this.addProcessToQueue(process, false);
                            update = true;
                        }
                    }
                    if (this.tank.getFluidTypes() <= 1 && foundRecipe && !this.outputAll || (output = FluidUtil.getFluidHandler((World)this.field_145850_b, (BlockPos)(outputPos = this.func_174877_v().func_177977_b().func_177967_a(this.facing.func_176734_d(), 2)), (EnumFacing)this.facing)) == null) break block16;
                    if (this.outputAll) break block17;
                    FluidStack inTank = this.tank.getFluid();
                    if (inTank == null || (accepted = output.fill(out = Utils.copyFluidStackWithAmount(inTank, Math.min(inTank.amount, 80), false), false)) <= 0) break block16;
                    int drained = output.fill(Utils.copyFluidStackWithAmount(out, Math.min(out.amount, accepted), false), true);
                    this.tank.drain(drained, true);
                    update = true;
                    break block16;
                }
                int totalOut = 0;
                Iterator<FluidStack> it = this.tank.fluids.iterator();
                while (it.hasNext()) {
                    FluidStack fs;
                    fs = it.next();
                    if (fs == null) continue;
                    FluidStack out = Utils.copyFluidStackWithAmount(fs, Math.min(fs.amount, 80 - totalOut), false);
                    int accepted = output.fill(out, false);
                    if (accepted > 0) {
                        int drained = output.fill(Utils.copyFluidStackWithAmount(out, Math.min(out.amount, accepted), false), true);
                        MultiFluidTank.drain(drained, fs, it, true);
                        totalOut += drained;
                        update = true;
                    }
                    if (totalOut < 80) continue;
                    break;
                }
            }
            if (update) {
                this.func_70296_d();
                this.markContainingBlockForUpdate(null);
            }
        }
    }

    @Override
    public float[] getBlockBounds() {
        if (this.field_174879_c > 1 && this.field_174879_c < 9 && this.field_174879_c != 3) {
            return new float[]{0.0f, 0.0f, 0.0f, 1.0f, 0.5f, 1.0f};
        }
        if (this.field_174879_c == 11) {
            return new float[]{this.facing == EnumFacing.WEST ? 0.5f : 0.0f, 0.0f, this.facing == EnumFacing.NORTH ? 0.5f : 0.0f, this.facing == EnumFacing.EAST ? 0.5f : 1.0f, 1.0f, this.facing == EnumFacing.SOUTH ? 0.5f : 1.0f};
        }
        return new float[]{0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f};
    }

    @Override
    public List<AxisAlignedBB> getAdvancedSelectionBounds() {
        EnumFacing fl = this.facing;
        EnumFacing fw = this.facing.func_176746_e();
        if (this.mirrored) {
            fw = fw.func_176734_d();
        }
        if (this.field_174879_c == 2) {
            float minZ;
            float maxX;
            float minX;
            ArrayList list = Lists.newArrayList((Object[])new AxisAlignedBB[]{new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p())});
            float f = fl == EnumFacing.WEST ? 0.625f : (minX = fl == EnumFacing.EAST ? 0.125f : 0.125f);
            float f2 = fl == EnumFacing.EAST ? 0.375f : (maxX = fl == EnumFacing.WEST ? 0.875f : 0.25f);
            float f3 = fl == EnumFacing.NORTH ? 0.625f : (minZ = fl == EnumFacing.SOUTH ? 0.125f : 0.125f);
            float maxZ = fl == EnumFacing.SOUTH ? 0.375f : (fl == EnumFacing.NORTH ? 0.875f : 0.25f);
            list.add(new AxisAlignedBB((double)minX, 0.5, (double)minZ, (double)maxX, 1.0, (double)maxZ).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()));
            float f4 = fl == EnumFacing.WEST ? 0.625f : (minX = fl == EnumFacing.EAST ? 0.125f : 0.75f);
            float f5 = fl == EnumFacing.EAST ? 0.375f : (maxX = fl == EnumFacing.WEST ? 0.875f : 0.875f);
            float f6 = fl == EnumFacing.NORTH ? 0.625f : (minZ = fl == EnumFacing.SOUTH ? 0.125f : 0.75f);
            maxZ = fl == EnumFacing.SOUTH ? 0.375f : (fl == EnumFacing.NORTH ? 0.875f : 0.875f);
            list.add(new AxisAlignedBB((double)minX, 0.5, (double)minZ, (double)maxX, 1.0, (double)maxZ).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()));
            return list;
        }
        if (this.field_174879_c == 4 || this.field_174879_c == 5 || this.field_174879_c == 7 || this.field_174879_c == 8) {
            float minZ;
            float maxX;
            float minX;
            ArrayList list = Lists.newArrayList((Object[])new AxisAlignedBB[]{new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p())});
            if (this.field_174879_c > 5) {
                fl = fl.func_176734_d();
            }
            if (this.field_174879_c % 3 == 2) {
                fw = fw.func_176734_d();
            }
            float f = fl == EnumFacing.WEST ? 0.6875f : (fl == EnumFacing.EAST ? 0.0625f : (minX = fw == EnumFacing.EAST ? 0.0625f : 0.6875f));
            float f7 = fl == EnumFacing.EAST ? 0.3125f : (fl == EnumFacing.WEST ? 0.9375f : (maxX = fw == EnumFacing.EAST ? 0.3125f : 0.9375f));
            float f8 = fl == EnumFacing.NORTH ? 0.6875f : (fl == EnumFacing.SOUTH ? 0.0625f : (minZ = fw == EnumFacing.SOUTH ? 0.0625f : 0.6875f));
            float maxZ = fl == EnumFacing.SOUTH ? 0.3125f : (fl == EnumFacing.NORTH ? 0.9375f : (fw == EnumFacing.SOUTH ? 0.3125f : 0.9375f));
            list.add(new AxisAlignedBB((double)minX, 0.5, (double)minZ, (double)maxX, 1.0, (double)maxZ).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()));
            if (this.field_174879_c == 4) {
                float f9 = fl == EnumFacing.WEST ? 0.375f : (fl == EnumFacing.EAST ? 0.625f : (minX = fw == EnumFacing.WEST ? -0.125f : 0.0f));
                float f10 = fl == EnumFacing.EAST ? 0.375f : (fl == EnumFacing.WEST ? 0.625f : (maxX = fw == EnumFacing.EAST ? 1.125f : 1.0f));
                float f11 = fl == EnumFacing.NORTH ? 0.375f : (fl == EnumFacing.SOUTH ? 0.625f : (minZ = fw == EnumFacing.NORTH ? -0.125f : 0.0f));
                maxZ = fl == EnumFacing.SOUTH ? 0.375f : (fl == EnumFacing.NORTH ? 0.625f : (fw == EnumFacing.SOUTH ? 1.125f : 1.0f));
                list.add(new AxisAlignedBB((double)minX, 0.5, (double)minZ, (double)maxX, 0.75, (double)maxZ).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()));
                float f12 = fl == EnumFacing.WEST ? -0.125f : (fl == EnumFacing.EAST ? 0.625f : (minX = fw == EnumFacing.WEST ? -0.125f : 0.875f));
                float f13 = fl == EnumFacing.EAST ? 1.125f : (fl == EnumFacing.WEST ? 0.375f : (maxX = fw == EnumFacing.EAST ? 1.125f : 0.125f));
                float f14 = fl == EnumFacing.NORTH ? -0.125f : (fl == EnumFacing.SOUTH ? 0.625f : (minZ = fw == EnumFacing.NORTH ? -0.125f : 0.875f));
                maxZ = fl == EnumFacing.SOUTH ? 1.25f : (fl == EnumFacing.NORTH ? 0.375f : (fw == EnumFacing.SOUTH ? 1.125f : 0.125f));
                list.add(new AxisAlignedBB((double)minX, 0.5, (double)minZ, (double)maxX, 0.75, (double)maxZ).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()));
                float f15 = fl == EnumFacing.WEST ? -0.125f : (fl == EnumFacing.EAST ? 0.875f : (minX = fw == EnumFacing.WEST ? -0.125f : 0.875f));
                float f16 = fl == EnumFacing.EAST ? 1.125f : (fl == EnumFacing.WEST ? 0.125f : (maxX = fw == EnumFacing.EAST ? 1.125f : 0.125f));
                float f17 = fl == EnumFacing.NORTH ? -0.125f : (fl == EnumFacing.SOUTH ? 0.875f : (minZ = fw == EnumFacing.NORTH ? -0.125f : 0.875f));
                maxZ = fl == EnumFacing.SOUTH ? 1.25f : (fl == EnumFacing.NORTH ? 0.125f : (fw == EnumFacing.SOUTH ? 1.125f : 0.125f));
                list.add(new AxisAlignedBB((double)minX, 0.75, (double)minZ, (double)maxX, 1.0, (double)maxZ).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()));
            }
            return list;
        }
        if (this.field_174879_c == 13 || this.field_174879_c == 14 || this.field_174879_c == 16 || this.field_174879_c == 17) {
            float minZ;
            float maxX;
            float minX;
            ArrayList<AxisAlignedBB> list = new ArrayList<AxisAlignedBB>(3);
            if (this.field_174879_c % 9 > 5) {
                fl = fl.func_176734_d();
            }
            if (this.field_174879_c % 3 == 2) {
                fw = fw.func_176734_d();
            }
            float f = fl == EnumFacing.WEST ? 0.0f : (fl == EnumFacing.EAST ? 0.1875f : (minX = fw == EnumFacing.EAST ? 0.1875f : 0.0f));
            float f18 = fl == EnumFacing.EAST ? 1.0f : (fl == EnumFacing.WEST ? 0.8125f : (maxX = fw == EnumFacing.EAST ? 1.0f : 0.8125f));
            float f19 = fl == EnumFacing.NORTH ? 0.0f : (fl == EnumFacing.SOUTH ? 0.1875f : (minZ = fw == EnumFacing.SOUTH ? 0.1875f : 0.0f));
            float maxZ = fl == EnumFacing.SOUTH ? 1.0f : (fl == EnumFacing.NORTH ? 0.8125f : (fw == EnumFacing.SOUTH ? 1.0f : 0.8125f));
            list.add(new AxisAlignedBB((double)minX, -0.25, (double)minZ, (double)maxX, 0.0, (double)maxZ).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()));
            float f20 = fl == EnumFacing.WEST ? 0.0f : (fl == EnumFacing.EAST ? 0.0625f : (minX = fw == EnumFacing.EAST ? 0.0625f : 0.8125f));
            float f21 = fl == EnumFacing.EAST ? 1.0f : (fl == EnumFacing.WEST ? 0.9375f : (maxX = fw == EnumFacing.EAST ? 0.1875f : 0.9375f));
            float f22 = fl == EnumFacing.NORTH ? 0.0f : (fl == EnumFacing.SOUTH ? 0.0625f : (minZ = fw == EnumFacing.SOUTH ? 0.0625f : 0.8125f));
            maxZ = fl == EnumFacing.SOUTH ? 1.0f : (fl == EnumFacing.NORTH ? 0.9375f : (fw == EnumFacing.SOUTH ? 0.1875f : 0.9375f));
            list.add(new AxisAlignedBB((double)minX, 0.0, (double)minZ, (double)maxX, 1.0, (double)maxZ).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()));
            float f23 = fl == EnumFacing.WEST ? 0.8125f : (fl == EnumFacing.EAST ? 0.0625f : (minX = fw == EnumFacing.EAST ? 0.1875f : 0.0f));
            float f24 = fl == EnumFacing.EAST ? 0.1875f : (fl == EnumFacing.WEST ? 0.9375f : (maxX = fw == EnumFacing.EAST ? 1.0f : 0.8125f));
            float f25 = fl == EnumFacing.NORTH ? 0.8125f : (fl == EnumFacing.SOUTH ? 0.0625f : (minZ = fw == EnumFacing.SOUTH ? 0.1875f : 0.0f));
            maxZ = fl == EnumFacing.SOUTH ? 0.1875f : (fl == EnumFacing.NORTH ? 0.9375f : (fw == EnumFacing.SOUTH ? 1.0f : 0.8125f));
            list.add(new AxisAlignedBB((double)minX, 0.0, (double)minZ, (double)maxX, 1.0, (double)maxZ).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()));
            return list;
        }
        if (this.field_174879_c == 21) {
            float minZ;
            float maxX;
            float minX;
            ArrayList<AxisAlignedBB> list = new ArrayList<AxisAlignedBB>(1);
            float f = fl == EnumFacing.WEST ? 0.1875f : (fl == EnumFacing.EAST ? 0.3125f : (minX = fw == EnumFacing.EAST ? 0.1875f : 0.0f));
            float f26 = fl == EnumFacing.EAST ? 0.8125f : (fl == EnumFacing.WEST ? 0.6875f : (maxX = fw == EnumFacing.EAST ? 1.0f : 0.8125f));
            float f27 = fl == EnumFacing.NORTH ? 0.1875f : (fl == EnumFacing.SOUTH ? 0.3125f : (minZ = fw == EnumFacing.SOUTH ? 0.1875f : 0.0f));
            float maxZ = fl == EnumFacing.SOUTH ? 0.8125f : (fl == EnumFacing.NORTH ? 0.6875f : (fw == EnumFacing.SOUTH ? 1.0f : 0.8125f));
            list.add(new AxisAlignedBB((double)minX, 0.0, (double)minZ, (double)maxX, 0.625, (double)maxZ).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()));
            return list;
        }
        if (this.field_174879_c == 22) {
            float minZ;
            float maxX;
            float minX;
            ArrayList<AxisAlignedBB> list = new ArrayList<AxisAlignedBB>(2);
            float f = fl == EnumFacing.WEST ? -0.4375f : (fl == EnumFacing.EAST ? 0.5625f : (minX = fw == EnumFacing.EAST ? 0.5625f : -0.4375f));
            float f28 = fl == EnumFacing.EAST ? 1.4375f : (fl == EnumFacing.WEST ? 0.4375f : (maxX = fw == EnumFacing.EAST ? 1.4375f : 0.4375f));
            float f29 = fl == EnumFacing.NORTH ? -0.4375f : (fl == EnumFacing.SOUTH ? 0.5625f : (minZ = fw == EnumFacing.SOUTH ? 0.5625f : -0.4375f));
            float maxZ = fl == EnumFacing.SOUTH ? 1.4375f : (fl == EnumFacing.NORTH ? 0.4375f : (fw == EnumFacing.SOUTH ? 1.4375f : 0.4375f));
            list.add(new AxisAlignedBB((double)minX, 0.1875, (double)minZ, (double)maxX, 1.0, (double)maxZ).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()));
            float f30 = fl == EnumFacing.WEST ? 0.0f : (fl == EnumFacing.EAST ? 0.5f : (minX = fw == EnumFacing.EAST ? 0.0f : 0.4375f));
            float f31 = fl == EnumFacing.EAST ? 1.0f : (fl == EnumFacing.WEST ? 0.5f : (maxX = fw == EnumFacing.EAST ? 0.5625f : 1.0f));
            float f32 = fl == EnumFacing.NORTH ? 0.0f : (fl == EnumFacing.SOUTH ? 0.5f : (minZ = fw == EnumFacing.SOUTH ? 0.0f : 0.4375f));
            maxZ = fl == EnumFacing.SOUTH ? 1.0f : (fl == EnumFacing.NORTH ? 0.5f : (fw == EnumFacing.SOUTH ? 0.5625f : 1.0f));
            list.add(new AxisAlignedBB((double)minX, 0.0, (double)minZ, (double)maxX, 0.875, (double)maxZ).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()));
            return list;
        }
        return null;
    }

    @Override
    public boolean isOverrideBox(AxisAlignedBB box, EntityPlayer player, RayTraceResult mop, ArrayList<AxisAlignedBB> list) {
        return false;
    }

    @Override
    public List<AxisAlignedBB> getAdvancedColisionBounds() {
        return this.getAdvancedSelectionBounds();
    }

    @Override
    public int[] getEnergyPos() {
        return new int[]{9};
    }

    @Override
    public int[] getRedstonePos() {
        return new int[]{11};
    }

    @Override
    public boolean isInWorldProcessingMachine() {
        return false;
    }

    @Override
    public boolean additionalCanProcessCheck(TileEntityMultiblockMetal.MultiblockProcess<MixerRecipe> process) {
        return true;
    }

    @Override
    public void doProcessOutput(ItemStack output) {
        BlockPos pos = this.func_174877_v().func_177967_a(this.facing, 2);
        TileEntity inventoryTile = this.field_145850_b.func_175625_s(pos);
        if (inventoryTile != null) {
            output = Utils.insertStackIntoInventory(inventoryTile, output, this.facing.func_176734_d());
        }
        if (!output.func_190926_b()) {
            Utils.dropStackAtPos(this.field_145850_b, pos, output, this.facing);
        }
    }

    @Override
    public void doProcessFluidOutput(FluidStack output) {
    }

    @Override
    public void onProcessFinish(TileEntityMultiblockMetal.MultiblockProcess<MixerRecipe> process) {
    }

    @Override
    public int getMaxProcessPerTick() {
        return 8;
    }

    @Override
    public int getProcessQueueMaxLength() {
        return 8;
    }

    @Override
    public float getMinProcessDistance(TileEntityMultiblockMetal.MultiblockProcess<MixerRecipe> process) {
        return 0.0f;
    }

    @Override
    public NonNullList<ItemStack> getInventory() {
        return this.inventory;
    }

    @Override
    public boolean isStackValid(int slot, ItemStack stack) {
        return true;
    }

    @Override
    public int getSlotLimit(int slot) {
        return 64;
    }

    @Override
    public int[] getOutputSlots() {
        return new int[0];
    }

    @Override
    public int[] getOutputTanks() {
        return new int[]{0};
    }

    @Override
    public IFluidTank[] getInternalTanks() {
        return new IFluidTank[]{this.tank};
    }

    @Override
    protected IFluidTank[] getAccessibleFluidTanks(EnumFacing side) {
        TileEntityMixer master = (TileEntityMixer)this.master();
        if (master != null && (this.field_174879_c == 1 && (side == null || side == this.facing.func_176734_d()) || this.field_174879_c == 3 && (side == null || side == (this.mirrored ? this.facing.func_176746_e() : this.facing.func_176735_f())))) {
            return master.getInternalTanks();
        }
        return new FluidTank[0];
    }

    @Override
    protected boolean canFillTankFrom(int iTank, EnumFacing side, FluidStack resources) {
        return side == null || side == (this.mirrored ? this.facing.func_176746_e() : this.facing.func_176735_f());
    }

    @Override
    protected boolean canDrainTankFrom(int iTank, EnumFacing side) {
        return side == null || side == this.facing.func_176734_d();
    }

    @Override
    public void doGraphicalUpdates(int slot) {
        this.func_70296_d();
        this.markContainingBlockForUpdate(null);
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if ((facing == null || this.field_174879_c == 16) && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.master() != null;
        }
        return super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if ((facing == null || this.field_174879_c == 16) && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            TileEntityMixer master = (TileEntityMixer)this.master();
            if (master != null) {
                return (T)master.insertionHandler;
            }
            return null;
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public MixerRecipe findRecipeForInsertion(ItemStack inserting) {
        return null;
    }

    @Override
    protected MixerRecipe readRecipeFromNBT(NBTTagCompound tag) {
        return MixerRecipe.loadFromNBT(tag);
    }

    @Override
    protected TileEntityMultiblockMetal.MultiblockProcess loadProcessFromNBT(NBTTagCompound tag) {
        MixerRecipe recipe = this.readRecipeFromNBT(tag);
        if (recipe != null && recipe instanceof MixerRecipe) {
            return new MultiblockProcessMixer(recipe, tag.func_74759_k("process_inputSlots")).setInputTanks(tag.func_74759_k("process_inputTanks"));
        }
        return null;
    }

    @Override
    public boolean canOpenGui() {
        return this.formed;
    }

    @Override
    public int getGuiID() {
        return 12;
    }

    @Override
    public TileEntity getGuiMaster() {
        return this.master();
    }

    public static class MultiblockProcessMixer
    extends TileEntityMultiblockMetal.MultiblockProcessInMachine<MixerRecipe> {
        public MultiblockProcessMixer(MixerRecipe recipe, int ... inputSlots) {
            super(recipe, inputSlots);
        }

        @Override
        protected List<FluidStack> getRecipeFluidOutputs(TileEntityMultiblockMetal multiblock) {
            return Collections.emptyList();
        }

        @Override
        protected List<FluidStack> getRecipeFluidInputs(TileEntityMultiblockMetal multiblock) {
            return Collections.emptyList();
        }

        @Override
        public boolean canProcess(TileEntityMultiblockMetal multiblock) {
            if (!(multiblock instanceof TileEntityMixer)) {
                return false;
            }
            TileEntityMixer mixer = (TileEntityMixer)multiblock;
            return mixer.energyStorage.extractEnergy(this.energyPerTick, true) == this.energyPerTick && mixer.tank.drain(Utils.copyFluidStackWithAmount(((MixerRecipe)this.recipe).fluidInput, 1, false), false) != null;
        }

        @Override
        public void doProcessTick(TileEntityMultiblockMetal multiblock) {
            int timerStep = this.maxTicks / ((MixerRecipe)this.recipe).fluidAmount;
            if (this.processTick % timerStep == 0) {
                FluidStack drained = ((TileEntityMixer)multiblock).tank.drain(Utils.copyFluidStackWithAmount(((MixerRecipe)this.recipe).fluidInput, 1, false), true);
                NonNullList components = NonNullList.func_191197_a((int)this.inputSlots.length, (Object)ItemStack.field_190927_a);
                for (int i = 0; i < components.size(); ++i) {
                    components.set(i, multiblock.getInventory().get(this.inputSlots[i]));
                }
                FluidStack output = ((MixerRecipe)this.recipe).getFluidOutput(drained, (NonNullList<ItemStack>)components);
                FluidStack fs = Utils.copyFluidStackWithAmount(output, 1, false);
                ((TileEntityMixer)multiblock).tank.fill(fs, true);
            }
            super.doProcessTick(multiblock);
        }

        @Override
        protected void processFinish(TileEntityMultiblockMetal multiblock) {
            super.processFinish(multiblock);
            if (this.recipe instanceof MixerRecipePotion) {
                for (int i : this.inputSlots) {
                    if (((ItemStack)multiblock.getInventory().get(i)).func_190926_b() || !PotionHelper.func_185205_a((ItemStack)((ItemStack)multiblock.getInventory().get(i)))) continue;
                    ((ItemStack)multiblock.getInventory().get(i)).func_190918_g(1);
                    if (((ItemStack)multiblock.getInventory().get(i)).func_190916_E() > 0) continue;
                    multiblock.getInventory().set(i, (Object)ItemStack.field_190927_a);
                }
            }
        }
    }
}

