/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.book;

import com.buuz135.industrial.api.book.CategoryEntry;
import com.buuz135.industrial.api.book.IBookCategory;
import com.buuz135.industrial.api.book.button.ItemStackButton;
import com.buuz135.industrial.api.book.button.TextureButton;
import com.buuz135.industrial.api.book.gui.GUIBookBase;
import com.buuz135.industrial.api.book.gui.GUIBookCategoryEntries;
import com.buuz135.industrial.api.book.gui.GUIBookPage;
import com.buuz135.industrial.book.BookCategory;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import net.minecraft.block.Block;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class GUIBookMain
extends GUIBookBase {
    private HashMap<ItemStackButton, IBookCategory> categoriesButtons = new LinkedHashMap<ItemStackButton, IBookCategory>();
    private GuiButton searchButton;
    private Block block;

    public GUIBookMain(World world, int x, int y, int z) {
        super(null, null);
        BlockPos pos = new BlockPos(x, y, z);
        if (world.func_180495_p(pos).func_177230_c().getRegistryName().func_110624_b().equals("industrialforegoing")) {
            this.block = world.func_180495_p(pos).func_177230_c();
        }
    }

    public static ItemStack getCategoryItemStack(IBookCategory category) {
        if (category.getEntries().isEmpty()) {
            return new ItemStack(Blocks.field_180401_cv);
        }
        if (!category.getDisplay().func_190926_b()) {
            category.getDisplay();
        }
        for (CategoryEntry entry : category.getEntries().values()) {
            if (entry.getDisplay().func_190926_b()) continue;
            return entry.getDisplay();
        }
        return new ItemStack(Blocks.field_180401_cv);
    }

    @Override
    public boolean hasPageLeft() {
        return false;
    }

    @Override
    public boolean hasPageRight() {
        return false;
    }

    @Override
    public boolean hasBackButton() {
        return false;
    }

    @Override
    public boolean hasSearchBar() {
        return false;
    }

    @Override
    public void drawScreenFront(int mouseX, int mouseY, float partialTicks) {
        super.drawScreenFront(mouseX, mouseY, partialTicks);
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        if (this.block != null) {
            for (BookCategory bookCategory : BookCategory.values()) {
                for (ResourceLocation entry : bookCategory.getEntries().keySet()) {
                    CategoryEntry categoryEntry = bookCategory.getEntries().get(entry);
                    if (!categoryEntry.getDisplay().func_77969_a(new ItemStack(this.block))) continue;
                    this.field_146297_k.func_147108_a((GuiScreen)new GUIBookPage(this, this, categoryEntry));
                    return;
                }
            }
        } else {
            int i = 0;
            int renderScale = (this.getGuiXSize() - 40) / 3;
            for (BookCategory category : BookCategory.values()) {
                ItemStackButton button = new ItemStackButton(-235 - i, 21 + this.getGuiLeft() + i % 3 * renderScale, 15 + this.getGuiTop() + i / 3 * (renderScale + 4), renderScale, renderScale, category.getName(), GUIBookMain.getCategoryItemStack(category));
                this.field_146292_n.add(button);
                this.categoriesButtons.put(button, category);
                ++i;
            }
            this.searchButton = new TextureButton(-135, this.getGuiLeft() - 5, this.getGuiTop() + 2, 18, 10, BOOK_EXTRAS, 1, 27, "Search");
            this.field_146292_n.add(this.searchButton);
        }
    }

    @Override
    public void onBackButton() {
        this.field_146297_k.func_147108_a((GuiScreen)new GUIBookBase(this, this){

            @Override
            public boolean hasSearchBar() {
                return true;
            }

            @Override
            public boolean hasPageRight() {
                return true;
            }

            @Override
            public void onRightButton() {
                this.onBackButton();
            }
        });
    }

    @Override
    protected void func_146284_a(GuiButton button) throws IOException {
        if (this.categoriesButtons.containsKey(button)) {
            if (this.categoriesButtons.get(button).getEntries().isEmpty()) {
                return;
            }
            this.field_146297_k.func_147108_a((GuiScreen)new GUIBookCategoryEntries(this, this, this.categoriesButtons.get(button)));
        } else if (button == this.searchButton) {
            this.onBackButton();
        } else {
            super.func_146284_a(button);
        }
    }
}

