/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.proxy.block;

import com.buuz135.industrial.IndustrialForegoing;
import com.buuz135.industrial.proxy.ItemRegistry;
import com.buuz135.industrial.proxy.block.BlockBase;
import com.buuz135.industrial.proxy.block.TileEntityConveyor;
import com.buuz135.industrial.utils.RecipeUtils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.lang3.text.WordUtils;

public class BlockConveyor
extends BlockBase {
    public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;
    public static final PropertyEnum<EnumType> TYPE = PropertyEnum.func_177709_a((String)"type", EnumType.class);
    public static final PropertyEnum<EnumSides> SIDES = PropertyEnum.func_177709_a((String)"sides", EnumSides.class);
    private ConveyorItem item;

    public BlockConveyor() {
        super("conveyor");
        this.func_180632_j(this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH).func_177226_a(SIDES, (Comparable)((Object)EnumSides.NONE)));
        this.item = new ConveyorItem(this);
        this.func_149647_a(IndustrialForegoing.creativeTab);
        this.func_149711_c(2.0f);
    }

    @Override
    public void registerItem(IForgeRegistry<Item> items) {
        items.register((IForgeRegistryEntry)this.item);
    }

    @Override
    public void registerRender() {
        for (int i = 0; i < EnumDyeColor.values().length; ++i) {
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)i, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory"));
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void createRecipe() {
        RecipeUtils.addShapedRecipe(new ItemStack((Block)this, 4, 0), new Object[]{"ppp", "iri", "ppp", Character.valueOf('p'), ItemRegistry.plastic, Character.valueOf('i'), "ingotIron", Character.valueOf('r'), Items.field_151137_ax});
        for (EnumDyeColor color : EnumDyeColor.values()) {
            RecipeUtils.addShapedRecipe(new ItemStack((Block)this, 8, color.func_176765_a()), "_" + color.toString().toLowerCase(), new HashMap<String, Object>(), "ccc", "cdc", "ccc", Character.valueOf('c'), new ItemStack((Block)this, 1, Short.MAX_VALUE), Character.valueOf('d'), "dye" + WordUtils.capitalize((String)color.func_192396_c()));
        }
    }

    public int func_176201_c(IBlockState state) {
        return Arrays.asList(EnumFacing.values()).indexOf(state.func_177229_b((IProperty)FACING));
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.values()[meta]);
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileEntityConveyor) {
            return new ItemStack((Block)this, 1, 15 - ((TileEntityConveyor)tileEntity).getColor());
        }
        return super.getPickBlock(state, target, world, pos, player);
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (tileEntity instanceof TileEntityConveyor) {
            state = state.func_177226_a((IProperty)FACING, (Comparable)((TileEntityConveyor)tileEntity).getFacing()).func_177226_a(TYPE, (Comparable)((Object)((TileEntityConveyor)tileEntity).getType()));
        }
        if (((EnumType)((Object)state.func_177229_b(TYPE))).equals((Object)EnumType.FLAT) || ((EnumType)((Object)state.func_177229_b(TYPE))).equals((Object)EnumType.FLAT_FAST)) {
            EnumFacing right = ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176746_e();
            EnumFacing left = ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176735_f();
            state = this.isConveyorAndFacing(pos.func_177972_a(right), worldIn, left) && this.isConveyorAndFacing(pos.func_177972_a(left), worldIn, right) || this.isConveyorAndFacing(pos.func_177972_a(right).func_177977_b(), worldIn, left) && this.isConveyorAndFacing(pos.func_177972_a(left).func_177977_b(), worldIn, right) ? state.func_177226_a(SIDES, (Comparable)((Object)EnumSides.BOTH)) : (this.isConveyorAndFacing(pos.func_177972_a(right), worldIn, left) || this.isConveyorAndFacing(pos.func_177972_a(right).func_177977_b(), worldIn, left) ? state.func_177226_a(SIDES, (Comparable)((Object)EnumSides.RIGHT)) : (this.isConveyorAndFacing(pos.func_177972_a(left), worldIn, right) || this.isConveyorAndFacing(pos.func_177972_a(left).func_177977_b(), worldIn, right) ? state.func_177226_a(SIDES, (Comparable)((Object)EnumSides.LEFT)) : state.func_177226_a(SIDES, (Comparable)((Object)EnumSides.NONE))));
        }
        return state;
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean isActualState) {
        TileEntity entity = worldIn.func_175625_s(pos);
        if (entity instanceof TileEntityConveyor) {
            if (!((TileEntityConveyor)entity).getType().isVertical()) {
                super.func_185477_a(state, worldIn, pos, entityBox, collidingBoxes, entityIn, isActualState);
                return;
            }
            ((TileEntityConveyor)entity).getCollisionBoxes().forEach(axisAlignedBB -> BlockConveyor.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, (List)collidingBoxes, (AxisAlignedBB)axisAlignedBB));
        }
    }

    private boolean isConveyorAndFacing(BlockPos pos, IBlockAccess world, EnumFacing toFace) {
        return world.func_180495_p(pos).func_177230_c() instanceof BlockConveyor && (toFace == null || ((EnumFacing)world.func_180495_p(pos).func_177229_b((IProperty)FACING)).equals((Object)toFace));
    }

    public void func_149666_a(CreativeTabs itemIn, NonNullList<ItemStack> items) {
        for (int i = 0; i < EnumDyeColor.values().length; ++i) {
            items.add((Object)new ItemStack((Block)this, 1, i));
        }
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        super.func_180650_b(worldIn, pos, state, rand);
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        if (worldIn.func_180495_p(pos.func_177977_b()).func_177230_c() instanceof BlockConveyor) {
            return false;
        }
        return super.func_176196_c(worldIn, pos);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, SIDES, TYPE});
    }

    public boolean func_149716_u() {
        return true;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.func_180633_a(worldIn, pos, state, placer, stack);
        TileEntity tileEntity = this.createTileEntity(worldIn, state);
        worldIn.func_175690_a(pos, tileEntity);
        EnumFacing direction = placer.func_174811_aO();
        ((TileEntityConveyor)tileEntity).setFacing(direction);
        ((TileEntityConveyor)tileEntity).setColor(EnumDyeColor.values()[stack.func_77960_j()]);
        this.updateConveyorPlacing(worldIn, pos, state, true);
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        NonNullList list = NonNullList.func_191196_a();
        this.getDrops((NonNullList<ItemStack>)list, (IBlockAccess)world, pos, state, 0);
        for (ItemStack stack : list) {
            float f = 0.7f;
            float d0 = world.field_73012_v.nextFloat() * f + (1.0f - f) * 0.5f;
            float d1 = world.field_73012_v.nextFloat() * f + (1.0f - f) * 0.5f;
            float d2 = world.field_73012_v.nextFloat() * f + (1.0f - f) * 0.5f;
            EntityItem entityitem = new EntityItem(world, (double)((float)pos.func_177958_n() + d0), (double)((float)pos.func_177956_o() + d1), (double)((float)pos.func_177952_p() + d2), stack);
            world.func_72838_d((Entity)entityitem);
        }
        super.func_180663_b(world, pos, state);
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        TileEntity entity = world.func_175625_s(pos);
        if (entity instanceof TileEntityConveyor) {
            drops.add((Object)new ItemStack((Block)this, 1, EnumDyeColor.func_176766_a((int)((TileEntityConveyor)entity).getColor()).func_176765_a()));
            if (((TileEntityConveyor)entity).getType().isFast()) {
                drops.add((Object)new ItemStack(Items.field_151114_aO, 1));
            }
        }
    }

    private void updateConveyorPlacing(World worldIn, BlockPos pos, IBlockState state, boolean first) {
        TileEntity entity = worldIn.func_175625_s(pos);
        if (entity instanceof TileEntityConveyor) {
            EnumFacing direction = ((TileEntityConveyor)entity).getFacing();
            EnumFacing right = ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176746_e();
            EnumFacing left = ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176735_f();
            if (this.isConveyorAndFacing(pos.func_177984_a().func_177972_a(direction), (IBlockAccess)worldIn, null)) {
                ((TileEntityConveyor)entity).setType(((TileEntityConveyor)entity).getType().getVertical(EnumFacing.UP));
            } else if (this.isConveyorAndFacing(pos.func_177984_a().func_177972_a(direction.func_176734_d()), (IBlockAccess)worldIn, null)) {
                ((TileEntityConveyor)entity).setType(((TileEntityConveyor)entity).getType().getVertical(EnumFacing.DOWN));
            }
            if (!first) {
                return;
            }
            if (this.isConveyorAndFacing(pos.func_177972_a(direction.func_176734_d()).func_177977_b(), (IBlockAccess)worldIn, direction)) {
                this.updateConveyorPlacing(worldIn, pos.func_177972_a(direction.func_176734_d()).func_177977_b(), state, false);
            }
            if (this.isConveyorAndFacing(pos.func_177972_a(left).func_177977_b(), (IBlockAccess)worldIn, right)) {
                this.updateConveyorPlacing(worldIn, pos.func_177972_a(left).func_177977_b(), state, false);
            }
            if (this.isConveyorAndFacing(pos.func_177972_a(right).func_177977_b(), (IBlockAccess)worldIn, left)) {
                this.updateConveyorPlacing(worldIn, pos.func_177972_a(right).func_177977_b(), state, false);
            }
            if (this.isConveyorAndFacing(pos.func_177972_a(direction).func_177977_b(), (IBlockAccess)worldIn, direction)) {
                this.updateConveyorPlacing(worldIn, pos.func_177972_a(direction).func_177977_b(), state, false);
            }
            worldIn.func_184138_a(pos, state, state, 3);
        }
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        ItemStack handStack = playerIn.func_184586_b(hand);
        if (tileEntity instanceof TileEntityConveyor && handStack.func_77973_b().equals(Items.field_151114_aO) && !((TileEntityConveyor)tileEntity).getType().isFast()) {
            ((TileEntityConveyor)tileEntity).setType(((TileEntityConveyor)tileEntity).getType().getFast());
            handStack.func_190918_g(1);
            return true;
        }
        return super.func_180639_a(worldIn, pos, state, playerIn, hand, facing, hitX, hitY, hitZ);
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        TileEntityConveyor tile = new TileEntityConveyor();
        tile.func_145834_a(world);
        return tile;
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO());
    }

    @Override
    public void registerBlock(IForgeRegistry<Block> blocks) {
        super.registerBlock(blocks);
        GameRegistry.registerTileEntity(TileEntityConveyor.class, (String)"conveyor_tile");
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        TileEntity entity = source.func_175625_s(pos);
        if (entity instanceof TileEntityConveyor) {
            if (((TileEntityConveyor)entity).getType().isVertical()) {
                return new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.4, 1.0);
            }
            return new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.0625, 1.0);
        }
        return field_185505_j;
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
        TileEntity entity = worldIn.func_175625_s(pos);
        if (entity instanceof TileEntityConveyor) {
            ((TileEntityConveyor)entity).handleEntityMovement(entityIn);
        }
    }

    public boolean canCreatureSpawn(IBlockState state, IBlockAccess world, BlockPos pos, EntityLiving.SpawnPlacementType type) {
        return true;
    }

    public boolean func_181623_g() {
        return true;
    }

    public boolean func_189872_a(IBlockState state, Entity entityIn) {
        return true;
    }

    public ConveyorItem getItem() {
        return this.item;
    }

    private class ConveyorItem
    extends ItemBlock {
        public ConveyorItem(Block block) {
            super(block);
            this.setRegistryName(block.getRegistryName());
            this.func_77627_a(true);
            this.func_77637_a(IndustrialForegoing.creativeTab);
        }

        public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
            if (this.func_194125_a(tab)) {
                for (int i = 0; i < EnumDyeColor.values().length; ++i) {
                    items.add((Object)new ItemStack((Item)this, 1, i));
                }
            }
        }

        public String func_77653_i(ItemStack stack) {
            return new TextComponentTranslation("item.fireworksCharge." + EnumDyeColor.func_176764_b((int)stack.func_77960_j()).func_176762_d().replaceAll("_", ""), new Object[0]).func_150254_d() + " " + super.func_77653_i(stack);
        }
    }

    public static enum EnumSides implements IStringSerializable
    {
        NONE,
        LEFT,
        RIGHT,
        BOTH;


        public String func_176610_l() {
            return this.toString().toLowerCase();
        }
    }

    public static enum EnumType implements IStringSerializable
    {
        FLAT(false),
        UP(false),
        DOWN(false),
        FLAT_FAST(true),
        UP_FAST(true),
        DOWN_FAST(true);

        private boolean fast;

        private EnumType(boolean fast) {
            this.fast = fast;
        }

        public boolean isFast() {
            return this.fast;
        }

        public EnumType getFast() {
            switch (this) {
                case FLAT: {
                    return FLAT_FAST;
                }
                case UP: {
                    return UP_FAST;
                }
                case DOWN: {
                    return DOWN_FAST;
                }
            }
            return this;
        }

        public EnumType getVertical(EnumFacing facing) {
            if (this.isFast()) {
                if (facing == EnumFacing.UP) {
                    return UP_FAST;
                }
                if (facing == EnumFacing.DOWN) {
                    return DOWN_FAST;
                }
                return FLAT_FAST;
            }
            if (facing == EnumFacing.UP) {
                return UP;
            }
            if (facing == EnumFacing.DOWN) {
                return DOWN;
            }
            return FLAT_FAST;
        }

        public boolean isVertical() {
            return this.isDown() || this.isUp();
        }

        public boolean isUp() {
            return this.equals((Object)UP) || this.equals((Object)UP_FAST);
        }

        public boolean isDown() {
            return this.equals((Object)DOWN) || this.equals((Object)DOWN_FAST);
        }

        public String func_176610_l() {
            return this.toString().toLowerCase();
        }
    }
}

