/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.proxy.block;

import com.buuz135.industrial.proxy.block.BlockConveyor;
import com.buuz135.industrial.utils.MovementUtils;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class TileEntityConveyor
extends TileEntity {
    private EnumFacing facing = EnumFacing.NORTH;
    private BlockConveyor.EnumType type = BlockConveyor.EnumType.FLAT;
    private int color = 0;

    public EnumFacing getFacing() {
        return this.facing;
    }

    public void setFacing(EnumFacing facing) {
        this.facing = facing;
        this.markForUpdate();
    }

    public BlockConveyor.EnumType getType() {
        return this.type;
    }

    public void setType(BlockConveyor.EnumType type) {
        this.type = type;
        this.markForUpdate();
    }

    public int getColor() {
        return this.color;
    }

    public void setColor(int color) {
        this.color = color;
        this.markForUpdate();
    }

    public void setColor(EnumDyeColor color) {
        this.color = color.func_176767_b();
        this.markForUpdate();
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound = super.func_189515_b(compound);
        compound.func_74778_a("Facing", this.facing.func_176610_l());
        compound.func_74778_a("Type", this.type.func_176610_l());
        compound.func_74768_a("Color", this.color);
        return compound;
    }

    protected void func_190201_b(World worldIn) {
        super.func_190201_b(worldIn);
        this.field_145850_b = worldIn;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.facing = EnumFacing.valueOf((String)compound.func_74779_i("Facing").toUpperCase());
        this.type = BlockConveyor.EnumType.valueOf(compound.func_74779_i("Type").toUpperCase());
        this.color = compound.func_74762_e("Color");
    }

    public void markForUpdate() {
        this.field_145850_b.func_175656_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c).func_177226_a(BlockConveyor.TYPE, (Comparable)((Object)this.type)).func_177226_a((IProperty)BlockConveyor.FACING, (Comparable)this.facing));
        this.field_145850_b.func_184138_a(this.func_174877_v(), this.func_145831_w().func_180495_p(this.func_174877_v()), this.func_145831_w().func_180495_p(this.func_174877_v()), 3);
        this.func_70296_d();
    }

    public List<AxisAlignedBB> getCollisionBoxes() {
        ArrayList<AxisAlignedBB> boxes = new ArrayList<AxisAlignedBB>();
        EnumFacing facing = this.facing;
        if (this.type.isDown()) {
            facing = facing.func_176734_d();
        }
        for (double height = 1.0; height > 0.0; height -= 0.1) {
            if (facing == EnumFacing.NORTH || facing == EnumFacing.SOUTH) {
                boxes.add(new AxisAlignedBB(0.0, 0.0, facing == EnumFacing.NORTH ? 0.0 : 1.0 - height, 1.0, 1.0 - height, facing == EnumFacing.NORTH ? height : 1.0));
            }
            if (facing != EnumFacing.WEST && facing != EnumFacing.EAST) continue;
            boxes.add(new AxisAlignedBB(facing == EnumFacing.WEST ? 0.0 : 1.0 - height, 0.0, 0.0, facing == EnumFacing.WEST ? height : 1.0, 1.0 - height, 1.0));
        }
        return boxes;
    }

    public void handleEntityMovement(Entity entity) {
        MovementUtils.handleConveyorMovement(entity, this.facing, this.field_174879_c, this.type);
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return false;
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound tag = new NBTTagCompound();
        this.func_189515_b(tag);
        return new SPacketUpdateTileEntity(this.func_174877_v(), 1, tag);
    }
}

