/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.tile.block;

import com.buuz135.industrial.book.BookCategory;
import com.buuz135.industrial.proxy.ItemRegistry;
import com.buuz135.industrial.tile.block.CustomOrientedBlock;
import com.buuz135.industrial.tile.misc.BlackHoleTankTile;
import com.buuz135.industrial.utils.RecipeUtils;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.ndrei.teslacorelib.items.MachineCaseItem;
import org.jetbrains.annotations.Nullable;

public class BlackHoleTankBlock
extends CustomOrientedBlock<BlackHoleTankTile> {
    public BlackHoleTankBlock() {
        super("black_hole_tank", BlackHoleTankTile.class);
    }

    @Override
    public void createRecipe() {
        RecipeUtils.addShapedRecipe(new ItemStack((Block)this), new Object[]{"ppp", "eae", "cmc", Character.valueOf('p'), ItemRegistry.plastic, Character.valueOf('e'), Items.field_151061_bv, Character.valueOf('a'), Items.field_151079_bi, Character.valueOf('c'), Items.field_151133_ar, Character.valueOf('m'), MachineCaseItem.INSTANCE});
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        if (world.func_175625_s(pos) instanceof BlackHoleTankTile) {
            BlackHoleTankTile tile = (BlackHoleTankTile)world.func_175625_s(pos);
            ItemStack stack = new ItemStack(Item.func_150898_a((Block)this), 1);
            if (tile.getAmount() > 0) {
                if (!stack.func_77942_o()) {
                    stack.func_77982_d(new NBTTagCompound());
                }
                if (tile.getTank().getFluid() != null) {
                    stack.func_77982_d(tile.getTank().getFluid().writeToNBT(new NBTTagCompound()));
                }
            }
            float f = 0.7f;
            float d0 = world.field_73012_v.nextFloat() * f + (1.0f - f) * 0.5f;
            float d1 = world.field_73012_v.nextFloat() * f + (1.0f - f) * 0.5f;
            float d2 = world.field_73012_v.nextFloat() * f + (1.0f - f) * 0.5f;
            EntityItem entityitem = new EntityItem(world, (double)((float)pos.func_177958_n() + d0), (double)((float)pos.func_177956_o() + d1), (double)((float)pos.func_177952_p() + d2), stack);
            entityitem.func_174869_p();
            if (stack.func_77942_o()) {
                entityitem.func_92059_d().func_77982_d(stack.func_77978_p().func_74737_b());
            }
            world.func_72838_d((Entity)entityitem);
        }
        super.func_180663_b(world, pos, state);
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        return Arrays.asList(new ItemStack[0]);
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.func_180633_a(world, pos, state, placer, stack);
        if (stack.func_77942_o() && world.func_175625_s(pos) != null && world.func_175625_s(pos) instanceof BlackHoleTankTile && FluidRegistry.isFluidRegistered((String)stack.func_77978_p().func_74779_i("FluidName"))) {
            BlackHoleTankTile tile = (BlackHoleTankTile)world.func_175625_s(pos);
            tile.getTank().fill(new FluidStack(FluidRegistry.getFluid((String)stack.func_77978_p().func_74779_i("FluidName")), stack.func_77978_p().func_74762_e("Amount")), true);
        }
    }

    @Override
    public List<String> getTooltip(ItemStack stack) {
        List<String> tooltip = super.getTooltip(stack);
        if (stack.func_77942_o() && FluidRegistry.isFluidRegistered((String)stack.func_77978_p().func_74779_i("FluidName"))) {
            tooltip.add(new TextComponentTranslation("text.industrialforegoing.display.fluid", new Object[0]).func_150260_c() + " " + new TextComponentTranslation(FluidRegistry.getFluid((String)stack.func_77978_p().func_74779_i("FluidName")).getUnlocalizedName(), new Object[0]).func_150260_c());
            tooltip.add(new TextComponentTranslation("text.industrialforegoing.display.amount", new Object[0]).func_150260_c() + " " + stack.func_77978_p().func_74762_e("Amount"));
        }
        return tooltip;
    }

    @Override
    public BookCategory getCategory() {
        return BookCategory.STORAGE;
    }

    public boolean func_180639_a(@Nullable World worldIn, @Nullable BlockPos pos, @Nullable IBlockState state, @Nullable EntityPlayer playerIn, @Nullable EnumHand hand, @Nullable EnumFacing facing, float hitX, float hitY, float hitZ) {
        BlackHoleTankTile tile;
        FluidActionResult result;
        ItemStack stack;
        if (playerIn != null && hand != null && worldIn != null && pos != null && !(stack = playerIn.func_184586_b(hand)).func_190926_b() && stack.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null) && worldIn.func_175625_s(pos) instanceof BlackHoleTankTile && (result = FluidUtil.tryFillContainer((ItemStack)stack, (IFluidHandler)((IFluidHandler)(tile = (BlackHoleTankTile)worldIn.func_175625_s(pos)).getTank()), (int)Integer.MAX_VALUE, (EntityPlayer)playerIn, (boolean)true)).isSuccess()) {
            stack.func_190918_g(1);
            if (stack.func_190926_b()) {
                playerIn.func_184611_a(hand, result.result);
            } else {
                playerIn.func_191521_c(result.result);
            }
            return true;
        }
        return super.func_180639_a(worldIn, pos, state, playerIn, hand, facing, hitX, hitY, hitZ);
    }
}

