/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.tile.block;

import com.buuz135.industrial.IndustrialForegoing;
import com.buuz135.industrial.api.book.IPage;
import com.buuz135.industrial.api.book.page.PageRecipe;
import com.buuz135.industrial.api.book.page.PageText;
import com.buuz135.industrial.book.IHasBookDescription;
import com.buuz135.industrial.config.CustomConfiguration;
import com.buuz135.industrial.tile.block.IHasAdvancedTooltip;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.ndrei.teslacorelib.blocks.OrientedBlock;
import net.ndrei.teslacorelib.tileentities.SidedTileEntity;

public abstract class CustomOrientedBlock<T extends SidedTileEntity>
extends OrientedBlock
implements IHasBookDescription,
IHasAdvancedTooltip {
    public static List<CustomOrientedBlock> blockList = new ArrayList<CustomOrientedBlock>();
    private boolean workDisabled;
    private boolean enabled;
    private int energyForWork;
    private int energyRate;

    protected CustomOrientedBlock(String registryName, Class<T> teClass) {
        super("industrialforegoing", IndustrialForegoing.creativeTab, registryName, teClass);
        blockList.add(this);
    }

    protected CustomOrientedBlock(String registryName, Class teClass, Material material, int energyForWork, int energyRate) {
        super("industrialforegoing", IndustrialForegoing.creativeTab, registryName, teClass, material);
        this.energyForWork = energyForWork;
        this.energyRate = energyRate;
        blockList.add(this);
    }

    public void getMachineConfig() {
        this.enabled = CustomConfiguration.config.getBoolean("enabled", "machines." + this.getRegistryName().func_110623_a().toString(), true, "If disabled it will be removed from the game.");
        this.workDisabled = CustomConfiguration.config.getBoolean("workDisabled", "machines." + this.getRegistryName().func_110623_a().toString(), false, "Machine can perform a work action");
        if (this.energyForWork != 0 && this.energyRate != 0) {
            this.energyForWork = CustomConfiguration.config.getInt("energyForWork", "machines." + this.getRegistryName().func_110623_a().toString(), this.energyForWork, 1, Integer.MAX_VALUE, "How much energy needs a machine to work");
            this.energyRate = CustomConfiguration.config.getInt("energyRate", "machines." + this.getRegistryName().func_110623_a().toString(), this.energyRate, 1, Integer.MAX_VALUE, "Energy input rate of a machine");
        }
    }

    public boolean isWorkDisabled() {
        return this.workDisabled;
    }

    public int getEnergyForWork() {
        return this.energyForWork;
    }

    public int getEnergyRate() {
        return this.energyRate;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public abstract void createRecipe();

    @Override
    public List<IPage> getBookDescriptionPages() {
        ArrayList<IPage> pages = new ArrayList<IPage>();
        pages.addAll(PageText.createTranslatedPages("text.industrialforegoing.book." + this.getRegistryName().func_110623_a(), new String[0]));
        if (ForgeRegistries.RECIPES.getValue(this.getRegistryName()) != null) {
            pages.add(new PageRecipe(this.getRegistryName()));
        }
        return pages;
    }

    @Override
    public List<String> getTooltip(ItemStack stack) {
        ArrayList<String> tooltips = new ArrayList<String>();
        return tooltips;
    }
}

