/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.tile.mob;

import com.buuz135.industrial.item.MobImprisonmentToolItem;
import com.buuz135.industrial.proxy.BlockRegistry;
import com.buuz135.industrial.proxy.FluidsRegistry;
import com.buuz135.industrial.proxy.ItemRegistry;
import com.buuz135.industrial.proxy.client.ClientProxy;
import com.buuz135.industrial.tile.CustomColoredItemHandler;
import com.buuz135.industrial.tile.WorkingAreaElectricMachine;
import com.buuz135.industrial.utils.BlockUtils;
import com.buuz135.industrial.utils.WorkUtils;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.ndrei.teslacorelib.TeslaCoreLib;
import net.ndrei.teslacorelib.gui.BasicTeslaGuiContainer;
import net.ndrei.teslacorelib.gui.IGuiContainerPiece;
import net.ndrei.teslacorelib.gui.ToggleButtonPiece;
import net.ndrei.teslacorelib.inventory.BoundingRectangle;
import net.ndrei.teslacorelib.netsync.SimpleNBTMessage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MobDuplicatorTile
extends WorkingAreaElectricMachine {
    private IFluidTank experienceTank;
    private ItemStackHandler mobTool;
    private boolean exactCopy;

    public MobDuplicatorTile() {
        super(MobDuplicatorTile.class.getName().hashCode());
    }

    @Override
    protected void initializeInventories() {
        super.initializeInventories();
        this.experienceTank = this.addFluidTank(FluidsRegistry.ESSENCE, 8000, EnumDyeColor.LIME, "Experience tank", new BoundingRectangle(50, 25, 18, 54));
        this.mobTool = new ItemStackHandler(1){

            protected void onContentsChanged(int slot) {
                MobDuplicatorTile.this.func_70296_d();
            }
        };
        this.addInventory((IItemHandler)new CustomColoredItemHandler((IItemHandler)this.mobTool, EnumDyeColor.ORANGE, "Mob imprisonment Tool", 93, 25, 1, 1){

            public boolean canInsertItem(int slot, ItemStack stack) {
                return stack.func_77973_b().equals((Object)ItemRegistry.mobImprisonmentToolItem) && ((MobImprisonmentToolItem)stack.func_77973_b()).containsEntity(stack);
            }

            public boolean canExtractItem(int slot) {
                return true;
            }
        });
        this.addInventoryToStorage(this.mobTool, "mob_replicator_tool");
        this.exactCopy = false;
    }

    @Override
    public AxisAlignedBB getWorkingArea() {
        return new AxisAlignedBB((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), (double)(this.field_174879_c.func_177958_n() + 1), (double)(this.field_174879_c.func_177956_o() + 1), (double)(this.field_174879_c.func_177952_p() + 1)).func_72314_b((double)this.getRadius(), (double)this.getHeight(), (double)this.getRadius());
    }

    @Override
    public float work() {
        if (WorkUtils.isDisabled(this.func_145838_q())) {
            return 0.0f;
        }
        if (!BlockRegistry.mobDuplicatorBlock.enableExactCopy) {
            this.exactCopy = false;
        }
        if (this.mobTool.getStackInSlot(0).func_190926_b()) {
            return 0.0f;
        }
        if (this.experienceTank.getFluid() == null) {
            return 0.0f;
        }
        ItemStack stack = this.mobTool.getStackInSlot(0);
        EntityLiving entity = (EntityLiving)((MobImprisonmentToolItem)stack.func_77973_b()).getEntityFromStack(stack, this.field_145850_b, BlockRegistry.mobDuplicatorBlock.enableExactCopy && this.exactCopy);
        if (BlockRegistry.mobDuplicatorBlock.blacklistedEntities.contains(EntityList.func_191301_a((Entity)entity).toString())) {
            return 0.0f;
        }
        int livingAround = this.field_145850_b.func_72872_a(entity.getClass(), new AxisAlignedBB((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), (double)(this.field_174879_c.func_177958_n() + 1), (double)(this.field_174879_c.func_177956_o() + 1), (double)(this.field_174879_c.func_177952_p() + 1)).func_186662_g(16.0)).size();
        if (livingAround > 32) {
            return 0.0f;
        }
        int canSpawn = (int)((float)(this.experienceTank.getFluid() == null ? 0 : this.experienceTank.getFluid().amount) / (entity.func_110143_aJ() * 4.0f));
        if (canSpawn == 0) {
            return 0.0f;
        }
        int spawnAmount = 1 + this.field_145850_b.field_73012_v.nextInt(Math.min(canSpawn, 4));
        List<BlockPos> blocks = BlockUtils.getBlockPosInAABB(this.getWorkingArea());
        int essenceNeeded = (int)(entity.func_110143_aJ() * (float)BlockRegistry.mobDuplicatorBlock.essenceNeeded);
        while (spawnAmount > 0) {
            if (this.experienceTank.getFluid() != null && this.experienceTank.getFluid().amount > essenceNeeded) {
                int tries;
                entity = (EntityLiving)((MobImprisonmentToolItem)stack.func_77973_b()).getEntityFromStack(stack, this.field_145850_b, BlockRegistry.mobDuplicatorBlock.enableExactCopy && this.exactCopy);
                Vec3d random = new Vec3d((Vec3i)blocks.get(this.field_145850_b.field_73012_v.nextInt(blocks.size())));
                random = random.func_72441_c(0.5, 0.0, 0.5);
                entity.func_70012_b(random.field_72450_a, random.field_72448_b, random.field_72449_c, this.field_145850_b.field_73012_v.nextFloat() * 360.0f, 0.0f);
                entity.func_184221_a(UUID.randomUUID());
                for (tries = 20; tries > 0 && !this.canEntitySpawn(entity); --tries) {
                    random = new Vec3d((Vec3i)blocks.get(this.field_145850_b.field_73012_v.nextInt(blocks.size())));
                    random = random.func_72441_c(0.5, 0.0, 0.5);
                    entity.func_70012_b(random.field_72450_a, random.field_72448_b, random.field_72449_c, this.field_145850_b.field_73012_v.nextFloat() * 360.0f, 0.0f);
                }
                if (tries <= 0) {
                    --spawnAmount;
                    continue;
                }
                entity.func_180482_a(this.field_145850_b.func_175649_E(this.field_174879_c), null);
                this.field_145850_b.func_72838_d((Entity)entity);
                if (entity != null) {
                    entity.func_70656_aK();
                    entity.func_110163_bv();
                }
                this.experienceTank.drain(essenceNeeded, true);
            }
            --spawnAmount;
        }
        return 1.0f;
    }

    @Override
    public List<IGuiContainerPiece> getGuiContainerPieces(BasicTeslaGuiContainer container) {
        List<IGuiContainerPiece> pieces = super.getGuiContainerPieces(container);
        if (BlockRegistry.mobDuplicatorBlock.enableExactCopy) {
            pieces.add((IGuiContainerPiece)new ToggleButtonPiece(120, 28, 13, 13, 0){

                protected void renderState(@NotNull BasicTeslaGuiContainer<?> basicTeslaGuiContainer, int i, @NotNull BoundingRectangle boundingRectangle) {
                }

                public void drawBackgroundLayer(@NotNull BasicTeslaGuiContainer<?> container, int guiX, int guiY, float partialTicks, int mouseX, int mouseY) {
                    super.drawBackgroundLayer(container, guiX, guiY, partialTicks, mouseX, mouseY);
                    container.field_146297_k.func_110434_K().func_110577_a(ClientProxy.GUI);
                    if (MobDuplicatorTile.this.exactCopy) {
                        container.drawTexturedRect(this.getLeft() - 1, this.getTop() - 1, 1, 72, 16, 16);
                    } else {
                        container.drawTexturedRect(this.getLeft() - 1, this.getTop() - 1, 1, 88, 16, 16);
                    }
                }

                protected void clicked() {
                    MobDuplicatorTile.this.exactCopy = !MobDuplicatorTile.this.exactCopy;
                    MobDuplicatorTile.this.sendStateToServer();
                }

                public void drawForegroundTopLayer(@NotNull BasicTeslaGuiContainer<?> container, int guiX, int guiY, int mouseX, int mouseY) {
                    super.drawForegroundTopLayer(container, guiX, guiY, mouseX, mouseY);
                    if (this.isInside(container, mouseX, mouseY)) {
                        container.drawTooltip(Arrays.asList(MobDuplicatorTile.this.exactCopy ? "Disable exact copy" : "Enable exact copy"), mouseX - guiX, mouseY - guiY);
                    }
                }
            });
        }
        return pieces;
    }

    public void sendStateToServer() {
        if (TeslaCoreLib.INSTANCE.isClientSide()) {
            NBTTagCompound compound = this.setupSpecialNBTMessage("EXACT_COPY");
            compound.func_74757_a("EXACT", this.exactCopy);
            this.sendToServer(compound);
        }
    }

    @Nullable
    protected SimpleNBTMessage processClientMessage(@Nullable String messageType, @NotNull NBTTagCompound compound) {
        super.processClientMessage(messageType, compound);
        if (messageType.equals("EXACT_COPY")) {
            this.exactCopy = compound.func_74767_n("EXACT");
        }
        return null;
    }

    @Override
    public void func_145839_a(@NotNull NBTTagCompound compound) {
        this.exactCopy = compound.func_74767_n("ExactCopy");
        super.func_145839_a(compound);
    }

    @Override
    @NotNull
    public NBTTagCompound func_189515_b(@NotNull NBTTagCompound compound) {
        NBTTagCompound compound1 = super.func_189515_b(compound);
        compound1.func_74757_a("ExactCopy", this.exactCopy);
        return compound1;
    }

    private boolean canEntitySpawn(EntityLiving living) {
        return this.field_145850_b.func_72855_b(living.func_174813_aQ()) && this.field_145850_b.func_184144_a((Entity)living, living.func_174813_aQ()).isEmpty() && (!this.field_145850_b.func_72953_d(living.func_174813_aQ()) || living.isCreatureType(EnumCreatureType.WATER_CREATURE, false));
    }
}

