/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.utils;

import com.buuz135.industrial.IndustrialForegoing;
import com.google.common.collect.HashMultimap;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.oredict.OreDictionary;
import org.lwjgl.opengl.GL11;

public class BlockUtils {
    private static HashMultimap<String, Block> oreDictBlocks = HashMultimap.create();

    public static List<BlockPos> getBlockPosInAABB(AxisAlignedBB axisAlignedBB) {
        ArrayList<BlockPos> blocks = new ArrayList<BlockPos>();
        for (double y = axisAlignedBB.field_72338_b; y < axisAlignedBB.field_72337_e; y += 1.0) {
            for (double x = axisAlignedBB.field_72340_a; x < axisAlignedBB.field_72336_d; x += 1.0) {
                for (double z = axisAlignedBB.field_72339_c; z < axisAlignedBB.field_72334_f; z += 1.0) {
                    blocks.add(new BlockPos(x, y, z));
                }
            }
        }
        return blocks;
    }

    public static boolean isBlockOreDict(World world, BlockPos pos, String ore) {
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (oreDictBlocks.containsEntry((Object)ore, (Object)block)) {
            return true;
        }
        Item item = Item.func_150898_a((Block)block);
        if (!item.equals(Items.field_190931_a)) {
            ItemStack stack = new ItemStack(item);
            int id = OreDictionary.getOreID((String)ore);
            for (int i : OreDictionary.getOreIDs((ItemStack)stack)) {
                if (i != id) continue;
                oreDictBlocks.put((Object)ore, (Object)block);
                return true;
            }
        }
        return false;
    }

    public static boolean isLog(World world, BlockPos pos) {
        return world.func_180495_p(pos).func_177230_c().isWood((IBlockAccess)world, pos) || BlockUtils.isBlockOreDict(world, pos, "blockSlimeCongealed");
    }

    public static boolean isLeaves(World world, BlockPos pos) {
        return world.func_180495_p(pos).func_177230_c().isLeaves(world.func_180495_p(pos), (IBlockAccess)world, pos);
    }

    public static boolean isChorus(World world, BlockPos pos) {
        return world.func_180495_p(pos).func_177230_c().equals(Blocks.field_185765_cR) || world.func_180495_p(pos).func_177230_c().equals(Blocks.field_185766_cS);
    }

    public static boolean canBlockBeBroken(World world, BlockPos pos) {
        BlockEvent.BreakEvent event = new BlockEvent.BreakEvent(world, pos, world.func_180495_p(pos), (EntityPlayer)IndustrialForegoing.getFakePlayer(world));
        MinecraftForge.EVENT_BUS.post((Event)event);
        return !event.isCanceled();
    }

    public static void renderLaserBeam(TileEntity tile, double x, double y, double z, EnumFacing direction, float partialTicks, int length) {
        Tessellator tess = Tessellator.func_178181_a();
        GlStateManager.func_179094_E();
        double tempX = x;
        double tempY = y;
        double tempZ = z;
        switch (direction) {
            case NORTH: {
                GlStateManager.func_179114_b((float)270.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                tempY = -z;
                tempZ = y;
                break;
            }
            case SOUTH: {
                GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                tempY = z + 1.0;
                tempZ = -y - 1.0;
                break;
            }
            case EAST: {
                GlStateManager.func_179114_b((float)270.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                tempY = x + 1.0;
                tempX = -y - 1.0;
                break;
            }
            case WEST: {
                GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                tempY = -x;
                tempX = y;
                break;
            }
            default: {
                tempY -= (double)length;
            }
        }
        RenderHelper.func_74518_a();
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
        GL11.glDisable((int)2884);
        GL11.glDisable((int)3042);
        GL11.glDepthMask((boolean)true);
        BufferBuilder buffer = tess.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        double d1 = (double)(-(tile.func_145831_w().func_72820_D() % 15L)) / 15.0;
        double d2 = (double)(tile.func_145831_w().func_72820_D() % 40L) / 2.0;
        double pointA = 0.45 - d2 / 200.0;
        if (d2 >= 10.0) {
            pointA = 0.35 + d2 / 200.0;
        }
        double pointB = 1.0 - pointA;
        double uStart = 0.0;
        double uEnd = 1.0;
        double vStart = -1.0 + d1;
        double vEnd = (double)(length * 2) + vStart;
        buffer.func_181662_b(tempX + pointA, tempY + (double)length, tempZ + pointA).func_187315_a(uEnd, vEnd).func_181675_d();
        buffer.func_181662_b(tempX + pointA, tempY, tempZ + pointA).func_187315_a(uEnd, vStart).func_181675_d();
        buffer.func_181662_b(tempX + pointB, tempY, tempZ + pointA).func_187315_a(uStart, vStart).func_181675_d();
        buffer.func_181662_b(tempX + pointB, tempY + (double)length, tempZ + pointA).func_187315_a(uStart, vEnd).func_181675_d();
        buffer.func_181662_b(tempX + pointB, tempY + (double)length, tempZ + pointB).func_187315_a(uEnd, vEnd).func_181675_d();
        buffer.func_181662_b(tempX + pointB, tempY, tempZ + pointB).func_187315_a(uEnd, vStart).func_181675_d();
        buffer.func_181662_b(tempX + pointA, tempY, tempZ + pointB).func_187315_a(uStart, vStart).func_181675_d();
        buffer.func_181662_b(tempX + pointA, tempY + (double)length, tempZ + pointB).func_187315_a(uStart, vEnd).func_181675_d();
        buffer.func_181662_b(tempX + pointB, tempY + (double)length, tempZ + pointA).func_187315_a(uEnd, vEnd).func_181675_d();
        buffer.func_181662_b(tempX + pointB, tempY, tempZ + pointA).func_187315_a(uEnd, vStart).func_181675_d();
        buffer.func_181662_b(tempX + pointB, tempY, tempZ + pointB).func_187315_a(uStart, vStart).func_181675_d();
        buffer.func_181662_b(tempX + pointB, tempY + (double)length, tempZ + pointB).func_187315_a(uStart, vEnd).func_181675_d();
        buffer.func_181662_b(tempX + pointA, tempY + (double)length, tempZ + pointB).func_187315_a(uEnd, vEnd).func_181675_d();
        buffer.func_181662_b(tempX + pointA, tempY, tempZ + pointB).func_187315_a(uEnd, vStart).func_181675_d();
        buffer.func_181662_b(tempX + pointA, tempY, tempZ + pointA).func_187315_a(uStart, vStart).func_181675_d();
        buffer.func_181662_b(tempX + pointA, tempY + (double)length, tempZ + pointA).func_187315_a(uStart, vEnd).func_181675_d();
        tess.func_78381_a();
        RenderHelper.func_74519_b();
        GL11.glEnable((int)2884);
        GlStateManager.func_179121_F();
    }
}

