/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.utils.apihandlers.plant;

import com.buuz135.industrial.api.plant.PlantRecollectable;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.BlockCactus;
import net.minecraft.block.BlockReed;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class DoubleTallPlantRecollectable
extends PlantRecollectable {
    public DoubleTallPlantRecollectable() {
        super("blocksugarandcactus");
    }

    @Override
    public boolean canBeHarvested(World world, BlockPos pos, IBlockState blockState) {
        return blockState.func_177230_c() instanceof BlockCactus || blockState.func_177230_c() instanceof BlockReed;
    }

    @Override
    public List<ItemStack> doHarvestOperation(World world, BlockPos pos, IBlockState blockState) {
        NonNullList stacks = NonNullList.func_191196_a();
        this.harvestBlock((NonNullList<ItemStack>)stacks, world, pos.func_177967_a(EnumFacing.UP, 2));
        this.harvestBlock((NonNullList<ItemStack>)stacks, world, pos.func_177967_a(EnumFacing.UP, 1));
        return stacks;
    }

    @Override
    public boolean shouldCheckNextPlant(World world, BlockPos pos, IBlockState blockState) {
        return true;
    }

    private void harvestBlock(NonNullList<ItemStack> stacks, World world, BlockPos pos) {
        if (this.canBeHarvested(world, pos, world.func_180495_p(pos))) {
            world.func_180495_p(pos).func_177230_c().getDrops(stacks, (IBlockAccess)world, pos, world.func_180495_p(pos), 0);
            world.func_175698_g(pos);
        }
    }

    @Override
    public List<String> getRecollectablesNames() {
        return Arrays.asList("text.industrialforegoing.plant.sugar_cane", "text.industrialforegoing.plant.cactus");
    }
}

