/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.utils.apihandlers.plant;

import com.buuz135.industrial.proxy.BlockRegistry;
import com.buuz135.industrial.utils.BlockUtils;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Stack;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IShearable;

public class TreeCache {
    private Queue<BlockPos> woodCache = new PriorityQueue<Object>(Comparator.comparingDouble(value -> ((BlockPos)value).func_177954_c((double)((BlockPos)value).func_177958_n(), (double)current.func_177956_o(), (double)((BlockPos)value).func_177952_p())).reversed());
    private Queue<BlockPos> leavesCache = new PriorityQueue<Object>(Comparator.comparingDouble(value -> ((BlockPos)value).func_177954_c((double)current.func_177958_n(), (double)((BlockPos)value).func_177956_o(), (double)current.func_177952_p())).reversed());
    private World world;
    private BlockPos current;

    public TreeCache(World world, BlockPos current) {
        this.world = world;
        this.current = current;
    }

    public List<ItemStack> chop(Queue<BlockPos> cache, boolean shear) {
        BlockPos p = cache.peek();
        NonNullList stacks = NonNullList.func_191196_a();
        if (BlockUtils.isLeaves(this.world, p) || BlockUtils.isLog(this.world, p)) {
            IBlockState s = this.world.func_180495_p(p);
            if (s.func_177230_c() instanceof IShearable && shear) {
                stacks.addAll((Collection)((IShearable)s.func_177230_c()).onSheared(new ItemStack((Item)Items.field_151097_aZ), (IBlockAccess)this.world, p, 0));
            } else {
                s.func_177230_c().getDrops(stacks, (IBlockAccess)this.world, p, s, 0);
            }
            this.world.func_175698_g(p);
        }
        cache.poll();
        return stacks;
    }

    public Queue<BlockPos> getWoodCache() {
        return this.woodCache;
    }

    public Queue<BlockPos> getLeavesCache() {
        return this.leavesCache;
    }

    public void scanForTreeBlockSection() {
        BlockPos yCheck = this.getHighestBlock(this.current);
        for (BlockPos pos : BlockPos.func_177980_a((BlockPos)yCheck.func_177982_a(1, 0, 0), (BlockPos)yCheck.func_177982_a(0, 0, 1))) {
            BlockPos tempHigh = this.getHighestBlock(pos);
            if (tempHigh.func_177956_o() <= yCheck.func_177956_o()) continue;
            yCheck = tempHigh;
        }
        yCheck = yCheck.func_177982_a(0, -Math.min(20, yCheck.func_177956_o() - this.current.func_177956_o()), 0);
        HashSet<BlockPos> checkedPositions = new HashSet<BlockPos>();
        Stack<BlockPos> tree = new Stack<BlockPos>();
        BlockPos test = new BlockPos(this.current.func_177958_n(), yCheck.func_177956_o(), this.current.func_177952_p());
        for (BlockPos pos : BlockPos.func_177980_a((BlockPos)test.func_177982_a(1, 0, 0), (BlockPos)test.func_177982_a(0, 0, 1))) {
            tree.push(pos);
        }
        while (!tree.isEmpty()) {
            BlockPos checking = (BlockPos)tree.pop();
            if (!BlockUtils.isLeaves(this.world, checking) && !BlockUtils.isLog(this.world, checking)) continue;
            for (BlockPos blockPos : BlockPos.func_177980_a((BlockPos)checking.func_177982_a(-1, 0, -1), (BlockPos)checking.func_177982_a(1, 1, 1))) {
                if (this.world.func_175623_d(blockPos) || checkedPositions.contains(blockPos) || blockPos.func_185332_f(this.current.func_177958_n(), this.current.func_177956_o(), this.current.func_177952_p()) > (double)BlockRegistry.cropRecolectorBlock.getMaxDistanceTreeBlocksScan()) continue;
                if (BlockUtils.isLeaves(this.world, blockPos)) {
                    tree.push(blockPos);
                    this.leavesCache.add(blockPos);
                    checkedPositions.add(blockPos);
                    continue;
                }
                if (!BlockUtils.isLog(this.world, blockPos)) continue;
                tree.push(blockPos);
                this.woodCache.add(blockPos);
                checkedPositions.add(blockPos);
            }
        }
    }

    public BlockPos getHighestBlock(BlockPos position) {
        while (!this.world.func_175623_d(position.func_177984_a()) && (BlockUtils.isLog(this.world, position.func_177984_a()) || BlockUtils.isLeaves(this.world, position.func_177984_a()))) {
            position = position.func_177984_a();
        }
        return position;
    }
}

